/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.util;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class AdaptiveSizeWriter {
    private static final float INITIAL_QUALITY = 1.0f;
    private volatile int size;
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private float quality = 1.0f;

    public AdaptiveSizeWriter(int size) {
        this.size = size;
    }

    public byte[] write(BufferedImage bi) {
        int m2 = this.size;
        int s = 0;
        int i2 = 0;
        do {
            if ((s = this.compress(bi, this.quality)) <= m2) continue;
            this.quality = (float)((double)this.quality * 0.75);
            if (i2++ >= 20) break;
        } while (s > m2);
        return this.baos.toByteArray();
    }

    private int compress(BufferedImage bi, float quality) {
        this.baos.reset();
        JPEGImageWriteParam params = new JPEGImageWriteParam(null);
        params.setCompressionMode(2);
        params.setCompressionQuality(quality);
        try (MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream(this.baos);){
            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
            writer.setOutput(mcios);
            writer.write(null, new IIOImage(bi, null, null), params);
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
        return this.baos.size();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (this.size != size) {
            this.size = size;
            this.quality = 1.0f;
        }
    }
}

