/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.util.jh;

import com.github.sarxos.webcam.util.jh.JHFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public class JHFlipFilter
extends JHFilter {
    public static final int FLIP_90CW = 4;
    public static final int FLIP_90CCW = 5;
    public static final int FLIP_180 = 6;
    private int operation;

    public JHFlipFilter() {
        this(4);
    }

    public JHFlipFilter(int operation) {
        this.setOperation(operation);
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public int getOperation() {
        return this.operation;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        int[] inPixels = this.getRGB(src, 0, 0, width, height, null);
        int w = width;
        int h2 = height;
        int newW = w;
        int newH = h2;
        switch (this.operation) {
            case 4: {
                newW = h2;
                newH = w;
                break;
            }
            case 5: {
                newW = h2;
                newH = w;
                break;
            }
        }
        int[] newPixels = new int[newW * newH];
        for (int row = 0; row < h2; ++row) {
            for (int col = 0; col < w; ++col) {
                int index = row * width + col;
                int newRow = row;
                int newCol = col;
                switch (this.operation) {
                    case 4: {
                        newRow = col;
                        newCol = h2 - row - 1;
                        break;
                    }
                    case 5: {
                        newRow = w - col - 1;
                        newCol = row;
                        break;
                    }
                    case 6: {
                        newRow = h2 - row - 1;
                        newCol = w - col - 1;
                    }
                }
                int newIndex = newRow * newW + newCol;
                newPixels[newIndex] = inPixels[index];
            }
        }
        if (dst == null) {
            ColorModel dstCM = src.getColorModel();
            dst = new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(newW, newH), dstCM.isAlphaPremultiplied(), null);
        }
        this.setRGB(dst, 0, 0, newW, newH, newPixels);
        return dst;
    }

    public String toString() {
        switch (this.operation) {
            case 4: {
                return "Rotate 90";
            }
            case 5: {
                return "Rotate -90";
            }
            case 6: {
                return "Rotate 180";
            }
        }
        return "Flip";
    }
}

