/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.util.jh;

import com.github.sarxos.webcam.util.jh.JHFilter;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class JHGrayFilter
extends JHFilter {
    protected boolean canFilterIndexColorModel = true;

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        int type = src.getType();
        WritableRaster srcRaster = src.getRaster();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        WritableRaster dstRaster = dst.getRaster();
        int[] inPixels = new int[width];
        for (int y = 0; y < height; ++y) {
            int x;
            if (type == 2) {
                srcRaster.getDataElements(0, y, width, 1, inPixels);
                for (x = 0; x < width; ++x) {
                    inPixels[x] = this.filterRGB(inPixels[x]);
                }
                dstRaster.setDataElements(0, y, width, 1, inPixels);
                continue;
            }
            src.getRGB(0, y, width, 1, inPixels, 0, width);
            for (x = 0; x < width; ++x) {
                inPixels[x] = this.filterRGB(inPixels[x]);
            }
            dst.setRGB(0, y, width, 1, inPixels, 0, width);
        }
        return dst;
    }

    private int filterRGB(int rgb) {
        int a2 = rgb & 0xFF000000;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b2 = rgb & 0xFF;
        rgb = r * 77 + g * 151 + b2 * 28 >> 8;
        return a2 | rgb << 16 | rgb << 8 | rgb;
    }
}

