/*
 * Decompiled with CFR 0.152.
 */
package com.j_phone.amuse.j3d;

import com.j_phone.amuse.j3d.AffineTrans;
import com.j_phone.amuse.j3d.Figure;
import com.j_phone.amuse.j3d.Texture;
import com.jblend.ui.SequenceInterface;
import emulator.Emulator;
import emulator.graphics2D.IImage;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import ru.woesss.j2me.micro3d.Render;

public abstract class Canvas3D
extends Canvas
implements SequenceInterface {
    private Texture texture;
    private Graphics graphics;
    private AffineTrans affine;
    private int scaleX = 512;
    private int scaleY = 512;
    private int centerX;
    private int centerY;
    private int clipX;
    private int clipY;
    private int clipWidth = this.getWidth();
    private int clipHeight = this.getHeight();

    public Canvas3D() {
        this.setAffineTrans(null);
    }

    public void setAffineTrans(AffineTrans t) {
        if (t == null) {
            t = new AffineTrans(4096, 0, 0, 0, 0, 4096, 0, 0, 0, 0, 4096, 0);
        }
        this.affine = t;
    }

    public void setScreenScale(int x_scale, int y_scale) {
        this.scaleX = x_scale;
        this.scaleY = y_scale;
    }

    public void setScreenCenter(int cx, int cy) {
        this.centerX = cx;
        this.centerY = cy;
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
    }

    public void drawFigure(Figure figure) {
        IImage img = Emulator.getEmulator().getScreen().getBackBufferImage();
        if (this.graphics == null) {
            this.graphics = new Graphics(img, null);
        } else {
            this.graphics._reset(img, null);
        }
        this.graphics.setClip(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        Render render = Render.getRender();
        render.bind(this.graphics, true);
        Canvas3D.getViewTrans(this.affine, render.getViewMatrix());
        render.setCenter(this.centerX, this.centerY);
        render.setOrthographicScale(this.scaleX, this.scaleY);
        if (this.texture != null) {
            render.setTexture(this.texture.impl);
        }
        if (figure != null) {
            render.drawFigure(figure.impl);
        }
        render.release();
    }

    public void setClipRect(int x, int y, int width, int height) {
        this.clipX = x;
        this.clipY = y;
        this.clipWidth = width;
        this.clipHeight = height;
    }

    @Override
    public void sequenceStart() {
    }

    @Override
    public void sequenceStop() {
    }

    private static void getViewTrans(AffineTrans a2, float[] out) {
        out[0] = (float)a2.m00 * 2.4414062E-4f;
        out[3] = (float)a2.m01 * 2.4414062E-4f;
        out[6] = (float)a2.m02 * 2.4414062E-4f;
        out[9] = a2.m03;
        out[1] = (float)a2.m10 * 2.4414062E-4f;
        out[4] = (float)a2.m11 * 2.4414062E-4f;
        out[7] = (float)a2.m12 * 2.4414062E-4f;
        out[10] = a2.m13;
        out[2] = (float)a2.m20 * 2.4414062E-4f;
        out[5] = (float)a2.m21 * 2.4414062E-4f;
        out[8] = (float)a2.m22 * 2.4414062E-4f;
        out[11] = a2.m23;
    }
}

