/*
 * Decompiled with CFR 0.152.
 */
package com.j_phone.util;

public class FixedPoint {
    private static final int PI = FixedPoint.fromDouble(Math.PI);
    private static final int MAX = Integer.MAX_VALUE;
    private static final int MIN = Integer.MIN_VALUE;
    int n;
    boolean infinite;

    public FixedPoint() {
    }

    public FixedPoint(int n) {
        this.n = n;
    }

    public int getInteger() {
        int i2 = this.n >> 16;
        if (i2 < 0 && (this.n & 0xFFFF) != 0) {
            ++i2;
        }
        return i2;
    }

    public int getDecimal() {
        int i2 = this.n & 0xFFFF;
        if (this.n >> 16 < 0) {
            i2 = -i2;
        }
        return i2;
    }

    public void setValue(int n) {
        this.n = n;
    }

    public FixedPoint add(FixedPoint other) {
        this.n = FixedPoint.add(this.n, other.n);
        return this;
    }

    public FixedPoint add(int other) {
        this.n = FixedPoint.add(this.n, other);
        return this;
    }

    public FixedPoint subtract(FixedPoint other) {
        this.n = FixedPoint.subtract(this.n, other.n);
        return this;
    }

    public FixedPoint subtract(int other) {
        this.n = FixedPoint.subtract(this.n, other);
        return this;
    }

    public FixedPoint multiply(FixedPoint other) {
        this.setDouble(this.toDouble() * other.toDouble());
        return this;
    }

    public FixedPoint multiply(int other) {
        this.setDouble(this.toDouble() * FixedPoint.toDouble(other));
        return this;
    }

    public FixedPoint divide(FixedPoint other) {
        this.setDouble(this.toDouble() / other.toDouble());
        return this;
    }

    public FixedPoint divide(int other) {
        this.setDouble(this.toDouble() / FixedPoint.toDouble(other));
        return this;
    }

    public FixedPoint sin(FixedPoint paramFixedPoint) {
        this.setDouble(Math.sin(paramFixedPoint.toDouble()));
        return this;
    }

    public FixedPoint cos(FixedPoint paramFixedPoint) {
        this.setDouble(Math.cos(paramFixedPoint.toDouble()));
        return this;
    }

    public FixedPoint tan(FixedPoint paramFixedPoint) {
        this.setDouble(Math.tan(paramFixedPoint.toDouble()));
        return this;
    }

    public FixedPoint asin(FixedPoint paramFixedPoint) {
        this.setDouble(Math.asin(paramFixedPoint.toDouble()));
        return this;
    }

    public FixedPoint acos(FixedPoint paramFixedPoint) {
        this.setDouble(Math.acos(paramFixedPoint.toDouble()));
        return this;
    }

    public FixedPoint atan(FixedPoint paramFixedPoint) {
        this.setDouble(Math.atan(paramFixedPoint.toDouble()));
        return this;
    }

    public FixedPoint sqrt() {
        this.setDouble(Math.sqrt(this.toDouble()));
        return this;
    }

    public FixedPoint inverse() {
        this.setDouble(1.0 / this.toDouble());
        return this;
    }

    public FixedPoint pow() {
        double a2 = this.toDouble();
        this.setDouble(a2 * a2);
        return this;
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public FixedPoint clone() {
        return new FixedPoint(this.n);
    }

    public static FixedPoint getPI() {
        return new FixedPoint(PI);
    }

    public static FixedPoint getMaximum() {
        return new FixedPoint(Integer.MAX_VALUE);
    }

    public static FixedPoint getMinimum() {
        return new FixedPoint(Integer.MIN_VALUE);
    }

    double toDouble() {
        return FixedPoint.toDouble(this.n);
    }

    static double toDouble(int n) {
        return (double)(n >> 16) + (double)(n & 0xFFFF) / 65536.0;
    }

    static int fromDouble(double f2) {
        if (f2 % 1.0 == 0.0) {
            return (int)f2 % 65535 << 16;
        }
        if (f2 < 0.0) {
            return (int)f2 - 1 << 16 | (int)(f2 % 1.0 * 65536.0) & 0xFFFF;
        }
        return (int)f2 % 65535 << 16 | (int)(f2 % 1.0 * 65536.0) & 0xFFFF;
    }

    void setDouble(double f2) {
        this.infinite = Double.isInfinite(f2);
        this.n = FixedPoint.fromDouble(f2);
    }

    static int add(int a2, int b2) {
        return (a2 >> 16) + (b2 >> 16) << 16 | (a2 & 0xFFFF) + (b2 & 0xFFFF);
    }

    static int subtract(int a2, int b2) {
        return FixedPoint.fromDouble(FixedPoint.toDouble(a2) - FixedPoint.toDouble(b2));
    }
}

