/*
 * Decompiled with CFR 0.152.
 */
package com.j_phone.util;

import com.j_phone.util.FixedPoint;

public class Vector2D {
    private int x;
    private int y;

    public Vector2D(FixedPoint x, FixedPoint y) {
        this.x = x.n;
        this.y = y.n;
    }

    public Vector2D(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D() {
    }

    public void add(Vector2D paramVector2D) {
        this.add(paramVector2D.x, paramVector2D.y);
    }

    public void add(int x, int y) {
        this.x = FixedPoint.add(this.x, x);
        this.y = FixedPoint.add(this.y, y);
    }

    public void subtract(Vector2D paramVector2D) {
        this.subtract(paramVector2D.x, paramVector2D.y);
    }

    public void subtract(int x, int y) {
        this.x = FixedPoint.subtract(this.x, x);
        this.y = FixedPoint.subtract(this.y, y);
    }

    public void normalize() {
        double x = FixedPoint.toDouble(this.x);
        double y = FixedPoint.toDouble(this.y);
        double len = Math.sqrt(x * x + y * y);
        this.x = FixedPoint.fromDouble(x /= len);
        this.y = FixedPoint.fromDouble(y /= len);
    }

    public static FixedPoint innerProduct(Vector2D v1, Vector2D v2) {
        double x1 = FixedPoint.toDouble(v1.x);
        double y1 = FixedPoint.toDouble(v1.y);
        double x2 = FixedPoint.toDouble(v2.x);
        double y2 = FixedPoint.toDouble(v2.y);
        return new FixedPoint(FixedPoint.fromDouble(x1 * x2 + y1 * y2));
    }

    public static FixedPoint outerProduct(Vector2D v1, Vector2D v2) {
        double x1 = FixedPoint.toDouble(v1.x);
        double y1 = FixedPoint.toDouble(v1.y);
        double x2 = FixedPoint.toDouble(v2.x);
        double y2 = FixedPoint.toDouble(v2.y);
        return new FixedPoint();
    }

    public void setValue(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setValue(FixedPoint x, FixedPoint y) {
        this.x = x.n;
        this.y = y.n;
    }

    public FixedPoint getX() {
        return new FixedPoint(this.x);
    }

    public FixedPoint getY() {
        return new FixedPoint(this.y);
    }

    public Vector2D clone() {
        return new Vector2D(this.x, this.y);
    }
}

