/*
 * Decompiled with CFR 0.152.
 */
package com.jblend.graphics.j3d;

import com.jblend.graphics.j3d.Light;
import com.jblend.graphics.j3d.Texture;

public class Effect3D {
    public static int NORMAL_SHADING = 0;
    public static int TOON_SHADING = 1;
    Light light;
    Texture texture;
    int shading;
    int toonHigh;
    int toonLow;
    int toonThreshold;
    boolean isTransparency;

    public Effect3D() {
        this.shading = NORMAL_SHADING;
        this.isTransparency = true;
    }

    public Effect3D(Light light, int shading, boolean isEnabled, Texture sphereMap) {
        this.setShading(shading);
        this.setSphereMap(sphereMap);
        this.setLight(light);
        this.isTransparency = isEnabled;
    }

    public Light getLight() {
        return this.light;
    }

    public int getShading() {
        return this.shading;
    }

    public Texture getSphereMap() {
        return this.texture;
    }

    public int getThreshold() {
        return this.toonThreshold;
    }

    public int getThresholdHigh() {
        return this.toonHigh;
    }

    public int getThresholdLow() {
        return this.toonLow;
    }

    public boolean isSemiTransparentEnabled() {
        return this.isTransparency;
    }

    public void setLight(Light light) {
        this.light = light;
    }

    public void setSemiTransparentEnabled(boolean isEnable) {
        this.isTransparency = isEnable;
    }

    public void setShading(int shading) {
        if ((shading & ~TOON_SHADING) != 0) {
            throw new IllegalArgumentException();
        }
        this.shading = shading;
    }

    public void setSphereMap(Texture texture) {
        if (texture != null && texture.isForModel) {
            throw new IllegalArgumentException();
        }
        this.texture = texture;
    }

    public void setThreshold(int threshold, int high, int low) {
        if ((threshold & 0xFFFFFF00 | high & 0xFFFFFF00 | low & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException();
        }
        this.toonThreshold = threshold;
        this.toonHigh = high;
        this.toonLow = low;
    }
}

