/*
 * Decompiled with CFR 0.152.
 */
package com.jblend.graphics.j3d;

import com.jblend.graphics.j3d.AffineTrans;
import com.jblend.graphics.j3d.Effect3D;
import com.jblend.graphics.j3d.Figure;
import com.jblend.graphics.j3d.FigureLayout;
import com.jblend.graphics.j3d.Light;
import com.jblend.graphics.j3d.Texture;
import com.jblend.graphics.j3d.Vector3D;
import java.util.WeakHashMap;
import javax.microedition.lcdui.Graphics;
import ru.woesss.j2me.micro3d.Render;
import ru.woesss.j2me.micro3d.TextureImpl;

public class RenderProxy {
    private static final WeakHashMap<Graphics, Render> renders = new WeakHashMap();

    public static void drawCommandList(Graphics g, Texture[] textures, int x, int y, FigureLayout layout, Effect3D effect, int[] commandList) {
        if (layout == null || effect == null || commandList == null) {
            throw new NullPointerException();
        }
        Render render = RenderProxy.getRender(g);
        RenderProxy.getViewTrans(layout.affine, render.getViewMatrix(), 0);
        RenderProxy.setTextureArray(render, textures);
        RenderProxy.setAffineArray(render, layout.affineArray);
        render.setCenter(layout.centerX + x, layout.centerY + y);
        RenderProxy.setProjection(render, layout);
        RenderProxy.setEffects(render, effect);
        render.drawCommandList(commandList);
    }

    public static void drawCommandList(Graphics g, Texture texture, int x, int y, FigureLayout layout, Effect3D effect, int[] commandList) {
        if (layout == null || effect == null || commandList == null) {
            throw new NullPointerException();
        }
        Render render = RenderProxy.getRender(g);
        RenderProxy.getViewTrans(layout.affine, render.getViewMatrix(), 0);
        RenderProxy.setAffineArray(render, layout.affineArray);
        render.setCenter(layout.centerX + x, layout.centerY + y);
        RenderProxy.setProjection(render, layout);
        RenderProxy.setEffects(render, effect);
        if (texture != null) {
            render.setTexture(texture.impl);
        }
        render.drawCommandList(commandList);
    }

    public static void drawFigure(Graphics g, Figure figure, int x, int y, FigureLayout layout, Effect3D effect) {
        if (figure == null || layout == null || effect == null) {
            throw new NullPointerException();
        }
        Render render = RenderProxy.getRender(g);
        RenderProxy.getViewTrans(layout.affine, render.getViewMatrix(), 0);
        render.setCenter(layout.centerX + x, layout.centerY + y);
        RenderProxy.setProjection(render, layout);
        RenderProxy.setEffects(render, effect);
        Texture texture = figure.textures[0];
        if (texture != null) {
            render.setTexture(texture.impl);
        }
        render.drawFigure(figure.impl);
    }

    public static void flush(Graphics g) {
        RenderProxy.getRender(g).flushToBuffer();
    }

    public static void renderFigure(Graphics g, Figure figure, int x, int y, FigureLayout layout, Effect3D effect) {
        if (figure == null || layout == null || effect == null) {
            throw new NullPointerException();
        }
        Render render = RenderProxy.getRender(g);
        RenderProxy.getViewTrans(layout.affine, render.getViewMatrix(), 0);
        RenderProxy.setTextureArray(render, figure.textures);
        render.setCenter(layout.centerX + x, layout.centerY + y);
        RenderProxy.setProjection(render, layout);
        RenderProxy.setEffects(render, effect);
        render.postFigure(figure.impl);
    }

    public static void renderPrimitives(Graphics g, Texture texture, int x, int y, FigureLayout layout, Effect3D effect, int command, int numPrimitives, int[] vertexCoords, int[] normals, int[] textureCoords, int[] colors) {
        if (layout == null || effect == null || vertexCoords == null || normals == null || textureCoords == null || colors == null) {
            throw new NullPointerException();
        }
        if (command < 0 || numPrimitives <= 0 || numPrimitives >= 256) {
            throw new IllegalArgumentException();
        }
        Render render = RenderProxy.getRender(g);
        RenderProxy.getViewTrans(layout.affine, render.getViewMatrix(), 0);
        render.setCenter(layout.centerX + x, layout.centerY + y);
        RenderProxy.setProjection(render, layout);
        RenderProxy.setEffects(render, effect);
        if (texture != null) {
            render.setTexture(texture.impl);
        }
        render.postPrimitives(command | numPrimitives << 16, vertexCoords, 0, normals, 0, textureCoords, 0, colors, 0);
    }

    private static Render getRender(Graphics g) {
        Render render = renders.get(g);
        if (render == null) {
            render = new Render();
            render.bind(g, false);
            renders.put(g, render);
        }
        return render;
    }

    private static void getViewTrans(AffineTrans a2, float[] out, int n) {
        int offset = n * 12;
        out[offset++] = (float)a2.m00 * 2.4414062E-4f;
        out[offset++] = (float)a2.m10 * 2.4414062E-4f;
        out[offset++] = (float)a2.m20 * 2.4414062E-4f;
        out[offset++] = (float)a2.m01 * 2.4414062E-4f;
        out[offset++] = (float)a2.m11 * 2.4414062E-4f;
        out[offset++] = (float)a2.m21 * 2.4414062E-4f;
        out[offset++] = (float)a2.m02 * 2.4414062E-4f;
        out[offset++] = (float)a2.m12 * 2.4414062E-4f;
        out[offset++] = (float)a2.m22 * 2.4414062E-4f;
        out[offset++] = a2.m03;
        out[offset++] = a2.m13;
        out[offset] = a2.m23;
    }

    private static void setTextureArray(Render render, Texture[] textures) {
        int len;
        if (textures != null && (len = textures.length) > 0) {
            if (len > 16) {
                len = 16;
            }
            TextureImpl[] texArray = new TextureImpl[len];
            for (int i2 = 0; i2 < len; ++i2) {
                Texture texture = textures[i2];
                if (texture == null) {
                    throw new NullPointerException();
                }
                texArray[i2] = texture.impl;
            }
            render.setTextureArray(texArray);
        }
    }

    private static void setEffects(Render render, Effect3D effect) {
        int attrs = render.getAttributes();
        Light light = effect.light;
        if (light != null) {
            int ambIntensity = light.ambIntensity;
            int dirIntensity = light.dirIntensity;
            Vector3D dir = light.direction;
            render.setLight(ambIntensity, dirIntensity, dir.x, dir.y, dir.z);
            attrs |= 1;
        } else {
            attrs &= 0xFFFFFFFE;
        }
        int shading = effect.shading;
        if (shading == Effect3D.TOON_SHADING) {
            attrs |= 4;
            render.setToonParam(effect.toonThreshold, effect.toonHigh, effect.toonLow);
        } else {
            attrs &= 0xFFFFFFFB;
        }
        boolean isBlend = effect.isTransparency;
        attrs = isBlend ? (attrs |= 8) : (attrs &= 0xFFFFFFF7);
        Texture specular = effect.texture;
        if (specular != null) {
            attrs |= 2;
            render.setSphereTexture(specular.impl);
        } else {
            attrs &= 0xFFFFFFFD;
        }
        render.setAttribute(attrs);
    }

    private static void setProjection(Render render, FigureLayout layout) {
        switch (layout.projection) {
            case -1879048192: {
                int sx = layout.scaleX;
                int sy = layout.scaleY;
                render.setOrthographicScale(sx, sy);
                break;
            }
            case -1862270976: {
                int w = layout.parallelWidth;
                int h2 = layout.parallelHeight;
                render.setOrthographicWH(w, h2);
                break;
            }
            case -1845493760: {
                int near = layout.near;
                int far = layout.far;
                int angle = layout.angle;
                render.setPerspectiveFov(near, far, angle);
                break;
            }
            case -1828716544: {
                int w = layout.perspectiveWidth;
                int h3 = layout.perspectiveHeight;
                int near = layout.near;
                int far = layout.far;
                render.setPerspectiveWH(near, far, w, h3);
                break;
            }
        }
    }

    private static void setAffineArray(Render render, AffineTrans[] affineArray) {
        if (affineArray != null) {
            int len = affineArray.length;
            float[] transArray = new float[len * 12];
            for (int i2 = 0; i2 < len; ++i2) {
                RenderProxy.getViewTrans(affineArray[i2], transArray, i2);
            }
            render.setViewTransArray(transArray);
        }
    }
}

