/*
 * Decompiled with CFR 0.152.
 */
package com.jblend.graphics.j3d;

import ru.woesss.j2me.micro3d.MathUtil;

public class Vector3D {
    public int x;
    public int y;
    public int z;

    public Vector3D() {
    }

    public Vector3D(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int innerProduct(Vector3D v) {
        if (v == null) {
            throw new NullPointerException();
        }
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public static int innerProduct(Vector3D v1, Vector3D v2) {
        if (v1 == null) {
            throw new NullPointerException();
        }
        return v1.innerProduct(v2);
    }

    public void outerProduct(Vector3D v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int x = this.x;
        int y = this.y;
        int z = this.z;
        this.x = y * v.z - z * v.y;
        this.y = z * v.x - x * v.z;
        this.z = x * v.y - y * v.x;
    }

    public static Vector3D outerProduct(Vector3D v1, Vector3D v2) {
        if (v1 == null || v2 == null) {
            throw new NullPointerException();
        }
        int x = v1.y * v2.z - v1.z * v2.y;
        int y = v1.z * v2.x - v1.x * v2.z;
        int z = v1.x * v2.y - v1.y * v2.x;
        return new Vector3D(x, y, z);
    }

    public void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void unit() {
        int x = this.x;
        int y = this.y;
        int z = this.z;
        int shift = Integer.numberOfLeadingZeros(Math.abs(x) | Math.abs(y) | Math.abs(z)) - 17;
        if (shift > 0) {
            x <<= shift;
            y <<= shift;
            z <<= shift;
        } else if (shift < 0) {
            shift = -shift;
            x >>= shift;
            y >>= shift;
            z >>= shift;
        }
        int i2 = MathUtil.uSqrt(x * x + y * y + z * z);
        if (i2 != 0) {
            this.x = (x << 12) / i2;
            this.y = (y << 12) / i2;
            this.z = (z << 12) / i2;
        } else {
            this.x = 0;
            this.y = 0;
            this.z = 4096;
        }
    }
}

