/*
 * Decompiled with CFR 0.152.
 */
package com.mascotcapsule.micro3d.v3;

import com.mascotcapsule.micro3d.v3.AffineTrans;
import com.mascotcapsule.micro3d.v3.Effect3D;
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.Light;
import com.mascotcapsule.micro3d.v3.Texture;
import com.mascotcapsule.micro3d.v3.Vector3D;
import ru.woesss.j2me.micro3d.Render;
import ru.woesss.j2me.micro3d.TextureImpl;

public class RenderProxy {
    static void getViewTrans(AffineTrans a2, float[] out, int n) {
        int offset = n * 12;
        out[offset++] = (float)a2.m00 * 2.4414062E-4f;
        out[offset++] = (float)a2.m10 * 2.4414062E-4f;
        out[offset++] = (float)a2.m20 * 2.4414062E-4f;
        out[offset++] = (float)a2.m01 * 2.4414062E-4f;
        out[offset++] = (float)a2.m11 * 2.4414062E-4f;
        out[offset++] = (float)a2.m21 * 2.4414062E-4f;
        out[offset++] = (float)a2.m02 * 2.4414062E-4f;
        out[offset++] = (float)a2.m12 * 2.4414062E-4f;
        out[offset++] = (float)a2.m22 * 2.4414062E-4f;
        out[offset++] = a2.m03;
        out[offset++] = a2.m13;
        out[offset] = a2.m23;
    }

    static void setTextureArray(Render render, Texture[] textures) {
        int len;
        if (textures != null && (len = textures.length) > 0) {
            if (len > 16) {
                len = 16;
            }
            TextureImpl[] texArray = new TextureImpl[len];
            for (int i2 = 0; i2 < len; ++i2) {
                Texture texture = textures[i2];
                if (texture == null) {
                    throw new NullPointerException();
                }
                texArray[i2] = texture.impl;
            }
            render.setTextureArray(texArray);
        }
    }

    static void setEffects(Render render, Effect3D effect) {
        int attrs = render.getAttributes();
        Light light = effect.light;
        if (light != null) {
            int ambIntencity = light.ambIntensity;
            int dirIntensity = light.dirIntensity;
            Vector3D dir = light.direction;
            render.setLight(ambIntencity, dirIntensity, dir.x, dir.y, dir.z);
            attrs |= 1;
        } else {
            attrs &= 0xFFFFFFFE;
        }
        int shading = effect.shading;
        if (shading == 1) {
            attrs |= 4;
            render.setToonParam(effect.toonThreshold, effect.toonHigh, effect.toonLow);
        } else {
            attrs &= 0xFFFFFFFB;
        }
        boolean isBlend = effect.isTransparency;
        attrs = isBlend ? (attrs |= 8) : (attrs &= 0xFFFFFFF7);
        Texture specular = effect.texture;
        if (specular != null) {
            attrs |= 2;
            render.setSphereTexture(specular.impl);
        } else {
            attrs &= 0xFFFFFFFD;
        }
        render.setAttribute(attrs);
    }

    static void setProjection(Render render, FigureLayout layout) {
        switch (layout.projection) {
            case -1879048192: {
                int sx = layout.scaleX;
                int sy = layout.scaleY;
                render.setOrthographicScale(sx, sy);
                break;
            }
            case -1862270976: {
                int w = layout.parallelWidth;
                int h2 = layout.parallelHeight;
                render.setOrthographicWH(w, h2);
                break;
            }
            case -1845493760: {
                int near = layout.near;
                int far = layout.far;
                int angle = layout.angle;
                render.setPerspectiveFov(near, far, angle);
                break;
            }
            case -1828716544: {
                int w = layout.perspectiveWidth;
                int h3 = layout.perspectiveHeight;
                int near = layout.near;
                int far = layout.far;
                render.setPerspectiveWH(near, far, w, h3);
                break;
            }
        }
    }

    static void setAffineArray(Render render, AffineTrans[] affineArray) {
        if (affineArray != null) {
            int len = affineArray.length;
            float[] transArray = new float[len * 12];
            for (int i2 = 0; i2 < len; ++i2) {
                RenderProxy.getViewTrans(affineArray[i2], transArray, i2);
            }
            render.setViewTransArray(transArray);
        }
    }
}

