/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.graphics.j3d;

import com.motorola.graphics.j3d.Light;
import com.motorola.graphics.j3d.Texture;

public class Effect3D {
    public static final int NORMAL_SHADING = 0;
    public static final int TOON_SHADING = 1;
    Light light;
    Texture texture;
    int shading;
    int toonHigh;
    int toonLow;
    int toonThreshold;
    boolean isTransparency;

    public Effect3D() {
        this.shading = 0;
        this.isTransparency = true;
    }

    public Effect3D(Light light, int shading, boolean isEnabled, Texture sphereMap) {
        this.setShading(shading);
        this.setSphereMap(sphereMap);
        this.setLight(light);
        this.isTransparency = isEnabled;
    }

    public Light getLight() {
        return this.light;
    }

    public int getShading() {
        return this.shading;
    }

    public Texture getSphereMap() {
        return this.texture;
    }

    public final int getThreshold() {
        return this.toonThreshold;
    }

    public final int getThresholdHigh() {
        return this.toonHigh;
    }

    public final int getThresholdLow() {
        return this.toonLow;
    }

    public final boolean isSemiTransparentEnabled() {
        return this.isTransparency;
    }

    public void setLight(Light light) {
        this.light = light;
    }

    public final void setSemiTransparentEnabled(boolean isEnable) {
        this.isTransparency = isEnable;
    }

    public final void setShading(int shading) {
        if ((shading & 0xFFFFFFFE) != 0) {
            throw new IllegalArgumentException();
        }
        this.shading = shading;
    }

    public void setSphereMap(Texture texture) {
        if (texture != null && texture.isForModel) {
            throw new IllegalArgumentException();
        }
        this.texture = texture;
    }

    public final void setThreshold(int threshold, int high, int low) {
        if ((threshold & 0xFFFFFF00 | high & 0xFFFFFF00 | low & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException();
        }
        this.toonThreshold = threshold;
        this.toonHigh = high;
        this.toonLow = low;
    }
}

