/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.graphics.j3d;

import com.motorola.graphics.j3d.AffineTrans;
import com.motorola.graphics.j3d.Effect3D;
import com.motorola.graphics.j3d.Figure;
import com.motorola.graphics.j3d.FigureLayout;
import com.motorola.graphics.j3d.Light;
import com.motorola.graphics.j3d.Texture;
import com.motorola.graphics.j3d.Vector3D;
import javax.microedition.lcdui.Graphics;
import ru.woesss.j2me.micro3d.Render;

public class RenderProxy {
    public static void drawFigure(Graphics g, Figure figure, int x, int y, FigureLayout layout, Effect3D effect) {
        if (figure == null || layout == null || effect == null) {
            throw new NullPointerException();
        }
        Render render = Render.getRender();
        render.bind(g, false);
        RenderProxy.getViewTrans(layout.affine, render.getViewMatrix());
        render.setCenter(layout.centerX + x, layout.centerY + y);
        render.setOrthographicScale(layout.scaleX, layout.scaleY);
        int attrs = render.getAttributes();
        Light light = effect.light;
        if (light != null) {
            attrs |= 1;
            Vector3D dir = light.direction;
            render.setLight(light.ambIntensity, light.dirIntensity, dir.x, dir.y, dir.z);
        } else {
            attrs &= 0xFFFFFFFE;
        }
        int shading = effect.shading;
        if (shading == 1) {
            attrs |= 4;
            int tress = effect.toonThreshold;
            int high = effect.toonHigh;
            int low = effect.toonLow;
            render.setToonParam(tress, high, low);
        } else {
            attrs &= 0xFFFFFFFB;
        }
        attrs = effect.isTransparency ? (attrs |= 8) : (attrs &= 0xFFFFFFF7);
        Texture specular = effect.texture;
        if (specular != null) {
            attrs |= 2;
            render.setSphereTexture(specular.impl);
        } else {
            attrs &= 0xFFFFFFFD;
        }
        render.setAttribute(attrs);
        Texture texture = figure.texture;
        if (texture != null) {
            render.setTexture(texture.impl);
        }
        render.drawFigure(figure.impl);
        render.release();
    }

    private static void getViewTrans(AffineTrans a2, float[] out) {
        out[0] = (float)a2.m00 * 2.4414062E-4f;
        out[3] = (float)a2.m01 * 2.4414062E-4f;
        out[6] = (float)a2.m02 * 2.4414062E-4f;
        out[9] = a2.m03;
        out[1] = (float)a2.m10 * 2.4414062E-4f;
        out[4] = (float)a2.m11 * 2.4414062E-4f;
        out[7] = (float)a2.m12 * 2.4414062E-4f;
        out[10] = a2.m13;
        out[2] = (float)a2.m20 * 2.4414062E-4f;
        out[5] = (float)a2.m21 * 2.4414062E-4f;
        out[8] = (float)a2.m22 * 2.4414062E-4f;
        out[11] = a2.m23;
    }
}

