/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.iden.micro3d;

import com.motorola.iden.micro3d.Vector3D;
import ru.woesss.j2me.micro3d.MathUtil;

public class AffineTransform {
    public static final int M00 = 0;
    public static final int M01 = 1;
    public static final int M02 = 2;
    public static final int M03 = 3;
    public static final int M10 = 4;
    public static final int M11 = 5;
    public static final int M12 = 6;
    public static final int M13 = 7;
    public static final int M20 = 8;
    public static final int M21 = 9;
    public static final int M22 = 10;
    public static final int M23 = 11;
    public static final int MAX_VALUE = Short.MAX_VALUE;
    public static final int MIN_VALUE = Short.MIN_VALUE;
    int m00;
    int m01;
    int m02;
    int m03;
    int m10;
    int m11;
    int m12;
    int m13;
    int m20;
    int m21;
    int m22;
    int m23;

    public AffineTransform() {
    }

    public AffineTransform(int[][] elements) {
        this.set(elements);
    }

    public int get(int fieldID) {
        switch (fieldID) {
            case 0: {
                return this.m00;
            }
            case 1: {
                return this.m01;
            }
            case 2: {
                return this.m02;
            }
            case 3: {
                return this.m03;
            }
            case 4: {
                return this.m10;
            }
            case 5: {
                return this.m11;
            }
            case 6: {
                return this.m12;
            }
            case 7: {
                return this.m13;
            }
            case 8: {
                return this.m20;
            }
            case 9: {
                return this.m21;
            }
            case 10: {
                return this.m22;
            }
            case 11: {
                return this.m23;
            }
        }
        throw new IllegalArgumentException();
    }

    public static AffineTransform getViewPointTransform(Vector3D position, Vector3D look, Vector3D up) {
        if (position == null || look == null || up == null) {
            throw new NullPointerException();
        }
        AffineTransform a2 = new AffineTransform();
        int mpx = -position.x;
        int mpy = -position.y;
        int mpz = -position.z;
        Vector3D tmp = Vector3D.outerProduct(look, up);
        if (tmp.isZero()) {
            throw new IllegalArgumentException();
        }
        tmp.normalize();
        a2.m00 = tmp.x;
        a2.m01 = tmp.y;
        a2.m02 = tmp.z;
        a2.m03 = mpx * tmp.x + mpy * tmp.y + mpz * tmp.z + 2048 >> 12;
        tmp = Vector3D.outerProduct(look, tmp);
        tmp.normalize();
        a2.m10 = tmp.x;
        a2.m11 = tmp.y;
        a2.m12 = tmp.z;
        a2.m13 = mpx * tmp.x + mpy * tmp.y + mpz * tmp.z + 2048 >> 12;
        tmp.set(look);
        tmp.normalize();
        a2.m20 = tmp.x;
        a2.m21 = tmp.y;
        a2.m22 = tmp.z;
        a2.m23 = mpx * tmp.x + mpy * tmp.y + mpz * tmp.z + 2048 >> 12;
        return a2;
    }

    public void multiply(AffineTransform multiplier) {
        this.mulA2(this, multiplier);
    }

    public static AffineTransform multiply(AffineTransform multiplicand, AffineTransform multiplier) {
        AffineTransform result = new AffineTransform();
        result.mulA2(multiplicand, multiplier);
        return result;
    }

    public static void multiply(AffineTransform destination, AffineTransform multiplicand, AffineTransform multiplier) {
        destination.mulA2(multiplicand, multiplier);
    }

    public void normalize() {
        if ((this.m00 & this.m01 & this.m02 & this.m10 & this.m11 & this.m12 & this.m20 & this.m21 & this.m22) == 0) {
            return;
        }
        Vector3D fv = new Vector3D(this.m00, this.m10, this.m20);
        fv.normalize();
        this.m00 = fv.x;
        this.m10 = fv.y;
        this.m20 = fv.z;
        Vector3D sv = new Vector3D(this.m01, this.m11, this.m21);
        sv = Vector3D.outerProduct(fv, sv);
        sv.normalize();
        this.m02 = sv.x;
        this.m12 = sv.y;
        this.m22 = sv.z;
        sv.outerProduct(fv);
        this.m01 = sv.x >> 12;
        this.m11 = sv.y >> 12;
        this.m21 = sv.z >> 12;
    }

    public void rotateV(Vector3D axis, int angle) {
        if (axis == null) {
            throw new NullPointerException();
        }
        int x = axis.x;
        int y = axis.y;
        int z = axis.z;
        int cos = MathUtil.iCos(angle);
        int sin = MathUtil.iSin(angle);
        int xs = x * sin + 2048 >> 12;
        int ys = y * sin + 2048 >> 12;
        int zs = z * sin + 2048 >> 12;
        int nc = 4096 - cos;
        int xync = (x * y + 2048 >> 12) * nc + 2048 >> 12;
        int yznc = (y * z + 2048 >> 12) * nc + 2048 >> 12;
        int zxnc = (x * z + 2048 >> 12) * nc + 2048 >> 12;
        this.m00 = cos + ((x * x + 2048 >> 12) * nc + 2048 >> 12);
        this.m01 = xync - zs;
        this.m02 = zxnc + ys;
        this.m10 = xync + zs;
        this.m11 = cos + ((y * y + 2048 >> 12) * nc + 2048 >> 12);
        this.m20 = zxnc - ys;
        this.m12 = yznc - xs;
        this.m21 = yznc + xs;
        this.m22 = cos + ((z * z + 2048 >> 12) * nc + 2048 >> 12);
    }

    public void rotateX(int angle) {
        int cos = MathUtil.iCos(angle);
        int sin = MathUtil.iSin(angle);
        this.m00 = 4096;
        this.m01 = 0;
        this.m02 = 0;
        this.m10 = 0;
        this.m11 = cos;
        this.m12 = -sin;
        this.m20 = 0;
        this.m21 = sin;
        this.m22 = cos;
    }

    public void rotateY(int angle) {
        int cos = MathUtil.iCos(angle);
        int sin = MathUtil.iSin(angle);
        this.m00 = cos;
        this.m01 = 0;
        this.m02 = sin;
        this.m10 = 0;
        this.m11 = 4096;
        this.m12 = 0;
        this.m20 = -sin;
        this.m21 = 0;
        this.m22 = cos;
    }

    public void rotateZ(int angle) {
        int cos = MathUtil.iCos(angle);
        int sin = MathUtil.iSin(angle);
        this.m00 = cos;
        this.m01 = -sin;
        this.m02 = 0;
        this.m10 = sin;
        this.m11 = cos;
        this.m12 = 0;
        this.m20 = 0;
        this.m21 = 0;
        this.m22 = 4096;
    }

    public void set(int[][] elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        if (elements.length < 3) {
            throw new IllegalArgumentException();
        }
        if (elements[0].length < 4 || elements[1].length < 4 || elements[2].length < 4) {
            throw new IllegalArgumentException();
        }
        this.m00 = MathUtil.clamp(elements[0][0], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m01 = MathUtil.clamp(elements[0][1], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m02 = MathUtil.clamp(elements[0][2], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m03 = MathUtil.clamp(elements[0][3], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m10 = MathUtil.clamp(elements[1][0], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m11 = MathUtil.clamp(elements[1][1], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m12 = MathUtil.clamp(elements[1][2], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m13 = MathUtil.clamp(elements[1][3], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m20 = MathUtil.clamp(elements[2][0], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m21 = MathUtil.clamp(elements[2][1], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m22 = MathUtil.clamp(elements[2][2], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m23 = MathUtil.clamp(elements[2][3], Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public void set(int fieldID, int value) {
        switch (fieldID) {
            case 0: {
                this.m00 = MathUtil.clamp(value, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 1: {
                this.m01 = MathUtil.clamp(value, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 2: {
                this.m02 = MathUtil.clamp(value, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 3: {
                this.m03 = MathUtil.clamp(value, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 4: {
                this.m10 = MathUtil.clamp(value, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 5: {
                this.m11 = MathUtil.clamp(value, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 6: {
                this.m12 = MathUtil.clamp(value, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 7: {
                this.m13 = MathUtil.clamp(value, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 8: {
                this.m20 = MathUtil.clamp(value, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 9: {
                this.m21 = MathUtil.clamp(value, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 10: {
                this.m22 = MathUtil.clamp(value, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 11: {
                this.m23 = MathUtil.clamp(value, Short.MIN_VALUE, Short.MAX_VALUE);
            }
        }
        throw new IllegalArgumentException();
    }

    public void setIdentity() {
        this.m00 = 4096;
        this.m01 = 0;
        this.m02 = 0;
        this.m03 = 0;
        this.m10 = 0;
        this.m11 = 4096;
        this.m12 = 0;
        this.m13 = 0;
        this.m20 = 0;
        this.m21 = 0;
        this.m22 = 4096;
        this.m23 = 0;
    }

    public Vector3D transformPoint(Vector3D source) {
        if (source == null) {
            throw new NullPointerException();
        }
        Vector3D r = new Vector3D();
        r.x = (source.x * this.m00 + source.y * this.m01 + source.z * this.m02 + 2048 >> 12) + this.m03;
        r.y = (source.x * this.m10 + source.y * this.m11 + source.z * this.m12 + 2048 >> 12) + this.m13;
        r.z = (source.x * this.m20 + source.y * this.m21 + source.z * this.m22 + 2048 >> 12) + this.m23;
        return r;
    }

    private void mulA2(AffineTransform a1, AffineTransform a2) {
        int l00 = a1.m00;
        int l01 = a1.m01;
        int l02 = a1.m02;
        int l10 = a1.m10;
        int l11 = a1.m11;
        int l12 = a1.m12;
        int l20 = a1.m20;
        int l21 = a1.m21;
        int l22 = a1.m22;
        int r00 = a2.m00;
        int r01 = a2.m01;
        int r02 = a2.m02;
        int r03 = a2.m03;
        int r10 = a2.m10;
        int r11 = a2.m11;
        int r12 = a2.m12;
        int r13 = a2.m13;
        int r20 = a2.m20;
        int r21 = a2.m21;
        int r22 = a2.m22;
        int r23 = a2.m23;
        this.m00 = l00 * r00 + l01 * r10 + l02 * r20 + 2048 >> 12;
        this.m01 = l00 * r01 + l01 * r11 + l02 * r21 + 2048 >> 12;
        this.m02 = l00 * r02 + l01 * r12 + l02 * r22 + 2048 >> 12;
        this.m03 = (l00 * r03 + l01 * r13 + l02 * r23 + 2048 >> 12) + a1.m03;
        this.m10 = l10 * r00 + l11 * r10 + l12 * r20 + 2048 >> 12;
        this.m11 = l10 * r01 + l11 * r11 + l12 * r21 + 2048 >> 12;
        this.m12 = l10 * r02 + l11 * r12 + l12 * r22 + 2048 >> 12;
        this.m13 = (l10 * r03 + l11 * r13 + l12 * r23 + 2048 >> 12) + a1.m13;
        this.m20 = l20 * r00 + l21 * r10 + l22 * r20 + 2048 >> 12;
        this.m21 = l20 * r01 + l21 * r11 + l22 * r21 + 2048 >> 12;
        this.m22 = l20 * r02 + l21 * r12 + l22 * r22 + 2048 >> 12;
        this.m23 = (l20 * r03 + l21 * r13 + l22 * r23 + 2048 >> 12) + a1.m23;
    }
}

