/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.iden.micro3d;

import com.motorola.iden.micro3d.AffineTransform;
import com.motorola.iden.micro3d.Light;
import com.motorola.iden.micro3d.Vector3D;

public class Layout3D {
    public static final int PARALLEL_SCALE = 24;
    public static final int PARALLEL_WIDTH = 25;
    public static final int PARALLEL_WIDTH_HEIGHT = 26;
    public static final int PERSPECTIVE_FOV = 21;
    public static final int PERSPECTIVE_WIDTH = 22;
    public static final int PERSPECTIVE_WIDTH_HEIGHT = 23;
    Light light;
    boolean isSemiTransparent;
    boolean isToonShaded;
    int toonThreshold;
    int toonHighColor;
    int toonLowColor;
    private AffineTransform viewPointTransform;
    private AffineTransform viewTransform;
    int projectionType = 24;
    final int[] projectionParameters = new int[]{4096, 4096, 0, 0};
    Vector3D rotateAxis;
    int rotateAngle;

    public Light getLight() {
        return this.light;
    }

    public int[] getProjectionParameters() {
        int[] parameters = this.projectionParameters;
        switch (this.projectionType) {
            case 24: 
            case 26: {
                return new int[]{parameters[0], parameters[1]};
            }
            case 25: {
                return new int[]{parameters[0]};
            }
            case 21: 
            case 22: {
                return new int[]{parameters[0], parameters[1], parameters[2]};
            }
            case 23: {
                return new int[]{parameters[0], parameters[1], parameters[2], parameters[3]};
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.projectionType);
    }

    public int getProjectionType() {
        return this.projectionType;
    }

    public int getToonHighColor() {
        return this.toonHighColor;
    }

    public int getToonLowColor() {
        return this.toonLowColor;
    }

    public int getToonThreshold() {
        return this.toonThreshold;
    }

    public AffineTransform getViewPointTransform() {
        if (this.viewPointTransform == null) {
            Vector3D position = new Vector3D();
            Vector3D look = new Vector3D(0, 0, 4096);
            Vector3D up = new Vector3D(0, 4096, 0);
            this.viewPointTransform = AffineTransform.getViewPointTransform(position, look, up);
        }
        return this.viewPointTransform;
    }

    public AffineTransform getViewTransform() {
        return this.viewTransform;
    }

    public boolean isSemiTransparent() {
        return this.isSemiTransparent;
    }

    public boolean isToonShaded() {
        return this.isToonShaded;
    }

    public void rotateV(Vector3D axis, int angle) {
        this.rotateAngle = angle;
        if (this.rotateAxis == null) {
            this.rotateAxis = new Vector3D(axis);
        } else {
            this.rotateAxis.set(axis);
        }
        this.viewTransform = null;
    }

    public void rotateX(int angle) {
        if (this.rotateAxis == null) {
            this.rotateAxis = new Vector3D(4096, 0, 0);
        } else {
            this.rotateAxis.set(4096, 0, 0);
        }
        this.rotateAngle = angle;
        this.viewTransform = null;
    }

    public void rotateY(int angle) {
        if (this.rotateAxis == null) {
            this.rotateAxis = new Vector3D(0, 4096, 0);
        } else {
            this.rotateAxis.set(0, 4096, 0);
        }
        this.rotateAngle = angle;
        this.viewTransform = null;
    }

    public void rotateZ(int angle) {
        if (this.rotateAxis == null) {
            this.rotateAxis = new Vector3D(0, 0, 4096);
        } else {
            this.rotateAxis.set(0, 0, 4096);
        }
        this.rotateAngle = angle;
        this.viewTransform = null;
    }

    public void setLight(Light light) {
        this.light = light;
    }

    public void setProjection(int type, int[] parameters) {
        if (parameters == null) {
            throw new NullPointerException();
        }
        switch (type) {
            case 24: 
            case 26: {
                if (parameters.length < 2) {
                    throw new IllegalArgumentException();
                }
                this.projectionParameters[0] = parameters[0];
                this.projectionParameters[1] = parameters[1];
                break;
            }
            case 25: {
                if (parameters.length < 1) {
                    throw new IllegalArgumentException();
                }
                this.projectionParameters[0] = parameters[0];
                break;
            }
            case 21: {
                if (parameters.length < 3) {
                    throw new IllegalArgumentException();
                }
                int near = parameters[0];
                int far = parameters[1];
                int angle = parameters[2];
                if (near >= far || near < 1 || far > Short.MAX_VALUE || angle < 1 || angle > 2047) {
                    throw new IllegalArgumentException();
                }
                this.projectionParameters[0] = near;
                this.projectionParameters[1] = far;
                this.projectionParameters[2] = angle;
                break;
            }
            case 22: {
                if (parameters.length < 3) {
                    throw new IllegalArgumentException();
                }
                int near = parameters[0];
                int far = parameters[1];
                int width = parameters[2];
                if (near >= far || near < 1 || far > Short.MAX_VALUE || width < 0) {
                    throw new IllegalArgumentException();
                }
                this.projectionParameters[0] = near;
                this.projectionParameters[1] = far;
                this.projectionParameters[2] = width;
                break;
            }
            case 23: {
                if (parameters.length < 4) {
                    throw new IllegalArgumentException();
                }
                int near = parameters[0];
                int far = parameters[1];
                int width = parameters[2];
                int height = parameters[3];
                if (near >= far || near < 1 || far > Short.MAX_VALUE || width < 0 || height < 0) {
                    throw new IllegalArgumentException();
                }
                this.projectionParameters[0] = near;
                this.projectionParameters[1] = far;
                this.projectionParameters[2] = width;
                this.projectionParameters[3] = height;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.projectionType = type;
    }

    public void setSemiTransparent(boolean transparent) {
        this.isSemiTransparent = transparent;
    }

    public void setToonShading(boolean toon) {
        this.isToonShaded = toon;
    }

    public void setToonShading(int threshold, int highColor, int lowColor) {
        if ((threshold & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException();
        }
        this.toonThreshold = threshold;
        this.toonHighColor = highColor;
        this.toonLowColor = lowColor;
    }

    public void setViewPoint(Vector3D position, Vector3D look, Vector3D up) {
        this.setViewPointTransform(AffineTransform.getViewPointTransform(position, look, up));
    }

    public void setViewPointTransform(AffineTransform viewPointTransform) {
        if (viewPointTransform == null) {
            throw new NullPointerException();
        }
        this.viewPointTransform = viewPointTransform;
    }

    public void setViewTransform(AffineTransform viewTransform) {
        if (viewTransform == null) {
            throw new NullPointerException();
        }
        this.viewTransform = viewTransform;
    }
}

