/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.iden.micro3d;

import com.motorola.iden.micro3d.Vector3D;
import ru.woesss.j2me.micro3d.MathUtil;

public class Light {
    public static final int MAX_AMBIENT_LIGHT_INTENSITY = 4096;
    public static final int MAX_DIRECTIONAL_LIGHT_INTENSITY = 16384;
    public static final int MIN_AMBIENT_LIGHT_INTENSITY = 0;
    public static final int MIN_DIRECTIONAL_LIGHT_INTENSITY = 0;
    int ambientIntensity;
    Vector3D direction;
    int directionalIntensity;

    public Light(int ambientIntensity, Vector3D direction, int directionalIntensity) {
        this.setDirectionVector(direction);
        this.setAmbientIntensity(ambientIntensity);
        this.setDirectionalIntensity(directionalIntensity);
    }

    Light(Light src) {
        this.ambientIntensity = src.ambientIntensity;
        this.directionalIntensity = src.directionalIntensity;
        if (src.direction != null) {
            this.direction = new Vector3D(src.direction);
        }
    }

    public int getAmbientIntensity() {
        return this.ambientIntensity;
    }

    public int getDirectionalIntensity() {
        return this.directionalIntensity;
    }

    public Vector3D getDirectionVector() {
        return this.direction;
    }

    public void setAmbientIntensity(int intensity) {
        this.ambientIntensity = MathUtil.clamp(intensity, 0, 4096);
    }

    public void setDirectionalIntensity(int intensity) {
        this.directionalIntensity = MathUtil.clamp(intensity, 0, 16384);
    }

    public void setDirectionVector(Vector3D direction) {
        if (direction != null && direction.isZero()) {
            throw new IllegalArgumentException();
        }
        this.direction = direction;
    }
}

