/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.iden.micro3d;

import com.motorola.iden.micro3d.Texture;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;

public class MultiTexture
extends Texture {
    public static final int MAX_TEXTURES = 16;
    private int currentIdx = 0;
    Texture[] textures;
    int size;
    private Texture currentTexture;

    public MultiTexture() {
        super(false);
        this.textures = new Texture[16];
    }

    public MultiTexture(int capacity) {
        super(false);
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.textures = new Texture[Math.min(capacity, 16)];
    }

    public boolean addTexture(Texture texture) {
        if (texture == null) {
            throw new NullPointerException();
        }
        if (texture.isSphereTexture() || texture instanceof MultiTexture) {
            throw new IllegalArgumentException();
        }
        if (this.size < 16) {
            Texture[] copy;
            if (this.size < this.textures.length) {
                copy = this.textures;
            } else {
                copy = new Texture[this.size + 1];
                System.arraycopy(this.textures, 0, copy, 0, this.size);
            }
            this.textures[this.size++] = texture;
            this.textures = copy;
            return true;
        }
        return false;
    }

    public int capacity() {
        return this.textures.length;
    }

    public boolean contains(Texture texture) {
        for (Texture t : this.textures) {
            if (t != texture) continue;
            return true;
        }
        return false;
    }

    public int getCurrentIndex() {
        return this.currentIdx;
    }

    public Texture getCurrentTexture() {
        return this.currentTexture;
    }

    public int indexOf(Texture texture) {
        return this.indexOf(texture, 0);
    }

    public int indexOf(Texture texture, int index) {
        int len = this.textures.length;
        while (index < len) {
            if (this.textures[index] == texture) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean insertTextureAt(Texture texture, int index) {
        if (texture == null) {
            throw new NullPointerException();
        }
        if (texture.isSphereTexture() || texture instanceof MultiTexture) {
            throw new IllegalArgumentException();
        }
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.size < 16) {
            Texture[] copy;
            if (this.size < this.textures.length) {
                copy = this.textures;
            } else {
                copy = new Texture[this.size + 1];
                System.arraycopy(this.textures, 0, copy, 0, index);
            }
            System.arraycopy(this.textures, index, copy, index + 1, this.size - index);
            this.textures[index] = texture;
            this.textures = copy;
            ++this.size;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(Texture texture) {
        return this.lastIndexOf(texture, this.textures.length);
    }

    public int lastIndexOf(Texture texture, int index) {
        --index;
        while (index >= 0) {
            if (this.textures[index] == texture) {
                return index;
            }
            --index;
        }
        return -1;
    }

    public void removeAllTextures() {
        while (this.size > 0) {
            --this.size;
            this.textures[this.size] = null;
        }
    }

    public boolean removeTexture(Texture texture) {
        int index = this.indexOf(texture);
        if (index == -1) {
            return false;
        }
        this.removeTextureAt(index);
        return true;
    }

    public void removeTextureAt(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.size;
        System.arraycopy(this.textures, index + 1, this.textures, index, this.size - index);
    }

    public void setCurrentIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.currentIdx = index;
        this.currentTexture = this.textures[index];
    }

    public void setTextureAt(Texture texture, int index) {
        if (texture == null) {
            throw new NullPointerException();
        }
        if (texture.isSphereTexture() || texture instanceof MultiTexture) {
            throw new IllegalArgumentException();
        }
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.textures[index] = texture;
    }

    public int size() {
        return this.size;
    }

    public Texture textureAt(int index) {
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.textures[index];
    }

    public Enumeration textures() {
        return Collections.enumeration(Arrays.asList(this.textures).subList(0, this.size));
    }
}

