/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.iden.micro3d;

import com.motorola.iden.micro3d.ActionTable;
import com.motorola.iden.micro3d.AffineTransform;
import com.motorola.iden.micro3d.Figure;
import com.motorola.iden.micro3d.Layout3D;
import com.motorola.iden.micro3d.Light;
import com.motorola.iden.micro3d.Line;
import com.motorola.iden.micro3d.MultiTexture;
import com.motorola.iden.micro3d.Object3D;
import com.motorola.iden.micro3d.Point;
import com.motorola.iden.micro3d.PointSprite;
import com.motorola.iden.micro3d.Primitive;
import com.motorola.iden.micro3d.Quadrangle;
import com.motorola.iden.micro3d.Texture;
import com.motorola.iden.micro3d.Triangle;
import com.motorola.iden.micro3d.Vector3D;
import ru.woesss.j2me.micro3d.ActTableImpl;
import ru.woesss.j2me.micro3d.FigureImpl;
import ru.woesss.j2me.micro3d.MathUtil;
import ru.woesss.j2me.micro3d.Render;
import ru.woesss.j2me.micro3d.TextureImpl;

public class RenderProxy {
    static void getViewTrans(AffineTransform a2, float[] out) {
        out[0] = (float)a2.m00 * 2.4414062E-4f;
        out[1] = (float)a2.m10 * 2.4414062E-4f;
        out[2] = (float)a2.m20 * 2.4414062E-4f;
        out[3] = (float)a2.m01 * 2.4414062E-4f;
        out[4] = (float)a2.m11 * 2.4414062E-4f;
        out[5] = (float)a2.m21 * 2.4414062E-4f;
        out[6] = (float)a2.m02 * 2.4414062E-4f;
        out[7] = (float)a2.m12 * 2.4414062E-4f;
        out[8] = (float)a2.m22 * 2.4414062E-4f;
        out[9] = a2.m03;
        out[10] = a2.m13;
        out[11] = a2.m23;
    }

    static void setProjection(Render render, FigureNode node) {
        int[] params = node.projectionParameters;
        switch (node.projectionType) {
            case 24: {
                int sx = params[0];
                int sy = params[1];
                render.setOrthographicScale(sx, sy);
                break;
            }
            case 25: {
                int w = params[0];
                render.setOrthographicW(w);
                break;
            }
            case 26: {
                int w = params[0];
                int h2 = params[1];
                render.setOrthographicWH(w, h2);
                break;
            }
            case 21: {
                int near = params[0];
                int far = params[1];
                int angle = params[2];
                render.setPerspectiveFov(near, far, angle);
                break;
            }
            case 22: {
                int near = params[0];
                int far = params[1];
                int w = params[2];
                render.setPerspectiveW(near, far, w);
                break;
            }
            case 23: {
                int near = params[0];
                int far = params[1];
                int w = params[2];
                int h3 = params[3];
                render.setPerspectiveWH(near, far, w, h3);
                break;
            }
        }
    }

    static Texture getTexture(Object3D obj) {
        Texture texture = obj.texture;
        if (texture instanceof MultiTexture) {
            MultiTexture mt = (MultiTexture)texture;
            return mt.getCurrentTexture();
        }
        return texture;
    }

    public static boolean checkNormals(Vector3D[] normals) {
        if (normals == null) {
            return false;
        }
        for (Vector3D normal : normals) {
            if (normal != null) continue;
            return false;
        }
        return true;
    }

    static class PrimitiveNode
    extends RenderNode {
        int command = 0;
        int[] data;
        int normOffset = 0;
        int texOffset = 0;
        int colorOffset = 0;

        PrimitiveNode(Primitive primitive, int x, int y) {
            super(primitive, x, y);
            if (primitive instanceof Point) {
                Point point = (Point)primitive;
                this.command = 0x1010000;
                this.command |= 0x400;
                this.command |= point.blendingType - 200 << 5;
                this.command |= 3;
                Vector3D v = point.vertices[0];
                this.data = new int[]{v.x, v.y, v.z, point.color};
                this.colorOffset = 3;
            } else if (primitive instanceof Line) {
                Line line = (Line)primitive;
                this.command = 0x2010000;
                this.command |= 0x400;
                this.command |= line.blendingType - 200 << 5;
                this.command |= 3;
                Vector3D v1 = line.vertices[0];
                Vector3D v2 = line.vertices[1];
                this.data = new int[]{v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, line.color};
                this.colorOffset = 6;
            } else if (primitive instanceof Triangle) {
                Triangle triangle = (Triangle)primitive;
                int dataSize = 9;
                this.command = 0x3010000;
                this.command |= 2;
                Vector3D[] normals = triangle.normals;
                if (triangle.hasFaceNormal) {
                    this.command |= 0x201;
                    dataSize += 3;
                } else if (RenderProxy.checkNormals(normals)) {
                    this.command |= 0x301;
                    dataSize += 9;
                }
                Texture texture = RenderProxy.getTexture(triangle);
                if (texture != null) {
                    this.texture = texture.impl;
                    this.command |= 0x3000;
                    dataSize += 6;
                } else {
                    this.command |= 0x400;
                    ++dataSize;
                }
                this.command |= triangle.blendingType - 200 << 5;
                if (triangle.isColorKey) {
                    this.command |= 0x10;
                }
                this.data = new int[dataSize];
                Vector3D[] vertices = triangle.vertices;
                this.texOffset = this.normOffset = PrimitiveNode.addVertices(this.data, 0, vertices, 3);
                if ((this.command & 0x200) != 0) {
                    this.texOffset = PrimitiveNode.addVertices(this.data, this.normOffset, normals, 1);
                } else if ((this.command & 0x300) != 0) {
                    this.texOffset = PrimitiveNode.addVertices(this.data, this.normOffset, normals, 3);
                }
                this.colorOffset = this.texOffset;
                if ((this.command & 0x3000) != 0) {
                    System.arraycopy(triangle.textureCoords, 0, this.data, this.texOffset, 6);
                    this.colorOffset += 6;
                }
            } else if (primitive instanceof Quadrangle) {
                Quadrangle quadrangle = (Quadrangle)primitive;
                int dataSize = 12;
                this.command = 0x4010000;
                this.command |= 2;
                Vector3D[] normals = quadrangle.normals;
                if (quadrangle.hasFaceNormal) {
                    this.command |= 0x201;
                    dataSize += 3;
                } else if (RenderProxy.checkNormals(normals)) {
                    this.command |= 0x301;
                    dataSize += 12;
                }
                Texture texture = RenderProxy.getTexture(quadrangle);
                if (texture != null) {
                    this.texture = texture.impl;
                    this.command |= 0x3000;
                    dataSize += 8;
                } else {
                    this.command |= 0x400;
                    ++dataSize;
                }
                this.command |= quadrangle.blendingType - 200 << 5;
                if (quadrangle.isColorKey) {
                    this.command |= 0x10;
                }
                this.data = new int[dataSize];
                Vector3D[] vertices = quadrangle.vertices;
                this.texOffset = this.normOffset = PrimitiveNode.addVertices(this.data, 0, vertices, 4);
                if ((this.command & 0x200) != 0) {
                    this.texOffset = PrimitiveNode.addVertices(this.data, this.normOffset, normals, 1);
                } else if ((this.command & 0x300) != 0) {
                    this.texOffset = PrimitiveNode.addVertices(this.data, this.normOffset, normals, 4);
                }
                this.colorOffset = this.texOffset;
                if ((this.command & 0x3000) != 0) {
                    System.arraycopy(quadrangle.textureCoords, 0, this.data, this.texOffset, 8);
                    this.colorOffset += 8;
                }
            } else if (primitive instanceof PointSprite) {
                PointSprite sprite = (PointSprite)primitive;
                Texture texture = RenderProxy.getTexture(sprite);
                if (texture == null) {
                    return;
                }
                this.command = 83963904;
                if (sprite.isColorKey) {
                    this.command |= 0x10;
                }
                this.data = new int[11];
                Vector3D v = sprite.vertices[0];
                this.data[0] = v.x;
                this.data[1] = v.y;
                this.data[2] = v.z;
                System.arraycopy(sprite.params, 0, this.data, 3, 8);
                this.texOffset = 3;
            }
        }

        @Override
        void push(Render render) {
            render.postPrimitives(this.command, this.data, 0, this.data, this.normOffset, this.data, this.texOffset, this.data, this.colorOffset);
        }

        private static int addVertices(int[] data, int offset, Vector3D[] vertices, int len) {
            for (int i2 = 0; i2 < len; ++i2) {
                Vector3D v = vertices[i2];
                data[offset++] = v.x;
                data[offset++] = v.y;
                data[offset++] = v.z;
            }
            return offset;
        }
    }

    static class FigureNode
    extends RenderNode {
        private final FigureImpl figure;
        private final int actionIndex;
        private final int frameIndex;
        private final int pattern;
        private ActTableImpl actionTable;
        private TextureImpl[] texArray;

        public FigureNode(Figure figure, int x, int y) {
            super(figure, x, y);
            this.figure = figure.impl;
            ActionTable actionTable = figure.actionTable;
            if (actionTable != null) {
                this.actionTable = actionTable.impl;
            }
            this.actionIndex = figure.actionIndex;
            this.frameIndex = figure.frameIndex;
            this.pattern = figure.pattern;
            Texture texture = figure.texture;
            if (texture instanceof MultiTexture) {
                MultiTexture mt = (MultiTexture)texture;
                int size = mt.size;
                if (size > 0) {
                    this.texArray = new TextureImpl[size];
                    for (int i2 = 0; i2 < size; ++i2) {
                        this.texArray[i2] = mt.textures[i2].impl;
                    }
                } else {
                    Texture t = mt.getCurrentTexture();
                    if (t != null) {
                        this.texture = t.impl;
                    }
                }
            } else if (texture != null) {
                this.texture = texture.impl;
            }
        }

        @Override
        void push(Render render) {
            if (this.light != null) {
                Vector3D dir = this.light.direction;
                if (dir != null) {
                    render.setLight(this.light.ambientIntensity, this.light.directionalIntensity, dir.x, dir.y, dir.z);
                } else {
                    render.setLight(this.light.ambientIntensity, 0, 0, 0, 0);
                }
            }
            render.setToonParam(this.toonThreshold, this.toonHighColor, this.toonLowColor);
            if (this.sphereTexture != null) {
                render.setSphereTexture(this.sphereTexture);
            }
            render.setAttribute(this.attrs);
            render.setCenter(this.x, this.y);
            RenderProxy.setProjection(render, this);
            System.arraycopy(this.viewMatrix, 0, render.getViewMatrix(), 0, 12);
            if (this.texArray != null) {
                render.setTextureArray(this.texArray);
            } else {
                render.setTexture(this.texture);
            }
            this.figure.setPosture(this.actionTable, this.actionIndex, this.frameIndex, this.pattern);
            render.postFigure(this.figure);
        }
    }

    static abstract class RenderNode {
        protected final int x;
        protected final int y;
        protected final int projectionType;
        protected final int[] projectionParameters;
        protected final float[] viewMatrix = new float[12];
        protected TextureImpl texture;
        protected int toonThreshold;
        protected int toonHighColor;
        protected int toonLowColor;
        protected TextureImpl sphereTexture;
        protected int attrs = 0;
        protected Light light;

        RenderNode(Object3D object3d, int x, int y) {
            this.x = x;
            this.y = y;
            Layout3D layout = object3d.layout;
            Light light = layout.light;
            if (light != null) {
                this.light = new Light(light);
                this.attrs |= 1;
            } else {
                this.attrs &= 0xFFFFFFFE;
            }
            if (layout.isToonShaded) {
                this.attrs |= 4;
                this.toonThreshold = layout.toonThreshold;
                this.toonHighColor = layout.toonHighColor;
                this.toonLowColor = layout.toonLowColor;
            } else {
                this.attrs &= 0xFFFFFFFB;
            }
            this.attrs = layout.isSemiTransparent ? (this.attrs |= 8) : (this.attrs &= 0xFFFFFFF7);
            Texture specular = object3d.sphereTexture;
            if (specular != null) {
                this.attrs |= 2;
                this.sphereTexture = specular.impl;
            } else {
                this.attrs &= 0xFFFFFFFD;
            }
            this.projectionParameters = layout.getProjectionParameters();
            this.projectionType = layout.projectionType;
            AffineTransform viewPointTransform = layout.getViewPointTransform();
            AffineTransform viewTransform = layout.getViewTransform();
            if (viewTransform != null) {
                RenderProxy.getViewTrans(AffineTransform.multiply(viewPointTransform, viewTransform), this.viewMatrix);
            } else {
                RenderProxy.getViewTrans(viewPointTransform, this.viewMatrix);
                Vector3D axis = layout.rotateAxis;
                int rotateAngle = layout.rotateAngle;
                if (axis != null && rotateAngle != 0) {
                    MathUtil.rotateM12(this.viewMatrix, axis.x, axis.y, axis.z, rotateAngle);
                } else {
                    this.viewMatrix[0] = 1.0f;
                    this.viewMatrix[4] = 1.0f;
                    this.viewMatrix[8] = 1.0f;
                }
            }
        }

        abstract void push(Render var1);
    }
}

