/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.iden.micro3d;

import com.motorola.iden.micro3d.Figure;
import com.motorola.iden.micro3d.Layout3D;
import com.motorola.iden.micro3d.MultiTexture;
import com.motorola.iden.micro3d.Object3D;
import com.motorola.iden.micro3d.Primitive;
import com.motorola.iden.micro3d.RenderProxy;
import com.motorola.iden.micro3d.Texture;
import java.util.LinkedList;
import javax.microedition.lcdui.Graphics;
import ru.woesss.j2me.micro3d.Render;

public class Renderer {
    private final LinkedList<RenderProxy.RenderNode> stack = new LinkedList();

    public void draw(Object3D object3d, int x, int y) {
        if (object3d == null) {
            throw new NullPointerException();
        }
        Layout3D layout = object3d.layout;
        if (layout == null) {
            return;
        }
        if (x < -2048) {
            x = -2048;
        }
        if (y < -2048) {
            y = -2048;
        }
        if (x > 2047) {
            x = 2047;
        }
        if (y > 2047) {
            y = 2047;
        }
        if (object3d instanceof Figure) {
            Figure figure = (Figure)object3d;
            this.stack.addLast(new RenderProxy.FigureNode(figure, x, y));
        } else if (object3d instanceof Primitive) {
            Primitive primitive = (Primitive)object3d;
            this.stack.addLast(new RenderProxy.PrimitiveNode(primitive, x, y));
        }
    }

    public void paint(Graphics g) {
        Render render = Render.getRender();
        render.bind(g, false);
        for (RenderProxy.RenderNode node : this.stack) {
            node.push(render);
        }
        this.stack.clear();
        render.flush();
        render.release();
    }

    public Texture paint(Texture texture, int color) {
        if (texture == null) {
            texture = new Texture(true);
        } else {
            if (texture instanceof MultiTexture) {
                throw new IllegalArgumentException();
            }
            if (!texture.isMutable()) {
                texture = new Texture(true);
            }
        }
        Render render = Render.getRender();
        render.setClearColor(color);
        render.bind(texture.impl);
        for (RenderProxy.RenderNode node : this.stack) {
            node.push(render);
        }
        this.stack.clear();
        render.flush();
        render.release();
        return texture;
    }
}

