/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.iden.micro3d;

import com.motorola.iden.micro3d.Layout3D;
import com.motorola.iden.micro3d.Primitive;
import com.motorola.iden.micro3d.Texture;
import com.motorola.iden.micro3d.Vector3D;

public class Triangle
extends Primitive {
    Vector3D[] normals;
    final int[] textureCoords = new int[6];
    boolean hasFaceNormal;

    public Triangle(Vector3D vertexA, Vector3D vertexB, Vector3D vertexC, int textureXA, int textureYA, int textureXB, int textureYB, int textureXC, int textureYC, Layout3D layout, Texture texture) {
        this(vertexA, vertexB, vertexC, layout);
        this.textureCoords[0] = textureXA;
        this.textureCoords[1] = textureYA;
        this.textureCoords[2] = textureXB;
        this.textureCoords[3] = textureYB;
        this.textureCoords[4] = textureXC;
        this.textureCoords[5] = textureYC;
        this.setTexture(texture);
    }

    public Triangle(Vector3D vertexA, Vector3D vertexB, Vector3D vertexC, Layout3D layout, int color) {
        this(vertexA, vertexB, vertexC, layout);
        this.setColor(color);
    }

    public Triangle(Vector3D vertexA, Vector3D vertexB, Vector3D vertexC, Vector3D faceNormal, int textureXA, int textureYA, int textureXB, int textureYB, int textureXC, int textureYC, Layout3D layout, Texture texture) {
        this(vertexA, vertexB, vertexC, layout);
        if (faceNormal == null) {
            throw new NullPointerException();
        }
        this.hasFaceNormal = true;
        this.normals = new Vector3D[]{faceNormal};
        this.textureCoords[0] = textureXA;
        this.textureCoords[1] = textureYA;
        this.textureCoords[2] = textureXB;
        this.textureCoords[3] = textureYB;
        this.textureCoords[4] = textureXC;
        this.textureCoords[5] = textureYC;
        this.setTexture(texture);
    }

    public Triangle(Vector3D vertexA, Vector3D vertexB, Vector3D vertexC, Vector3D faceNormal, Layout3D layout, int color) {
        this(vertexA, vertexB, vertexC, layout);
        if (faceNormal == null) {
            throw new NullPointerException();
        }
        this.hasFaceNormal = true;
        this.normals = new Vector3D[]{faceNormal};
        this.setColor(color);
    }

    public Triangle(Vector3D vertexA, Vector3D vertexB, Vector3D vertexC, Vector3D normalA, Vector3D normalB, Vector3D normalC, int textureXA, int textureYA, int textureXB, int textureYB, int textureXC, int textureYC, Layout3D layout, Texture texture) {
        this(vertexA, vertexB, vertexC, layout);
        if (normalA == null && normalB == null && normalC == null) {
            throw new NullPointerException();
        }
        this.normals = new Vector3D[]{normalA, normalB, normalC};
        this.textureCoords[0] = textureXA;
        this.textureCoords[1] = textureYA;
        this.textureCoords[2] = textureXB;
        this.textureCoords[3] = textureYB;
        this.textureCoords[4] = textureXC;
        this.textureCoords[5] = textureYC;
        this.setTexture(texture);
    }

    public Triangle(Vector3D vertexA, Vector3D vertexB, Vector3D vertexC, Vector3D normalA, Vector3D normalB, Vector3D normalC, Layout3D layout, int color) {
        this(vertexA, vertexB, vertexC, layout);
        if (normalA == null && normalB == null && normalC == null) {
            throw new NullPointerException();
        }
        this.normals = new Vector3D[]{normalA, normalB, normalC};
        this.setColor(color);
    }

    private Triangle(Vector3D vertexA, Vector3D vertexB, Vector3D vertexC, Layout3D layout) {
        super(3);
        if (vertexA == null && vertexB == null && vertexC == null) {
            throw new NullPointerException();
        }
        this.vertices[0] = vertexA;
        this.vertices[1] = vertexB;
        this.vertices[2] = vertexC;
        this.setLayout(layout);
    }

    public int getTextureCoordinateX(int vertexID) {
        if (vertexID < 1 || vertexID > 3) {
            throw new IllegalArgumentException();
        }
        return this.textureCoords[(vertexID - 1) * 2];
    }

    public int getTextureCoordinateY(int vertexID) {
        if (vertexID < 1 || vertexID > 3) {
            throw new IllegalArgumentException();
        }
        return this.textureCoords[(vertexID - 1) * 2 + 1];
    }

    @Override
    public Vector3D getVector(int vectorID) {
        if (vectorID == 32) {
            return this.hasFaceNormal ? this.normals[0] : null;
        }
        int maskedId = vectorID & 0xFFFFFFEF;
        if (maskedId < 1 || maskedId > 3) {
            throw new IllegalArgumentException();
        }
        if ((vectorID & 0x10) != 0) {
            if (this.hasFaceNormal || this.normals == null) {
                return null;
            }
            return this.normals[maskedId - 1];
        }
        return this.vertices[maskedId - 1];
    }

    public void setTextureCoordinates(int vertexID, int x, int y) {
        if (vertexID < 1 || vertexID > 3) {
            throw new IllegalArgumentException();
        }
        int offset = (vertexID - 1) * 2;
        this.textureCoords[offset++] = x;
        this.textureCoords[offset] = y;
    }

    @Override
    public void setVector(int vectorID, Vector3D vector2) {
        if (vector2 == null) {
            throw new NullPointerException();
        }
        if (vectorID == 32) {
            this.hasFaceNormal = true;
            if (this.normals == null) {
                this.normals = new Vector3D[]{vector2};
            } else {
                this.normals[0] = vector2;
            }
            return;
        }
        int idMasked = vectorID & 0xFFFFFFEF;
        if (idMasked < 1 || idMasked > 3) {
            throw new IllegalArgumentException();
        }
        if ((vectorID & 0x10) != 0) {
            if (this.normals == null || this.hasFaceNormal) {
                this.normals = new Vector3D[3];
            }
            this.normals[idMasked - 1] = vector2;
        } else {
            this.vertices[idMasked - 1] = vector2;
        }
    }
}

