/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.iden.micro3d;

import ru.woesss.j2me.micro3d.MathUtil;

public class Vector3D {
    public static final int MAX_VALUE = Short.MAX_VALUE;
    public static final int MIN_VALUE = Short.MIN_VALUE;
    public static final int SIZE_OF_VECTOR3D = 3;
    int x;
    int y;
    int z;

    public Vector3D() {
    }

    public Vector3D(int x, int y, int z) {
        this.x = MathUtil.clamp(x, Short.MIN_VALUE, Short.MAX_VALUE);
        this.y = MathUtil.clamp(y, Short.MIN_VALUE, Short.MAX_VALUE);
        this.z = MathUtil.clamp(z, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    Vector3D(Vector3D src) {
        this.x = src.x;
        this.y = src.y;
        this.z = src.z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int innerProduct(Vector3D multiplier) {
        if (multiplier == null) {
            throw new NullPointerException();
        }
        return this.x * multiplier.x + this.y * multiplier.y + this.z * multiplier.z;
    }

    public void normalize() {
        int x = this.x;
        int y = this.y;
        int z = this.z;
        int shift = Integer.numberOfLeadingZeros(Math.abs(x) | Math.abs(y) | Math.abs(z)) - 17;
        if (shift > 0) {
            x <<= shift;
            y <<= shift;
            z <<= shift;
        } else if (shift < 0) {
            shift = -shift;
            x >>= shift;
            y >>= shift;
            z >>= shift;
        }
        int i2 = MathUtil.uSqrt(x * x + y * y + z * z);
        if (i2 != 0) {
            this.x = (x << 12) / i2;
            this.y = (y << 12) / i2;
            this.z = (z << 12) / i2;
        } else {
            this.x = 0;
            this.y = 0;
            this.z = 4096;
        }
    }

    public static Vector3D normalize(Vector3D vector2) {
        if (vector2 == null) {
            throw new NullPointerException();
        }
        if (vector2.isZero()) {
            throw new IllegalArgumentException();
        }
        Vector3D result = new Vector3D(vector2);
        result.normalize();
        return result;
    }

    public void outerProduct(Vector3D multiplier) {
        if (multiplier == null) {
            throw new NullPointerException();
        }
        int x = this.x;
        int y = this.y;
        int z = this.z;
        this.x = y * multiplier.z - z * multiplier.y;
        this.y = z * multiplier.x - x * multiplier.z;
        this.z = x * multiplier.y - y * multiplier.x;
    }

    public static Vector3D outerProduct(Vector3D multiplicand, Vector3D multiplier) {
        if (multiplicand == null) {
            throw new NullPointerException();
        }
        Vector3D result = new Vector3D(multiplicand);
        result.outerProduct(multiplier);
        return result;
    }

    public void set(int x, int y, int z) {
        this.x = MathUtil.clamp(x, Short.MIN_VALUE, Short.MAX_VALUE);
        this.y = MathUtil.clamp(y, Short.MIN_VALUE, Short.MAX_VALUE);
        this.z = MathUtil.clamp(z, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public void setX(int x) {
        this.x = MathUtil.clamp(x, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public void setY(int y) {
        this.y = MathUtil.clamp(y, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public void setZ(int z) {
        this.z = MathUtil.clamp(z, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    boolean isZero() {
        return (this.x & this.y & this.z) == 0;
    }

    void set(Vector3D src) {
        this.x = src.x;
        this.y = src.y;
        this.z = src.z;
    }
}

