/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.impl.isa.location;

import javax.microedition.location.AddressInfo;
import javax.microedition.location.Location;
import javax.microedition.location.QualifiedCoordinates;

public class LocationImpl
extends Location {
    private long timestamp;
    private float speed;
    private float course;
    private int locationMethod;
    private boolean isValid = false;
    private QualifiedCoordinates coordinates;
    private String extraInfo = null;
    private static final String NMEA = "application/X-jsr179-location-nmea";

    LocationImpl(QualifiedCoordinates coordinates) {
        this.coordinates = coordinates;
    }

    private LocationImpl(LocationImpl other) {
        this.timestamp = other.timestamp;
        this.coordinates = other.getQualifiedCoordinates();
        this.speed = other.speed;
        this.course = other.course;
        this.locationMethod = other.locationMethod;
        this.extraInfo = other.extraInfo;
        this.isValid = other.isValid();
    }

    public LocationImpl clone() {
        LocationImpl c2 = new LocationImpl(this);
        return c2;
    }

    void setTimestamp(long time) {
        this.timestamp = time;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public QualifiedCoordinates getQualifiedCoordinates() {
        if (this.isValid() && this.coordinates != null) {
            try {
                return new QualifiedCoordinates(this.coordinates.getLatitude(), this.coordinates.getLongitude(), this.coordinates.getAltitude(), this.coordinates.getHorizontalAccuracy(), this.coordinates.getVerticalAccuracy());
            }
            catch (IllegalArgumentException e2) {
                return null;
            }
        }
        return null;
    }

    @Override
    public float getSpeed() {
        return this.speed;
    }

    @Override
    public float getCourse() {
        return this.course;
    }

    @Override
    public int getLocationMethod() {
        return this.locationMethod;
    }

    @Override
    public AddressInfo getAddressInfo() {
        return null;
    }

    @Override
    public String getExtraInfo(String mimetype) {
        if (NMEA.equals(mimetype)) {
            return this.extraInfo;
        }
        return null;
    }
}

