/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.m3d;

import javax.microedition.lcdui.Image;

public class Texture {
    public Image texture;
    public int[] imagedata;
    public int width = 0;
    public int height = 0;
    private double[] uvm = new double[9];
    private double[] sourcem = new double[9];
    private double[] transm = new double[9];
    private double[] tempm = new double[9];
    private int[] colors = new int[]{-1, -16777216};

    public Texture() {
    }

    public Texture(int a2, int b2, Image c2) {
        this.texture = c2;
        this.width = this.texture.getWidth();
        this.height = this.texture.getHeight();
        this.imagedata = new int[this.width * this.height];
        this.texture.getRGB(this.imagedata, 0, this.width, 0, 0, this.width, this.height);
        int i2 = 0;
        while (i2 < this.imagedata.length) {
            int n = i2;
            this.imagedata[n] = this.imagedata[n] | 0;
            int n2 = i2++;
            this.imagedata[n2] = this.imagedata[n2] & 0xFFFFFFFF;
        }
    }

    public int map(int x, int y) {
        int px = (int)(this.transm[0] * (double)x + this.transm[1] * (double)y + this.transm[2]);
        int py = (int)(this.transm[3] * (double)x + this.transm[4] * (double)y + this.transm[5]);
        int idx = px + py * this.width;
        if (idx > 0 && idx < this.imagedata.length) {
            return this.colors[this.imagedata[idx] & 1];
        }
        return 0;
    }

    public void mapto(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.sourcem[0] = x1;
        this.sourcem[1] = x2;
        this.sourcem[2] = x3;
        this.sourcem[3] = y1;
        this.sourcem[4] = y2;
        this.sourcem[5] = y3;
        this.sourcem[6] = 1.0;
        this.sourcem[7] = 1.0;
        this.sourcem[8] = 1.0;
        this.inverse(this.sourcem);
        this.clone(this.transm, this.uvm);
        this.matmul(this.transm, this.sourcem);
        this.transm[6] = 0.0;
        this.transm[7] = 0.0;
        this.transm[8] = 1.0;
    }

    public void setUVs(int u1, int v1, int u2, int v2, int u3, int v3) {
        this.uvm[0] = (u1 + 1) / 2 * this.width;
        this.uvm[1] = (u2 + 1) / 2 * this.width;
        this.uvm[2] = (u3 + 1) / 2 * this.width;
        this.uvm[3] = (v1 + 1) / 2 * this.height;
        this.uvm[4] = (v2 + 1) / 2 * this.height;
        this.uvm[5] = (v3 + 1) / 2 * this.height;
        this.uvm[6] = 1.0;
        this.uvm[7] = 1.0;
        this.uvm[8] = 1.0;
    }

    private void clone(double[] m1, double[] m2) {
        for (int i2 = 0; i2 < 9; ++i2) {
            m1[i2] = m2[i2];
        }
    }

    private void inverse(double[] m2) {
        double det = m2[0] * (m2[4] * m2[8] - m2[7] * m2[5]) - m2[1] * (m2[3] * m2[8] - m2[5] * m2[6]) + m2[2] * (m2[3] * m2[7] - m2[4] * m2[6]);
        if (det == 0.0) {
            return;
        }
        det = 1.0 / det;
        this.tempm[0] = (m2[4] * m2[8] - m2[7] * m2[5]) * det;
        this.tempm[1] = (m2[2] * m2[7] - m2[1] * m2[8]) * det;
        this.tempm[2] = (m2[1] * m2[5] - m2[2] * m2[4]) * det;
        this.tempm[3] = (m2[5] * m2[6] - m2[3] * m2[8]) * det;
        this.tempm[4] = (m2[0] * m2[8] - m2[2] * m2[6]) * det;
        this.tempm[5] = (m2[3] * m2[2] - m2[0] * m2[5]) * det;
        this.tempm[6] = (m2[3] * m2[7] - m2[6] * m2[4]) * det;
        this.tempm[7] = (m2[6] * m2[1] - m2[0] * m2[7]) * det;
        this.tempm[8] = (m2[0] * m2[4] - m2[3] * m2[1]) * det;
        this.clone(m2, this.tempm);
    }

    private void matmul(double[] m1, double[] m2) {
        this.tempm[0] = m1[0] * m2[0] + m1[1] * m2[3] + m1[2] * m2[6];
        this.tempm[1] = m1[0] * m2[1] + m1[1] * m2[4] + m1[2] * m2[7];
        this.tempm[2] = m1[0] * m2[2] + m1[1] * m2[5] + m1[2] * m2[8];
        this.tempm[3] = m1[3] * m2[0] + m1[4] * m2[3] + m1[5] * m2[6];
        this.tempm[4] = m1[3] * m2[1] + m1[4] * m2[4] + m1[5] * m2[7];
        this.tempm[5] = m1[3] * m2[2] + m1[4] * m2[5] + m1[5] * m2[8];
        this.tempm[6] = m1[6] * m2[0] + m1[7] * m2[3] + m1[8] * m2[6];
        this.tempm[7] = m1[6] * m2[1] + m1[7] * m2[4] + m1[8] * m2[7];
        this.tempm[8] = m1[6] * m2[2] + m1[7] * m2[5] + m1[8] * m2[8];
        this.clone(m1, this.tempm);
    }
}

