/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.ui;

import com.nokia.mid.ui.SoftNotification;
import com.nokia.mid.ui.SoftNotificationException;
import com.nokia.mid.ui.SoftNotificationListener;
import emulator.Emulator;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.pigler.api.PiglerAPI;

public class SoftNotificationImpl
extends SoftNotification {
    private static PiglerAPI pigler;
    private SoftNotificationListener[] iListener;
    private String groupText;
    private String text;
    private boolean hasImage;
    public static TrayIcon trayIcon;
    public static SystemTray tray;
    private static SoftNotificationImpl lastInst;

    public SoftNotificationImpl(int aNotificationId) {
        this.initialize(aNotificationId);
    }

    public SoftNotificationImpl() {
        this.initialize(-1);
    }

    public static void setPigler(PiglerAPI piglerAPI) {
        if (pigler != null && piglerAPI != null) {
            throw new IllegalStateException();
        }
        pigler = piglerAPI;
    }

    protected void initialize(int aNotificationId) {
        lastInst = this;
        this.iListener = new SoftNotificationListener[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notificationCallback(int aEventArg) {
        SoftNotificationListener[] softNotificationListenerArray = this.iListener;
        synchronized (this.iListener) {
            SoftNotificationListener listener = this.iListener[0];
            if (listener != null) {
                if (aEventArg == 1) {
                    listener.notificationSelected(this);
                } else if (aEventArg == 2) {
                    listener.notificationDismissed(this);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public int getId() {
        return -1;
    }

    @Override
    public void post() throws SoftNotificationException {
        try {
            trayIcon.displayMessage(this.groupText, this.text == null ? "" : this.text, this.hasImage ? TrayIcon.MessageType.NONE : TrayIcon.MessageType.INFO);
        }
        catch (Exception e2) {
            throw new SoftNotificationException(e2.toString());
        }
    }

    @Override
    public void remove() throws SoftNotificationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListener(SoftNotificationListener aListener) {
        SoftNotificationListener[] softNotificationListenerArray = this.iListener;
        synchronized (this.iListener) {
            this.iListener[0] = aListener;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setText(String aText, String aGroupText) throws SoftNotificationException {
        this.text = aText;
        this.groupText = aGroupText;
    }

    @Override
    public void setSoftkeyLabels(String aSoftkey1Label, String aSoftkey2Label) throws SoftNotificationException {
    }

    @Override
    public void setImage(byte[] aImageData) throws SoftNotificationException {
        try {
            trayIcon.setImage(ImageIO.read(new ByteArrayInputStream(aImageData)));
        }
        catch (IOException e2) {
            throw new SoftNotificationException(e2.toString());
        }
        this.hasImage = true;
        trayIcon.setImageAutoSize(true);
    }

    protected static void action(int i2) {
        if (lastInst != null) {
            lastInst.notificationCallback(i2);
        } else if (pigler != null) {
            pigler._callback(i2);
        }
    }

    static {
        try {
            tray = SystemTray.getSystemTray();
            trayIcon = new TrayIcon(ImageIO.read(SoftNotification.class.getResourceAsStream("/res/icon")), Emulator.getMidletName());
            trayIcon.addActionListener(e2 -> SoftNotificationImpl.action(1));
            tray.add(trayIcon);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

