/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.ui;

import com.nokia.mid.ui.CanvasItem;
import com.nokia.mid.ui.TextEditorListener;
import emulator.Emulator;
import emulator.lcdui.TextUtils;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TextEditor
extends CanvasItem {
    private Font iFont;
    private int iMaxSize;
    private int iConstraints;
    private String iCharacterSubset;
    private int iRows;
    private boolean iMultiline;
    private TextEditorListener iListener;
    private String iContent;
    private int iBgColor;
    private int iFgColor;
    private int iFocusBgColor;
    private int iFocusFgColor;
    private boolean iFocusBgColorSet;
    private boolean iFocusFgColorSet;
    private boolean iFocused;
    private int iContentHeight;
    private boolean updateFocus;
    private String[] textArr;
    private int caretX;
    private int caretY;

    public static TextEditor createTextEditor(String text, int maxSize, int constraints, int width, int height) {
        return new TextEditor(text, maxSize, constraints, width, height, false);
    }

    public static TextEditor createTextEditor(int maxSize, int constraints, int width, int rows) {
        return new TextEditor("", maxSize, constraints, width, rows, true);
    }

    public void setFocus(boolean focused) {
        if (this.iFocused == focused || focused && !this.iVisible) {
            return;
        }
        if (!focused) {
            Emulator.getEmulator().getScreen().getCaret().defocusItem(this);
        } else {
            Emulator.getEmulator().getScreen().getCaret().focusItem(this, this.caretX, this.caretY);
        }
        this.iFocused = focused;
        this.updateFocus = true;
    }

    public boolean hasFocus() {
        return this.iFocused;
    }

    @Override
    public void setParent(Object parent) {
        if (parent != null && !(parent instanceof Canvas) || parent != null && this.iParent != null && this.iParent != parent) {
            throw new IllegalArgumentException("The object is not a valid parent object");
        }
        if (this.iParent != null) {
            ((Canvas)this.iParent)._removeNokiaCanvasItem(this);
        }
        this.iParent = parent;
        if (parent != null) {
            ((Canvas)parent)._addNokiaCanvasItem(this);
        } else {
            this.setFocus(false);
            this.iVisible = false;
        }
    }

    @Override
    public void setSize(int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("The given arguments are not valid");
        }
        this.iWidth = width;
        this.iHeight = height;
        this.updateFocus = true;
        this.layout();
        this.repaint();
    }

    @Override
    public void setPosition(int x, int y) {
        this.iPositionX = x;
        this.iPositionY = y;
        this.updateFocus = true;
        this.repaint();
    }

    public void setSize(int x, int y, int width, int height) {
        this.setPosition(x, y);
        this.setSize(width, height);
    }

    @Override
    public void setVisible(boolean visible) {
        this.checkParent();
        if (visible == this.iVisible) {
            return;
        }
        if (!visible) {
            this.setFocus(false);
        }
        this.iVisible = visible;
        this.repaint();
    }

    @Override
    public void setZPosition(int z) {
        if (z < 0) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public int getZPosition() {
        return 0;
    }

    public int getLineMarginHeight() {
        return 0;
    }

    public int getContentHeight() {
        return this.iContentHeight;
    }

    public void setCaret(int index) {
        if (this.iFocused) {
            Emulator.getEmulator().getScreen().getCaret().setCaret(index);
        }
    }

    public int getCaretPosition() {
        if (this.iFocused) {
            return Emulator.getEmulator().getScreen().getCaret().getCaretPosition();
        }
        return 0;
    }

    public int getVisibleContentPosition() {
        return 0;
    }

    public Font getFont() {
        return this.iFont == null ? Font.getDefaultFont() : this.iFont;
    }

    public void setFont(Font font) {
        if (font == null) {
            font = Font.getDefaultFont();
        }
        this.iFont = font;
        this.updateFocus = true;
    }

    public int getBackgroundColor() {
        return this.iBgColor;
    }

    public int getForegroundColor() {
        return this.iFgColor;
    }

    public void setBackgroundColor(int color) {
        this.iBgColor = color;
    }

    public void setForegroundColor(int color) {
        this.iFgColor = color;
    }

    public void setHighlightBackgroundColor(int color) {
        this.iFocusBgColor = color;
        this.iFocusBgColorSet = true;
    }

    public void setHighlightForegroundColor(int color) {
        this.iFocusFgColor = color;
        this.iFocusFgColorSet = true;
    }

    public void setContent(String content) {
        if (content == null || content.length() > this.iMaxSize) {
            throw new IllegalArgumentException("content");
        }
        this.iContent = content;
        if (this.iVisible) {
            Emulator.getEmulator().getScreen().getCaret().updateText(this, this.iContent);
        }
        this.layout();
        this.repaint();
    }

    public String getContent() {
        return this.iContent;
    }

    public void insert(String text, int position) {
        if (text.length() + this.size() > this.iMaxSize) {
            throw new IllegalArgumentException("The given arguments are not valid");
        }
        this.setContent(this.iContent.substring(0, position) + text + this.iContent.substring(position));
    }

    public void delete(int offset, int length) {
        this.setContent(this.iContent.substring(0, offset) + this.iContent.substring(offset + length));
    }

    public int getMaxSize() {
        return this.iMaxSize;
    }

    public int setMaxSize(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("The given arguments are not valid");
        }
        if (this.iContent != null && this.iContent.length() > maxSize) {
            this.setContent(this.iContent.substring(0, maxSize - 1));
        }
        this.iMaxSize = maxSize;
        return this.iMaxSize;
    }

    public int size() {
        return this.iContent.length();
    }

    public void setConstraints(int constraints) {
        this.iConstraints = constraints;
    }

    public int getConstraints() {
        return this.iConstraints;
    }

    public void setInitialInputMode(String characterSubset) {
        this.iCharacterSubset = characterSubset;
    }

    public String getInitialInputMode() {
        return this.iCharacterSubset;
    }

    public void setSelection(int index, int length) {
        if (this.iFocused) {
            Emulator.getEmulator().getScreen().getCaret().setSelection(index, length);
        }
    }

    public String getSelection() {
        if (this.iFocused) {
            return Emulator.getEmulator().getScreen().getCaret().getSelection();
        }
        return null;
    }

    public void setTextEditorListener(TextEditorListener listener) {
        this.iListener = listener;
    }

    public boolean isMultiline() {
        return this.iMultiline;
    }

    public void setMultiline(boolean aMultiline) {
        this.iMultiline = aMultiline;
    }

    @Override
    public int getHeight() {
        if (this.iHeight == -1) {
            return Math.max(this.getFont().getHeight() + 4, this.iContentHeight);
        }
        return this.iHeight;
    }

    @Override
    public int getWidth() {
        return this.iWidth;
    }

    public void setIndicatorVisibility(boolean b2) {
    }

    TextEditor() {
    }

    TextEditor(String text, int maxSize, int constraints, int width, int height, boolean rows) {
        this.setMaxSize(maxSize);
        this.setConstraints(constraints);
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("The given arguments are not valid");
        }
        this.iWidth = width;
        this.setContent(text == null ? "" : text);
        if (rows) {
            this.setMultiline(height != 1);
            this.iRows = height;
            this.iHeight = -1;
        } else {
            this.iHeight = height;
        }
    }

    public void _invokePaint(Graphics g) {
        int w = this.getWidth();
        int h2 = this.getHeight();
        int x = this.getPositionX();
        int y = this.getPositionY();
        Font font = this.getFont();
        g.setFont(font);
        g._setColor(this.iFocused && this.iFocusBgColorSet ? this.iFocusBgColor : this.iBgColor);
        g.fillRect(x, y, w, h2);
        if ((this.caretX != x || this.caretY != y || this.updateFocus) && this.iFocused) {
            this.updateFocus = false;
            this.caretX = x;
            this.caretY = y;
            Emulator.getEmulator().getScreen().getCaret().focusItem(this, this.caretX, this.caretY);
        }
        if (this.iContent.isEmpty() && !this.iFocused) {
            g.setColor(0xAAAAAA);
            g.drawString("Tap", x + 4, y + 2, 0);
            return;
        }
        g._setColor(this.iFocused && this.iFocusFgColorSet ? this.iFocusFgColor : this.iFgColor);
        if (!this.iMultiline) {
            g.drawString(this.textArr[0], x + 4, y + 2, 0);
            return;
        }
        int th = font.getHeight() + 4;
        int l = 0;
        while (th * this.textArr.length > h2 + th * l) {
            ++l;
        }
        for (int j = l; j < this.textArr.length; ++j) {
            g.drawString(this.textArr[j], x + 4, y + 2, 0);
            y += th;
        }
    }

    public void _contentChanged(String s) {
        this.iContent = s;
        this.layout();
        this.repaint();
        if (this.iListener != null) {
            this.iListener.inputAction(this, 1);
        }
    }

    public void _inputAction(int a2) {
        if (this.iListener != null) {
            this.iListener.inputAction(this, a2);
        }
    }

    private void layout() {
        int availableWidth = this.getWidth() - 8;
        Font font = this.getFont();
        this.textArr = TextUtils.textArr(this.iContent, font, availableWidth, availableWidth);
        this.iContentHeight = 4 + (font.getHeight() + 4) * this.textArr.length;
    }

    private void repaint() {
        if (this.iParent != null) {
            ((Canvas)this.iParent).repaint();
        }
    }
}

