/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.opt.ui;

import com.nttdocomo.opt.ui.Sprite;
import com.nttdocomo.ui.UIException;

public class SpriteSet {
    private static int MAX_SPRITES = 32;
    Sprite[] spriteList;
    int numSprites;

    public SpriteSet(Sprite[] paramArrayOfSprite) {
        int i2 = paramArrayOfSprite.length;
        if (i2 == 0 || i2 > 32) {
            throw new IllegalArgumentException();
        }
        this.numSprites = i2;
        this.spriteList = paramArrayOfSprite;
    }

    public int getCount() {
        return this.numSprites;
    }

    public Sprite[] getSprites() {
        return this.spriteList;
    }

    public Sprite getSprite(int paramInt) {
        return this.spriteList[paramInt];
    }

    public void setCollisionAll() {
        for (int i2 = 0; i2 < this.numSprites; ++i2) {
            this.setCollisionOf(i2);
        }
    }

    public void setCollisionOf(int paramInt) {
        this.spriteList[paramInt].flags = 0;
        if (this.spriteList[paramInt].image == null) {
            return;
        }
        try {
            int n = this.spriteList[paramInt].image.getWidth();
        }
        catch (UIException localUIException1) {
            return;
        }
        if (!this.spriteList[paramInt].visible) {
            return;
        }
        for (int j = 0; j < this.numSprites; ++j) {
            if (j == paramInt || !this.spriteList[j].visible || this.spriteList[j].image == null) continue;
            try {
                int n = this.spriteList[j].image.getWidth();
            }
            catch (UIException localUIException2) {
                continue;
            }
            if (!this.hasIntersect(paramInt, j)) continue;
            this.spriteList[paramInt].flags |= 1 << j;
        }
    }

    public boolean isCollision(int paramInt1, int paramInt2) {
        if (paramInt1 < 0 || paramInt1 >= this.numSprites || paramInt2 < 0 || paramInt2 >= this.numSprites) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (this.spriteList[paramInt1].flags & 1 << paramInt2) != 0;
    }

    public int getCollisionFlag(int paramInt) {
        return this.spriteList[paramInt].flags;
    }

    private boolean hasIntersect(int paramInt1, int paramInt2) {
        int i2 = this.spriteList[paramInt1].dx;
        int j = this.spriteList[paramInt1].dy;
        int k2 = i2 + this.spriteList[paramInt1].getWidth() - 1;
        int m2 = j + this.spriteList[paramInt1].getHeight() - 1;
        int n = this.spriteList[paramInt2].dx;
        int i1 = this.spriteList[paramInt2].dy;
        int i22 = n + this.spriteList[paramInt2].getWidth() - 1;
        int i3 = i1 + this.spriteList[paramInt2].getHeight() - 1;
        return k2 >= n && i22 >= i2 && m2 >= i1 && i3 >= j;
    }
}

