/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.opt.ui.j3d;

import com.nttdocomo.opt.ui.Graphics2;
import com.nttdocomo.opt.ui.j3d.AffineTrans;
import com.nttdocomo.opt.ui.j3d.Figure;
import com.nttdocomo.opt.ui.j3d.Graphics3D;
import com.nttdocomo.opt.ui.j3d.Texture;
import com.nttdocomo.opt.ui.j3d.Vector3D;
import com.nttdocomo.ui.Frame;
import com.nttdocomo.ui.ogl.DirectBuffer;
import com.nttdocomo.ui.ogl.GraphicsOGL;
import emulator.Emulator;
import emulator.graphics2D.IImage;
import javax.microedition.lcdui.Graphics;
import ru.woesss.j2me.micro3d.Render;

public class Micro3DGraphics
extends Graphics2
implements Graphics3D,
GraphicsOGL {
    private Texture sphereTexture;
    private Graphics graphics;
    private AffineTrans affine;
    private int scaleX;
    private int scaleY;
    private int centerX;
    private int centerY;
    private int clipX;
    private int clipY;
    private int clipWidth;
    private int clipHeight;
    private boolean blend;
    private boolean sphereMap;
    private boolean light;
    private Vector3D directionLightVector;
    private int ambientLight;
    private int directionLight;
    private int near;
    private int far;
    private int angle;
    private int projection;

    public Micro3DGraphics(Frame owner, Graphics a2) {
        super(owner, a2);
    }

    @Override
    public void setViewTrans(AffineTrans t) {
        if (t == null) {
            t = new AffineTrans(4096, 0, 0, 0, 0, 4096, 0, 0, 0, 0, 4096, 0);
        }
        this.affine = t;
    }

    @Override
    public void setScreenScale(int x_scale, int y_scale) {
        this.scaleX = x_scale;
        this.scaleY = y_scale;
    }

    @Override
    public void setScreenCenter(int cx, int cy) {
        this.centerX = cx;
        this.centerY = cy;
    }

    @Override
    public void drawFigure(Figure figure) {
        IImage img = Emulator.getEmulator().getScreen().getBackBufferImage();
        if (this.graphics == null) {
            this.graphics = new Graphics(img, null);
        } else {
            this.graphics._reset(img, null);
        }
        this.graphics.setClip(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        Render render = Render.getRender();
        render.bind(this.graphics, true);
        int attrs = render.getAttributes();
        Micro3DGraphics.getViewTrans(this.affine, render.getViewMatrix());
        render.setCenter(this.centerX, this.centerY);
        render.setOrthographicScale(this.scaleX, this.scaleY);
        attrs = this.blend ? (attrs |= 8) : (attrs &= 0xFFFFFFF7);
        attrs = this.sphereMap ? (attrs |= 2) : (attrs &= 0xFFFFFFFD);
        render.setAttribute(attrs);
        if (this.sphereTexture != null) {
            render.setSphereTexture(this.sphereTexture.impl);
            render.setToonParam(this.sphereTexture.toonThreshold, this.sphereTexture.toonHigh, this.sphereTexture.toonLow);
        } else {
            render.setToonParam(0, 0, 0);
        }
        if (this.light) {
            if (this.directionLightVector != null) {
                render.setLight(this.ambientLight, this.directionLight, this.directionLightVector.x, this.directionLightVector.y, this.directionLightVector.z);
            } else {
                render.setLight(this.ambientLight, 0, 0, 0, 0);
            }
        } else {
            render.setLight(4096, 0, 0, 0, 4096);
        }
        if (this.projection == 2) {
            render.setPerspectiveFov(this.near, this.far, this.angle);
        }
        if (figure != null) {
            render.drawFigure(figure.impl);
        }
        render.release();
    }

    @Override
    public void executeCommandList(int[] a2) {
        IImage img = Emulator.getEmulator().getScreen().getBackBufferImage();
        if (this.graphics == null) {
            this.graphics = new Graphics(img, null);
        } else {
            this.graphics._reset(img, null);
        }
        this.graphics.setClip(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        Render render = Render.getRender();
        render.bind(this.graphics, true);
        int attrs = render.getAttributes();
        Micro3DGraphics.getViewTrans(this.affine, render.getViewMatrix());
        render.setCenter(this.centerX, this.centerY);
        render.setOrthographicScale(this.scaleX, this.scaleY);
        attrs = this.blend ? (attrs |= 8) : (attrs &= 0xFFFFFFF7);
        attrs = this.sphereMap ? (attrs |= 2) : (attrs &= 0xFFFFFFFD);
        render.setAttribute(attrs);
        if (this.sphereTexture != null) {
            render.setSphereTexture(this.sphereTexture.impl);
            render.setToonParam(this.sphereTexture.toonThreshold, this.sphereTexture.toonHigh, this.sphereTexture.toonLow);
        } else {
            render.setToonParam(0, 0, 0);
        }
        if (this.light) {
            if (this.directionLightVector != null) {
                render.setLight(this.ambientLight, this.directionLight, this.directionLightVector.x, this.directionLightVector.y, this.directionLightVector.z);
            } else {
                render.setLight(this.ambientLight, 0, 0, 0, 0);
            }
        } else {
            render.setLight(4096, 0, 0, 0, 4096);
        }
        if (this.projection == 2) {
            render.setPerspectiveFov(this.near, this.far, this.angle);
        }
        render.drawCommandList(a2);
        render.release();
    }

    @Override
    public void setSphereTexture(Texture paramTexture) {
        this.sphereTexture = paramTexture;
    }

    @Override
    public void enableLight(boolean paramBoolean) {
        this.light = paramBoolean;
    }

    @Override
    public void enableSphereMap(boolean paramBoolean) {
        this.sphereMap = paramBoolean;
    }

    @Override
    public void setAmbientLight(int paramInt) {
        this.ambientLight = paramInt;
    }

    @Override
    public void setDirectionLight(Vector3D paramVector3D, int paramInt) {
        this.directionLightVector = paramVector3D;
        this.directionLight = paramInt;
    }

    @Override
    public void enableSemiTransparent(boolean paramBoolean) {
        this.blend = paramBoolean;
    }

    @Override
    public void setClipRect3D(int x, int y, int width, int height) {
        this.clipX = x;
        this.clipY = y;
        this.clipWidth = width;
        this.clipHeight = height;
    }

    @Override
    public final void setPerspective(int zNear, int zFar, int angle) {
        if (zNear >= zFar || zNear < 1 || zNear > 32766 || zFar > Short.MAX_VALUE || angle < 1 || angle > 2047) {
            throw new IllegalArgumentException("zNear=" + zNear + ", zFar=" + zFar + ", angle=" + angle);
        }
        this.near = zNear;
        this.far = zFar;
        this.angle = angle;
        this.projection = 2;
    }

    private static void getViewTrans(AffineTrans a2, float[] out) {
        out[0] = (float)a2.m00 * 2.4414062E-4f;
        out[3] = (float)a2.m01 * 2.4414062E-4f;
        out[6] = (float)a2.m02 * 2.4414062E-4f;
        out[9] = a2.m03;
        out[1] = (float)a2.m10 * 2.4414062E-4f;
        out[4] = (float)a2.m11 * 2.4414062E-4f;
        out[7] = (float)a2.m12 * 2.4414062E-4f;
        out[10] = a2.m13;
        out[2] = (float)a2.m20 * 2.4414062E-4f;
        out[5] = (float)a2.m21 * 2.4414062E-4f;
        out[8] = (float)a2.m22 * 2.4414062E-4f;
        out[11] = a2.m23;
    }

    @Override
    public void beginDrawing() {
    }

    @Override
    public void endDrawing() {
    }

    @Override
    public void glActiveTexture(int paramInt) {
    }

    @Override
    public void glAlphaFunc(int paramInt, float paramFloat) {
    }

    @Override
    public void glBindTexture(int paramInt1, int paramInt2) {
    }

    @Override
    public void glBlendFunc(int paramInt1, int paramInt2) {
    }

    @Override
    public void glClear(int paramInt) {
    }

    @Override
    public void glClearColor(float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4) {
    }

    @Override
    public void glClearDepthf(float paramFloat) {
    }

    @Override
    public void glClearStencil(int paramInt) {
    }

    @Override
    public void glClientActiveTexture(int paramInt) {
    }

    @Override
    public void glColor4f(float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4) {
    }

    @Override
    public void glColorMask(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3, boolean paramBoolean4) {
    }

    @Override
    public void glColorPointer(int paramInt1, int paramInt2, int paramInt3, DirectBuffer paramDirectBuffer) {
    }

    @Override
    public void glCompressedTexImage2D(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, DirectBuffer paramDirectBuffer) {
    }

    @Override
    public void glCompressedTexSubImage2D(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, DirectBuffer paramDirectBuffer) {
    }

    @Override
    public void glCopyTexImage2D(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8) {
    }

    @Override
    public void glCopyTexSubImage2D(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8) {
    }

    @Override
    public void glCullFace(int paramInt) {
    }

    @Override
    public void glDeleteTextures(int paramInt, int[] paramArrayOfInt) {
    }

    @Override
    public void glDepthFunc(int paramInt) {
    }

    @Override
    public void glDepthMask(boolean paramBoolean) {
    }

    @Override
    public void glDepthRangef(float paramFloat1, float paramFloat2) {
    }

    @Override
    public void glDisable(int paramInt) {
    }

    @Override
    public void glDisableClientState(int paramInt) {
    }

    @Override
    public void glDrawArrays(int paramInt1, int paramInt2, int paramInt3) {
    }

    @Override
    public void glDrawElements(int paramInt1, int paramInt2, int paramInt3, DirectBuffer paramDirectBuffer) {
    }

    @Override
    public void glEnable(int paramInt) {
    }

    @Override
    public void glEnableClientState(int paramInt) {
    }

    @Override
    public void glFlush() {
    }

    @Override
    public void glFogf(int paramInt, float paramFloat) {
    }

    @Override
    public void glFogfv(int paramInt, float[] paramArrayOfFloat) {
    }

    @Override
    public void glFrontFace(int paramInt) {
    }

    @Override
    public void glFrustumf(float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4, float paramFloat5, float paramFloat6) {
    }

    @Override
    public void glGenTextures(int paramInt, int[] paramArrayOfInt) {
    }

    @Override
    public int glGetError() {
        return 0;
    }

    @Override
    public void glGetIntegerv(int paramInt, int[] paramArrayOfInt) {
    }

    @Override
    public void glHint(int paramInt1, int paramInt2) {
    }

    @Override
    public void glLightModelf(int paramInt, float paramFloat) {
    }

    @Override
    public void glLightModelfv(int paramInt, float[] paramArrayOfFloat) {
    }

    @Override
    public void glLightf(int paramInt1, int paramInt2, float paramFloat) {
    }

    @Override
    public void glLightfv(int paramInt1, int paramInt2, float[] paramArrayOfFloat) {
    }

    @Override
    public void glLineWidth(float paramFloat) {
    }

    @Override
    public void glLoadIdentity() {
    }

    @Override
    public void glLoadMatrixf(float[] paramArrayOfFloat) {
    }

    @Override
    public void glLogicOp(int paramInt) {
    }

    @Override
    public void glMaterialf(int paramInt1, int paramInt2, float paramFloat) {
    }

    @Override
    public void glMaterialfv(int paramInt1, int paramInt2, float[] paramArrayOfFloat) {
    }

    @Override
    public void glMatrixMode(int paramInt) {
    }

    @Override
    public void glMultMatrixf(float[] paramArrayOfFloat) {
    }

    @Override
    public void glMultiTexCoord4f(int paramInt, float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4) {
    }

    @Override
    public void glNormal3f(float paramFloat1, float paramFloat2, float paramFloat3) {
    }

    @Override
    public void glNormalPointer(int paramInt1, int paramInt2, DirectBuffer paramDirectBuffer) {
    }

    @Override
    public void glOrthof(float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4, float paramFloat5, float paramFloat6) {
    }

    @Override
    public void glPixelStorei(int paramInt1, int paramInt2) {
    }

    @Override
    public void glPointSize(float paramFloat) {
    }

    @Override
    public void glPolygonOffset(float paramFloat1, float paramFloat2) {
    }

    @Override
    public void glPopMatrix() {
    }

    @Override
    public void glPushMatrix() {
    }

    @Override
    public void glRotatef(float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4) {
    }

    @Override
    public void glSampleCoverage(float paramFloat, boolean paramBoolean) {
    }

    @Override
    public void glScalef(float paramFloat1, float paramFloat2, float paramFloat3) {
    }

    @Override
    public void glScissor(int paramInt1, int paramInt2, int paramInt3, int paramInt4) {
    }

    @Override
    public void glShadeModel(int paramInt) {
    }

    @Override
    public void glStencilFunc(int paramInt1, int paramInt2, int paramInt3) {
    }

    @Override
    public void glStencilMask(int paramInt) {
    }

    @Override
    public void glStencilOp(int paramInt1, int paramInt2, int paramInt3) {
    }

    @Override
    public void glTexCoordPointer(int paramInt1, int paramInt2, int paramInt3, DirectBuffer paramDirectBuffer) {
    }

    @Override
    public void glTexEnvf(int paramInt1, int paramInt2, float paramFloat) {
    }

    @Override
    public void glTexEnvfv(int paramInt1, int paramInt2, float[] paramArrayOfFloat) {
    }

    @Override
    public void glTexImage2D(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, DirectBuffer paramDirectBuffer) {
    }

    @Override
    public void glTexParameterf(int paramInt1, int paramInt2, float paramFloat) {
    }

    @Override
    public void glTexSubImage2D(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, int paramInt8, DirectBuffer paramDirectBuffer) {
    }

    @Override
    public void glTranslatef(float paramFloat1, float paramFloat2, float paramFloat3) {
    }

    @Override
    public void glVertexPointer(int paramInt1, int paramInt2, int paramInt3, DirectBuffer paramDirectBuffer) {
    }

    @Override
    public void glViewport(int paramInt1, int paramInt2, int paramInt3, int paramInt4) {
    }
}

