/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.ui;

import com.nttdocomo.ui.Canvas;
import com.nttdocomo.ui.Display;
import com.nttdocomo.ui.Font;
import com.nttdocomo.ui.Frame;
import com.nttdocomo.ui.Image;
import com.nttdocomo.ui.ImageMap;
import com.nttdocomo.ui.SpriteSet;
import com.nttdocomo.ui.UIException;
import com.nttdocomo.ui.maker.ImageImpl;
import emulator.graphics2D.GraphicsUtils;
import java.awt.Color;
import javax.microedition.lcdui.game.GameCanvas;

public class Graphics {
    public static final int FLIP_NONE = 0;
    public static final int FLIP_HORIZONTAL = 1;
    public static final int FLIP_VERTICAL = 2;
    public static final int FLIP_ROTATE = 3;
    public static final int FLIP_ROTATE_LEFT = 4;
    public static final int FLIP_ROTATE_RIGHT = 5;
    private final Frame owner;
    protected javax.microedition.lcdui.Graphics impl;
    boolean b;
    int c;
    int d;
    public static final int BLACK = 0;
    public static final int BLUE = 1;
    public static final int LIME = 2;
    public static final int AQUA = 3;
    public static final int RED = 4;
    public static final int FUCHSIA = 5;
    public static final int YELLOW = 6;
    public static final int WHITE = 7;
    public static final int GRAY = 8;
    public static final int NAVY = 9;
    public static final int GREEN = 10;
    public static final int TEAL = 11;
    public static final int MAROON = 12;
    public static final int PURPLE = 13;
    public static final int OLIVE = 14;
    public static final int SILVER = 15;

    public Graphics(Frame owner, javax.microedition.lcdui.Graphics a2) {
        this.owner = owner;
        this.impl = a2;
        this.b = true;
        this.c = 0;
        this.d = 0;
    }

    public Graphics copy() {
        return new Graphics(this.owner, this.impl._copy());
    }

    public void dispose() {
        this.b = false;
    }

    public synchronized void lock() {
        ++this.c;
    }

    public synchronized void unlock(boolean b2) {
        int c2;
        this.c = c2 = this.c - 1;
        if (c2 < 0 || b2) {
            this.c = 0;
        }
        if (this.c == 0 && Display.getCurrent() instanceof Canvas) {
            Canvas canvas = (Canvas)Display.getCurrent();
            if (!canvas.b) {
                ((GameCanvas)canvas.a).flushGraphics();
            }
        }
    }

    public void setOrigin(int n, int n2) {
        if (!this.b) {
            throw new UIException(1, "Graphics disposed");
        }
        this.impl.translate(n - this.impl.getTranslateX(), n2 - this.impl.getTranslateY());
    }

    public static int getColorOfRGB(int n, int n2, int n3) {
        return new Color(n, n2, n3).getRGB();
    }

    public static int getColorOfRGB(int n, int n2, int n3, int n4) {
        return new Color(n, n2, n3, n4).getRGB();
    }

    public static int getColorOfName(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 255;
            }
            case 2: {
                return 65280;
            }
            case 3: {
                return 65535;
            }
            case 4: {
                return 0xFF0000;
            }
            case 5: {
                return 0xFF00FF;
            }
            case 6: {
                return 0xFFFF00;
            }
            case 7: {
                return 0xFFFFFF;
            }
            case 8: {
                return 0x808080;
            }
            case 9: {
                return 128;
            }
            case 10: {
                return 32768;
            }
            case 11: {
                return 32896;
            }
            case 12: {
                return 0x800000;
            }
            case 13: {
                return 0x800080;
            }
            case 14: {
                return 0x808000;
            }
            case 15: {
                return 0xC0C0C0;
            }
        }
        throw new IllegalArgumentException("color name is invalid:" + n);
    }

    public void setColor(int color) {
        if (!this.b) {
            throw new UIException(1, "Graphics disposed");
        }
        this.impl.setColor(color);
    }

    public void setFont(Font font) {
        if (!this.b) {
            throw new UIException(1, "Graphics disposed");
        }
        this.impl.setFont(font.getImpl());
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        if (!this.b) {
            throw new UIException(1, "Graphics disposed");
        }
        if (n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("width or height should be positive");
        }
        int color = this.impl.getColor();
        int bgcolor = -1;
        if (this.owner != null) {
            bgcolor = this.owner.backgroundColor;
        }
        this.impl.setColor(bgcolor);
        this.impl.fillRect(n, n2, n3, n4);
        this.impl.setColor(color);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        if (!this.b) {
            throw new UIException(1, "Graphics disposed");
        }
        this.impl.drawLine(n, n2, n3, n4);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        if (!this.b) {
            throw new UIException(1, "Graphics disposed");
        }
        if (n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("width or height should be positive");
        }
        this.impl.drawRect(n, n2, n3, n4);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        if (!this.b) {
            throw new UIException(1, "Graphics disposed");
        }
        if (n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("width or height should be positive");
        }
        this.impl.fillRect(n, n2, n3, n4);
    }

    protected int getMidp2Transformation() {
        switch (this.d) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 5;
            }
        }
        return 0;
    }

    public void drawImage(Image image, int[] array) {
        System.out.println("** Graphics.drawImage(Image image, int[] matrix) not implemented yet **");
    }

    public void drawImage(Image image, int[] array, int n, int n2, int n3, int n4) {
        System.out.println("** Graphics.drawImage(Image image, int[] matrix, int sx, int sy, int width, int height) not implemented yet **");
    }

    public void drawImage(Image image, int n, int n2) {
        if (!this.b) {
            throw new UIException(1, "Graphics disposed");
        }
        this.impl.drawRegion(((ImageImpl)image).getImpl(), 0, 0, image.getWidth(), image.getHeight(), this.getMidp2Transformation(), n, n2, 0);
    }

    public void drawImage(Image image, int dx, int dy, int sx, int sy, int w, int h2) {
        this.impl.drawRegion(((ImageImpl)image).getImpl(), sx, sy, w, h2, this.getMidp2Transformation(), dx, dy, 0);
    }

    public void drawPolyline(int[] array, int[] array2, int n) {
        if (!this.b) {
            throw new UIException(1, "Graphics disposed");
        }
        int[] arrayOfInt3 = new int[n << 1];
        for (int i2 = 0; i2 < n; ++i2) {
            arrayOfInt3[i2 << 1] = array[i2];
            arrayOfInt3[(i2 << 1) + 1] = array2[i2];
        }
        this.impl.getImpl().drawPolyline(arrayOfInt3);
    }

    public void drawPolyline(int[] array, int[] array2, int n, int n2) {
        int[] array3 = new int[n2];
        int[] array4 = new int[n2];
        System.arraycopy(array, n, array3, 0, n2);
        System.arraycopy(array2, n, array4, 0, n2);
        this.drawPolyline(array3, array4, n2);
    }

    public void fillPolygon(int[] array, int[] array2, int n) {
        if (!this.b) {
            throw new UIException(1, "Graphics disposed");
        }
        int[] arrayOfInt3 = new int[n << 1];
        for (int i2 = 0; i2 < n; ++i2) {
            arrayOfInt3[i2 << 1] = array[i2];
            arrayOfInt3[(i2 << 1) + 1] = array2[i2];
        }
        this.impl.getImpl().fillPolygon(arrayOfInt3);
    }

    public void fillPolygon(int[] array, int[] array2, int n, int n2) {
        int[] array3 = new int[n2];
        int[] array4 = new int[n2];
        System.arraycopy(array, n, array3, 0, n2);
        System.arraycopy(array2, n, array4, 0, n2);
        this.fillPolygon(array3, array4, n2);
    }

    public void drawString(String s, int n, int n2) {
        if (!this.b) {
            throw new UIException(1, "Graphics disposed");
        }
        this.impl.drawString(s, n, n2, 36);
    }

    public void drawChars(char[] array, int n, int n2, int n3, int n4) {
        if (!this.b) {
            throw new UIException(1, "Graphics disposed");
        }
        this.drawString(new String(array, n3, n4), n, n2);
    }

    public void setPictoColorEnabled(boolean b2) {
    }

    public void setClip(int n, int n2, int n3, int n4) {
        if (!this.b) {
            throw new UIException(1, "Graphics disposed");
        }
        this.impl.setClip(n, n2, n3, n4);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        if (!this.b) {
            throw new UIException(1, "Graphics disposed");
        }
        this.impl.clipRect(n, n2, n3, n4);
    }

    public void clearClip() {
        if (!this.b) {
            throw new UIException(1, "Graphics disposed");
        }
        this.impl.setClip(0, 0, this.impl._getWidth(), this.impl._getHeight());
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.impl.copyArea(n, n2, n3, n4, n + n5, n2 + n6, 0);
    }

    public void setFlipMode(int d) {
        this.d = d;
    }

    public void drawScaledImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.impl._drawRegion(((ImageImpl)image).getImpl().getImpl(), n5, n6, n7, n8, n3, n4, this.impl.getImpl().getTransform().newTransform(n3, n4, this.getMidp2Transformation(), n, n2, 0));
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.impl.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.impl.fillArc(n, n2, n3, n4, n5, n6);
    }

    public int getPixel(int n, int n2) {
        return this.getRGBPixel(n, n2);
    }

    public int getRGBPixel(int n, int n2) {
        return this.impl.getImage().getRGB(n, n2);
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] array, int n5) {
        return this.getRGBPixels(n, n2, n3, n4, array, n5);
    }

    public int[] getRGBPixels(int n, int n2, int n3, int n4, int[] array, int n5) {
        if (array == null) {
            array = new int[n3 * n4];
        }
        GraphicsUtils.getImageData(this.impl.getImage(), array, n5, n3, n, n2, n3, n4);
        return array;
    }

    public void setPixel(int n, int n2) {
        this.impl.fillRect(n, n2, 1, 1);
    }

    public void setPixel(int n, int n2, int color) {
        int color2 = this.impl.getColor();
        this.impl.setColor(color);
        this.setPixel(n, n2);
        this.impl.setColor(color2);
    }

    public void setRGBPixel(int n, int n2, int n3) {
        this.setPixel(n, n2, n3);
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] array, int n5) {
        this.setRGBPixels(n, n2, n3, n4, array, n5);
    }

    public void setRGBPixels(int n, int n2, int n3, int n4, int[] array, int n5) {
        this.impl.drawRGB(array, n5, n3, n, n2, n3, n4, false);
    }

    public void drawSpriteSet(SpriteSet set) {
        System.out.println("** Graphics.drawSpriteSet(SpriteSet sprites) not implemented yet **");
    }

    public void drawSpriteSet(SpriteSet set, int n, int n2) {
        System.out.println("** Graphics.drawSpriteSet(SpriteSet sprites, int offset, int count) not implemented yet **");
    }

    public void drawImageMap(ImageMap imageMap, int n, int n2) {
        System.out.println("** Graphics.drawImageMap(ImageMap map, int x, int y) not implemented yet **");
    }
}

