/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.ui.maker;

import com.nttdocomo.io.ConnectionException;
import com.nttdocomo.io.maker.ScratchPadConnection;
import emulator.custom.ResourceManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class MediaImpl {
    protected String location;
    protected InputStream in;
    protected byte[] data;
    protected Object resource;

    MediaImpl(String location) {
        if (location == null) {
            throw new NullPointerException();
        }
        this.location = location;
    }

    MediaImpl(InputStream in) {
        if (in == null) {
            throw new NullPointerException();
        }
        this.in = in;
    }

    MediaImpl(byte[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        this.data = new byte[array.length];
        System.arraycopy(array, 0, this.data, 0, array.length);
    }

    protected abstract Object loadResource(InputStream var1) throws IOException;

    protected abstract Object loadResource(byte[] var1) throws IOException;

    protected void useResource() throws ConnectionException {
        if (this.resource == null) {
            try {
                if (this.location != null) {
                    if (this.location.startsWith("scratchpad:")) {
                        ScratchPadConnection open = ScratchPadConnection.open(this.location);
                        DataInputStream openDataInputStream = open.openDataInputStream();
                        if (open.getAccessLength() > 0) {
                            byte[] array = new byte[open.getAccessLength()];
                            openDataInputStream.readFully(array);
                            this.resource = this.loadResource(array);
                        } else {
                            this.resource = this.loadResource(openDataInputStream);
                        }
                        openDataInputStream.close();
                        open.close();
                    } else if (this.location.startsWith("resource:")) {
                        InputStream resourceAsStream = ResourceManager.getResourceAsStream(this.location.substring(11));
                        this.resource = this.loadResource(resourceAsStream);
                        resourceAsStream.close();
                    }
                } else {
                    this.resource = this.in != null ? this.loadResource(this.in) : this.loadResource(this.data);
                }
            }
            catch (IOException ex) {
                throw new ConnectionException(2);
            }
        }
    }
}

