/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.color_game;

import com.siemens.mp.color_game.Layer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite
extends Layer {
    private static final int INVERTED_AXES = 4;
    private static final int X_FLIP = 2;
    private static final int Y_FLIP = 1;
    private static final int ALPHA_BITMASK = -16777216;
    private static final int FULLY_OPAQUE_ALPHA = -16777216;
    Image sourceImage;
    int numberFrames;
    int[] frameCoordsX;
    int[] frameCoordsY;
    int srcFrameWidth;
    int srcFrameHeight;
    int[] frameSequence;
    private int sequenceIndex;
    private boolean customSequenceDefined;
    int collisionRectX;
    int collisionRectY;
    int collisionRectWidth;
    int collisionRectHeight;

    public Sprite(Image image) {
        super(image.getWidth(), image.getHeight());
        this.initializeFrames(image, image.getWidth(), image.getHeight(), false);
        this.initCollisionRectBounds();
    }

    public Sprite(Image image, int frameWidth, int frameHeight) {
        super(frameWidth, frameHeight);
        if (frameWidth < 1 || frameHeight < 1 || image.getWidth() % frameWidth != 0 || image.getHeight() % frameHeight != 0) {
            throw new IllegalArgumentException();
        }
        this.initializeFrames(image, frameWidth, frameHeight, false);
        this.initCollisionRectBounds();
    }

    public Sprite(Sprite s) {
        super(s != null ? s.getWidth() : 0, s != null ? s.getHeight() : 0);
        if (s == null) {
            throw new NullPointerException();
        }
        this.sourceImage = Image.createImage(s.sourceImage);
        this.numberFrames = s.numberFrames;
        this.frameCoordsX = new int[this.numberFrames];
        this.frameCoordsY = new int[this.numberFrames];
        System.arraycopy(s.frameCoordsX, 0, this.frameCoordsX, 0, s.getRawFrameCount());
        System.arraycopy(s.frameCoordsY, 0, this.frameCoordsY, 0, s.getRawFrameCount());
        this.x = s.getX();
        this.y = s.getY();
        this.collisionRectX = s.collisionRectX;
        this.collisionRectY = s.collisionRectY;
        this.collisionRectWidth = s.collisionRectWidth;
        this.collisionRectHeight = s.collisionRectHeight;
        this.srcFrameWidth = s.srcFrameWidth;
        this.srcFrameHeight = s.srcFrameHeight;
        this.setVisible(s.isVisible());
        this.frameSequence = new int[s.getFrameSequenceLength()];
        this.setFrameSequence(s.frameSequence);
        this.setFrame(s.getFrame());
    }

    public void setFrame(int inp_sequenceIndex) {
        if (inp_sequenceIndex < 0 || inp_sequenceIndex >= this.frameSequence.length) {
            throw new IndexOutOfBoundsException();
        }
        this.sequenceIndex = inp_sequenceIndex;
    }

    public final int getFrame() {
        return this.sequenceIndex;
    }

    public int getRawFrameCount() {
        return this.numberFrames;
    }

    public int getFrameSequenceLength() {
        return this.frameSequence.length;
    }

    public void nextFrame() {
        this.sequenceIndex = (this.sequenceIndex + 1) % this.frameSequence.length;
    }

    public void prevFrame() {
        this.sequenceIndex = this.sequenceIndex == 0 ? this.frameSequence.length - 1 : --this.sequenceIndex;
    }

    @Override
    public final void paint(Graphics g) {
        if (g == null) {
            throw new NullPointerException();
        }
        if (this.visible) {
            g.drawRegion(this.sourceImage, this.frameCoordsX[this.frameSequence[this.sequenceIndex]], this.frameCoordsY[this.frameSequence[this.sequenceIndex]], this.srcFrameWidth, this.srcFrameHeight, 0, this.x, this.y, 20);
        }
    }

    public void setFrameSequence(int[] sequence) {
        if (sequence == null) {
            this.sequenceIndex = 0;
            this.customSequenceDefined = false;
            this.frameSequence = new int[this.numberFrames];
            for (int i2 = 0; i2 < this.numberFrames; ++i2) {
                this.frameSequence[i2] = i2;
            }
            return;
        }
        if (sequence.length < 1) {
            throw new IllegalArgumentException();
        }
        for (int aSequence : sequence) {
            if (aSequence >= 0 && aSequence < this.numberFrames) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        this.customSequenceDefined = true;
        this.frameSequence = new int[sequence.length];
        System.arraycopy(sequence, 0, this.frameSequence, 0, sequence.length);
        this.sequenceIndex = 0;
    }

    public void setImage(Image img, int frameWidth, int frameHeight) {
        if (frameWidth < 1 || frameHeight < 1 || img.getWidth() % frameWidth != 0 || img.getHeight() % frameHeight != 0) {
            throw new IllegalArgumentException();
        }
        int noOfFrames = img.getWidth() / frameWidth * (img.getHeight() / frameHeight);
        boolean maintainCurFrame = true;
        if (noOfFrames < this.numberFrames) {
            maintainCurFrame = false;
            this.customSequenceDefined = false;
        }
        if (this.srcFrameWidth != frameWidth || this.srcFrameHeight != frameHeight) {
            this.setWidth(frameWidth);
            this.setHeight(frameHeight);
            this.initializeFrames(img, frameWidth, frameHeight, maintainCurFrame);
            this.initCollisionRectBounds();
        } else {
            this.initializeFrames(img, frameWidth, frameHeight, maintainCurFrame);
        }
    }

    public final boolean collidesWith(Sprite s, boolean pixelLevel) {
        if (!s.visible || !this.visible) {
            return false;
        }
        int otherLeft = s.x + s.collisionRectX;
        int otherTop = s.y + s.collisionRectY;
        int otherRight = otherLeft + s.collisionRectWidth;
        int otherBottom = otherTop + s.collisionRectHeight;
        int left = this.x + this.collisionRectX;
        int top = this.y + this.collisionRectY;
        int right = left + this.collisionRectWidth;
        int bottom = top + this.collisionRectHeight;
        if (this.intersectRect(otherLeft, otherTop, otherRight, otherBottom, left, top, right, bottom)) {
            if (pixelLevel) {
                if (this.collisionRectX < 0) {
                    left = this.x;
                }
                if (this.collisionRectY < 0) {
                    top = this.y;
                }
                if (this.collisionRectX + this.collisionRectWidth > this.width) {
                    right = this.x + this.width;
                }
                if (this.collisionRectY + this.collisionRectHeight > this.height) {
                    bottom = this.y + this.height;
                }
                if (s.collisionRectX < 0) {
                    otherLeft = s.x;
                }
                if (s.collisionRectY < 0) {
                    otherTop = s.y;
                }
                if (s.collisionRectX + s.collisionRectWidth > s.width) {
                    otherRight = s.x + s.width;
                }
                if (s.collisionRectY + s.collisionRectHeight > s.height) {
                    otherBottom = s.y + s.height;
                }
                if (!this.intersectRect(otherLeft, otherTop, otherRight, otherBottom, left, top, right, bottom)) {
                    return false;
                }
                int intersectLeft = left < otherLeft ? otherLeft : left;
                int intersectTop = top < otherTop ? otherTop : top;
                int intersectRight = right < otherRight ? right : otherRight;
                int intersectBottom = bottom < otherBottom ? bottom : otherBottom;
                int intersectWidth = Math.abs(intersectRight - intersectLeft);
                int intersectHeight = Math.abs(intersectBottom - intersectTop);
                int thisImageXOffset = this.getImageTopLeftX(intersectLeft);
                int thisImageYOffset = this.getImageTopLeftY(intersectTop);
                int otherImageXOffset = s.getImageTopLeftX(intersectLeft);
                int otherImageYOffset = s.getImageTopLeftY(intersectTop);
                return Sprite.doPixelCollision(thisImageXOffset, thisImageYOffset, otherImageXOffset, otherImageYOffset, this.sourceImage, s.sourceImage, intersectWidth, intersectHeight);
            }
            return true;
        }
        return false;
    }

    public final boolean collidesWith(Image image, int inp_x, int inp_y, boolean pixelLevel) {
        int bottom;
        int right;
        int top;
        int left;
        int otherBottom;
        if (!this.visible) {
            return false;
        }
        int otherLeft = inp_x;
        int otherTop = inp_y;
        int otherRight = inp_x + image.getWidth();
        if (this.intersectRect(otherLeft, otherTop, otherRight, otherBottom = inp_y + image.getHeight(), left = this.x + this.collisionRectX, top = this.y + this.collisionRectY, right = left + this.collisionRectWidth, bottom = top + this.collisionRectHeight)) {
            if (pixelLevel) {
                if (this.collisionRectX < 0) {
                    left = this.x;
                }
                if (this.collisionRectY < 0) {
                    top = this.y;
                }
                if (this.collisionRectX + this.collisionRectWidth > this.width) {
                    right = this.x + this.width;
                }
                if (this.collisionRectY + this.collisionRectHeight > this.height) {
                    bottom = this.y + this.height;
                }
                if (!this.intersectRect(otherLeft, otherTop, otherRight, otherBottom, left, top, right, bottom)) {
                    return false;
                }
                int intersectLeft = left < otherLeft ? otherLeft : left;
                int intersectTop = top < otherTop ? otherTop : top;
                int intersectRight = right < otherRight ? right : otherRight;
                int intersectBottom = bottom < otherBottom ? bottom : otherBottom;
                int intersectWidth = Math.abs(intersectRight - intersectLeft);
                int intersectHeight = Math.abs(intersectBottom - intersectTop);
                int thisImageXOffset = this.getImageTopLeftX(intersectLeft);
                int thisImageYOffset = this.getImageTopLeftY(intersectTop);
                int otherImageXOffset = intersectLeft - inp_x;
                int otherImageYOffset = intersectTop - inp_y;
                return Sprite.doPixelCollision(thisImageXOffset, thisImageYOffset, otherImageXOffset, otherImageYOffset, this.sourceImage, image, intersectWidth, intersectHeight);
            }
            return true;
        }
        return false;
    }

    public void setCollisionRectangle(int x, int y, int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        this.collisionRectX = x;
        this.collisionRectY = y;
        this.collisionRectWidth = width;
        this.collisionRectHeight = height;
    }

    private void initializeFrames(Image image, int fWidth, int fHeight, boolean maintainCurFrame) {
        int imageW = image.getWidth();
        int imageH = image.getHeight();
        int numHorizontalFrames = imageW / fWidth;
        int numVerticalFrames = imageH / fHeight;
        this.sourceImage = image;
        this.srcFrameWidth = fWidth;
        this.srcFrameHeight = fHeight;
        this.numberFrames = numHorizontalFrames * numVerticalFrames;
        this.frameCoordsX = new int[this.numberFrames];
        this.frameCoordsY = new int[this.numberFrames];
        if (!maintainCurFrame) {
            this.sequenceIndex = 0;
        }
        if (!this.customSequenceDefined) {
            this.frameSequence = new int[this.numberFrames];
        }
        int currentFrame = 0;
        for (int yy = 0; yy < imageH; yy += fHeight) {
            for (int xx = 0; xx < imageW; xx += fWidth) {
                this.frameCoordsX[currentFrame] = xx;
                this.frameCoordsY[currentFrame] = yy;
                if (!this.customSequenceDefined) {
                    this.frameSequence[currentFrame] = currentFrame;
                }
                ++currentFrame;
            }
        }
    }

    private void initCollisionRectBounds() {
        this.collisionRectX = 0;
        this.collisionRectY = 0;
        this.collisionRectWidth = this.width;
        this.collisionRectHeight = this.height;
    }

    private boolean intersectRect(int r1x1, int r1y1, int r1x2, int r1y2, int r2x1, int r2y1, int r2x2, int r2y2) {
        return r2x1 < r1x2 && r2y1 < r1y2 && r2x2 > r1x1 && r2y2 > r1y1;
    }

    private static boolean doPixelCollision(int image1XOffset, int image1YOffset, int image2XOffset, int image2YOffset, Image image1, Image image2, int width, int height) {
        int numPixels = height * width;
        int[] argbData1 = new int[numPixels];
        int[] argbData2 = new int[numPixels];
        image1.getRGB(argbData1, 0, width, image1XOffset, image1YOffset, width, height);
        image2.getRGB(argbData2, 0, width, image2XOffset, image2YOffset, width, height);
        int xLocalBegin1 = 0;
        int xLocalBegin2 = 0;
        for (int numIterRows = 0; numIterRows < height; ++numIterRows) {
            int x1 = xLocalBegin1;
            int x2 = xLocalBegin2;
            for (int numIterColumns = 0; numIterColumns < width; ++numIterColumns) {
                if ((argbData1[x1] & 0xFF000000) == -16777216 && (argbData2[x2] & 0xFF000000) == -16777216) {
                    return true;
                }
                ++x1;
                ++x2;
            }
            xLocalBegin1 += width;
            xLocalBegin2 += width;
        }
        return false;
    }

    private int getImageTopLeftX(int x1) {
        int retX = x1 - this.x;
        return retX += this.frameCoordsX[this.frameSequence[this.sequenceIndex]];
    }

    private int getImageTopLeftY(int y1) {
        int retY = y1 - this.y;
        return retY += this.frameCoordsY[this.frameSequence[this.sequenceIndex]];
    }
}

