/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.color_game;

import com.siemens.mp.color_game.Layer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledLayer
extends Layer {
    private int cellHeight;
    private int cellWidth;
    private int rows;
    private int columns;
    private int[][] cellMatrix;
    Image sourceImage;
    private int numberOfTiles;
    int[] tileSetX;
    int[] tileSetY;
    private int[] anim_to_static;
    private int numOfAnimTiles;

    public TiledLayer(int columns, int rows, Image image, int tileWidth, int tileHeight) {
        super(columns < 1 || tileWidth < 1 ? -1 : columns * tileWidth, rows < 1 || tileHeight < 1 ? -1 : rows * tileHeight);
        if (image.getWidth() % tileWidth != 0 || image.getHeight() % tileHeight != 0) {
            throw new IllegalArgumentException();
        }
        this.columns = columns;
        this.rows = rows;
        this.cellMatrix = new int[rows][columns];
        int noOfFrames = image.getWidth() / tileWidth * (image.getHeight() / tileHeight);
        this.createStaticSet(image, noOfFrames + 1, tileWidth, tileHeight, true);
    }

    public int createAnimatedTile(int staticTileIndex) {
        if (staticTileIndex < 0 || staticTileIndex >= this.numberOfTiles) {
            throw new IndexOutOfBoundsException();
        }
        if (this.anim_to_static == null) {
            this.anim_to_static = new int[4];
            this.numOfAnimTiles = 1;
        } else if (this.numOfAnimTiles == this.anim_to_static.length) {
            int[] new_anim_tbl = new int[this.anim_to_static.length * 2];
            System.arraycopy(this.anim_to_static, 0, new_anim_tbl, 0, this.anim_to_static.length);
            this.anim_to_static = new_anim_tbl;
        }
        this.anim_to_static[this.numOfAnimTiles] = staticTileIndex;
        ++this.numOfAnimTiles;
        return -(this.numOfAnimTiles - 1);
    }

    public void setAnimatedTile(int animatedTileIndex, int staticTileIndex) {
        if (staticTileIndex < 0 || staticTileIndex >= this.numberOfTiles) {
            throw new IndexOutOfBoundsException();
        }
        animatedTileIndex = -animatedTileIndex;
        if (this.anim_to_static == null || animatedTileIndex <= 0 || animatedTileIndex >= this.numOfAnimTiles) {
            throw new IndexOutOfBoundsException();
        }
        this.anim_to_static[animatedTileIndex] = staticTileIndex;
    }

    public int getAnimatedTile(int animatedTileIndex) {
        animatedTileIndex = -animatedTileIndex;
        if (this.anim_to_static == null || animatedTileIndex <= 0 || animatedTileIndex >= this.numOfAnimTiles) {
            throw new IndexOutOfBoundsException();
        }
        return this.anim_to_static[animatedTileIndex];
    }

    public void setCell(int col, int row, int tileIndex) {
        if (col < 0 || col >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        if (tileIndex > 0 ? tileIndex >= this.numberOfTiles : tileIndex < 0 && (this.anim_to_static == null || -tileIndex >= this.numOfAnimTiles)) {
            throw new IndexOutOfBoundsException();
        }
        this.cellMatrix[row][col] = tileIndex;
    }

    public int getCell(int col, int row) {
        if (col < 0 || col >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        return this.cellMatrix[row][col];
    }

    public void fillCells(int col, int row, int numCols, int numRows, int tileIndex) {
        if (numCols < 0 || numRows < 0) {
            throw new IllegalArgumentException();
        }
        if (col < 0 || col >= this.columns || row < 0 || row >= this.rows || col + numCols > this.columns || row + numRows > this.rows) {
            throw new IndexOutOfBoundsException();
        }
        if (tileIndex > 0 ? tileIndex >= this.numberOfTiles : tileIndex < 0 && (this.anim_to_static == null || -tileIndex >= this.numOfAnimTiles)) {
            throw new IndexOutOfBoundsException();
        }
        for (int rowCount = row; rowCount < row + numRows; ++rowCount) {
            for (int columnCount = col; columnCount < col + numCols; ++columnCount) {
                this.cellMatrix[rowCount][columnCount] = tileIndex;
            }
        }
    }

    public final int getCellWidth() {
        return this.cellWidth;
    }

    public final int getCellHeight() {
        return this.cellHeight;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final int getRows() {
        return this.rows;
    }

    public void setStaticTileSet(Image image, int tileWidth, int tileHeight) {
        if (tileWidth < 1 || tileHeight < 1 || image.getWidth() % tileWidth != 0 || image.getHeight() % tileHeight != 0) {
            throw new IllegalArgumentException();
        }
        this.setWidth(this.columns * tileWidth);
        this.setHeight(this.rows * tileHeight);
        int noOfFrames = image.getWidth() / tileWidth * (image.getHeight() / tileHeight);
        if (noOfFrames >= this.numberOfTiles - 1) {
            this.createStaticSet(image, noOfFrames + 1, tileWidth, tileHeight, true);
        } else {
            this.createStaticSet(image, noOfFrames + 1, tileWidth, tileHeight, false);
        }
    }

    @Override
    public final void paint(Graphics g) {
        if (g == null) {
            throw new NullPointerException();
        }
        if (this.visible) {
            int endClipY;
            int endY;
            int endClipX;
            int endX;
            int startColumn = 0;
            int endColumn = this.columns;
            int startRow = 0;
            int endRow = this.rows;
            int number = (g.getClipX() - this.x) / this.cellWidth;
            if (number > 0) {
                startColumn = number;
            }
            if ((number = ((endX = this.x + this.columns * this.cellWidth) - (endClipX = g.getClipX() + g.getClipWidth())) / this.cellWidth) > 0) {
                endColumn -= number;
            }
            if ((number = (g.getClipY() - this.y) / this.cellHeight) > 0) {
                startRow = number;
            }
            if ((number = ((endY = this.y + this.rows * this.cellHeight) - (endClipY = g.getClipY() + g.getClipHeight())) / this.cellHeight) > 0) {
                endRow -= number;
            }
            int tileIndex = 0;
            int ty = this.y + startRow * this.cellHeight;
            int row = startRow;
            while (row < endRow) {
                int tx = this.x + startColumn * this.cellWidth;
                int column = startColumn;
                while (column < endColumn) {
                    tileIndex = this.cellMatrix[row][column];
                    if (tileIndex != 0) {
                        if (tileIndex < 0) {
                            tileIndex = this.getAnimatedTile(tileIndex);
                        }
                        g.drawRegion(this.sourceImage, this.tileSetX[tileIndex], this.tileSetY[tileIndex], this.cellWidth, this.cellHeight, 0, tx, ty, 20);
                    }
                    ++column;
                    tx += this.cellWidth;
                }
                ++row;
                ty += this.cellHeight;
            }
        }
    }

    private void createStaticSet(Image image, int noOfFrames, int tileWidth, int tileHeight, boolean maintainIndices) {
        this.cellWidth = tileWidth;
        this.cellHeight = tileHeight;
        int imageW = image.getWidth();
        int imageH = image.getHeight();
        this.sourceImage = image;
        this.numberOfTiles = noOfFrames;
        this.tileSetX = new int[this.numberOfTiles];
        this.tileSetY = new int[this.numberOfTiles];
        if (!maintainIndices) {
            this.rows = 0;
            while (this.rows < this.cellMatrix.length) {
                int totalCols = this.cellMatrix[this.rows].length;
                this.columns = 0;
                while (this.columns < totalCols) {
                    this.cellMatrix[this.rows][this.columns] = 0;
                    ++this.columns;
                }
                ++this.rows;
            }
            this.anim_to_static = null;
        }
        int currentTile = 1;
        for (int locY = 0; locY < imageH; locY += tileHeight) {
            for (int locX = 0; locX < imageW; locX += tileWidth) {
                this.tileSetX[currentTile] = locX;
                this.tileSetY[currentTile] = locY;
                ++currentTile;
            }
        }
    }
}

