/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.game;

import com.siemens.mp.misc.NativeMem;
import emulator.Emulator;
import emulator.graphics2D.awt.ImageAWT;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ExtendedImage
extends NativeMem {
    private final boolean hasAlpha;
    private Image image;

    public ExtendedImage(Image image) {
        if (image == null || image.getWidth() % 8 != 0) {
            throw new IllegalArgumentException("ExtendedImage: width is not divisible by 8");
        }
        this.image = image;
        this.hasAlpha = image.getImpl().isTransparent();
    }

    public void blitToScreen(int x, int y) {
        Displayable current = Display.getDisplay(null).getCurrent();
        if (current instanceof Canvas) {
            Graphics g = new Graphics(Emulator.getEmulator().getScreen().getBackBufferImage(), Emulator.getEmulator().getScreen().getXRayScreenImage());
            g.drawImage(this.image, x, y, 0);
            Emulator.getEventQueue().gameGraphicsFlush();
        }
    }

    public void clear(byte color) {
        this.image.getImpl().fill(color == 0 ? -1 : -16777216);
    }

    public Image getImage() {
        return this.image;
    }

    public int getPixel(int x, int y) {
        int pixel = this.image.getImpl().getRGB(x, y);
        if (this.hasAlpha) {
            if ((pixel & 0xFF000000) != -16777216) {
                return 0;
            }
            return (pixel & 0xFFFFFF) == 0xFFFFFF ? 1 : 2;
        }
        return (pixel & 0xFFFFFF) == 0xFFFFFF ? 0 : 1;
    }

    public void getPixelBytes(byte[] pixels, int x, int y, int width, int height) {
        int[] colors = new int[width * height];
        this.image.getRGB(colors, 0, width, x, y, width, height);
        if (this.hasAlpha) {
            int dataLen = colors.length / 4;
            int k2 = 0;
            for (int i2 = 0; i2 < dataLen; ++i2) {
                int data = 0;
                for (int j = 0; j < 4; ++j) {
                    int color;
                    data <<= 2;
                    if (((color = colors[k2++]) & 0xFF000000) != -16777216) continue;
                    if ((color & 0xFFFFFF) == 0xFFFFFF) {
                        data |= 1;
                        continue;
                    }
                    data |= 2;
                }
                pixels[i2] = (byte)data;
            }
        } else {
            int dataLen = colors.length / 8;
            int k3 = 0;
            for (int i3 = 0; i3 < dataLen; ++i3) {
                int data = 0;
                for (int j = 0; j < 8; ++j) {
                    data <<= 1;
                    if ((colors[k3++] & 0xFFFFFF) == 0xFFFFFF) continue;
                    data |= 1;
                }
                pixels[i3] = (byte)data;
            }
        }
    }

    public void setPixel(int x, int y, byte color) {
        if (!this.hasAlpha) {
            this.image.getImpl().setRGB(x, y, color == 1 ? 0 : -1);
            return;
        }
        if (color == 0) {
            this.image.getImpl().setRGB(x, y, 0);
        } else {
            this.image.getImpl().setRGB(x, y, color == 1 ? -1 : 0);
        }
    }

    public void setPixels(byte[] pixels, int x, int y, int width, int height) {
        int imgWidth = this.image.getWidth();
        int imgHeight = this.image.getHeight();
        int right = x + width;
        int bottom = y + height;
        if (x >= imgWidth || right <= 0 || y >= imgHeight || bottom <= 0) {
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (right > imgWidth) {
            right = imgWidth;
        }
        if (bottom > imgHeight) {
            bottom = imgHeight;
        }
        width = right - x;
        height = bottom - y;
        int[] colors = new int[width * height];
        if (this.hasAlpha) {
            int dataLen = Math.min(pixels.length, colors.length / 4);
            int k2 = 0;
            for (int i2 = 0; i2 < dataLen; ++i2) {
                byte data = pixels[i2];
                for (int j = 3; j >= 0; --j) {
                    int color = data >> j & 3;
                    if (color == 0) {
                        colors[k2++] = 0;
                        continue;
                    }
                    colors[k2++] = color == 1 ? -1 : 0;
                }
            }
        } else {
            int dataLen = Math.min(pixels.length, colors.length / 8);
            int k3 = 0;
            for (int i3 = 0; i3 < dataLen; ++i3) {
                byte data = pixels[i3];
                for (int j = 7; j >= 0; --j) {
                    int color = data >> j & 1;
                    colors[k3++] = color == 1 ? 0 : -1;
                }
            }
        }
        ((ImageAWT)this.image.getImpl()).getBufferedImage().setRGB(x, y, width, height, colors, 0, width);
    }
}

