/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.game;

import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.GraphicObject;
import com.siemens.mp.misc.NativeMem;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicObjectManager
extends NativeMem {
    private Vector<GraphicObject> v = new Vector();

    public void addObject(GraphicObject gobject) {
        this.v.addElement(gobject);
    }

    public static byte[] createTextureBits(int width, int height, byte[] texture) {
        int widthBytes = width >> 3;
        byte[] pixels = new byte[widthBytes * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; x += 8) {
                int t = 0;
                for (int b2 = 0; b2 < 8; ++b2) {
                    t <<= 1;
                    t |= texture[x + b2 + y * width];
                }
                pixels[(x >> 3) + y * widthBytes] = (byte)t;
            }
        }
        return pixels;
    }

    public void deleteObject(GraphicObject gobject) {
        this.v.removeElement(gobject);
    }

    public void deleteObject(int position) {
        this.v.removeElementAt(position);
    }

    public GraphicObject getObjectAt(int index) {
        return this.v.elementAt(index);
    }

    public int getObjectPosition(GraphicObject gobject) {
        return this.v.indexOf(gobject);
    }

    public void insertObject(GraphicObject gobject, int position) {
        this.v.insertElementAt(gobject, position);
    }

    public void paint(ExtendedImage eimage, int x, int y) {
        this.paint(eimage.getImage(), x, y);
    }

    public void paint(Image image, int x, int y) {
        Graphics g = image.getGraphics();
        for (GraphicObject go : this.v) {
            if (!go.getVisible()) continue;
            go.paint(g, x, y);
        }
    }
}

