/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.game;

import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.GraphicObject;
import java.awt.Rectangle;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite
extends GraphicObject {
    private Image sprite;
    private int frameHeight;
    private Rectangle dstBounds;
    private Rectangle frameBounds;
    private Rectangle collisionBounds;
    private int frame;
    private int posX;
    private int posY;

    public Sprite(byte[] pixels, int pixel_offset, int width, int height, byte[] mask, int mask_offset, int numFrames) {
        if (pixels == null || pixel_offset != 0 || mask_offset != 0 || width * height * numFrames / 8 != pixels.length || mask != null && pixels.length != mask.length || width % 8 != 0) {
            throw new IllegalArgumentException();
        }
        Image image = com.siemens.mp.ui.Image.createImageFromBitmap(pixels, mask, width, height * numFrames);
        this.init(image, null, numFrames);
    }

    public Sprite(ExtendedImage pixels, ExtendedImage mask, int numFrames) {
        if (pixels == null) {
            throw new NullPointerException();
        }
        this.init(pixels.getImage(), mask == null ? null : mask.getImage(), numFrames);
    }

    public Sprite(Image pixels, Image mask, int numFrames) {
        this.init(pixels, mask, numFrames);
    }

    private void init(Image pixels, Image mask, int numFrames) {
        if (pixels == null) {
            throw new NullPointerException();
        }
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        this.sprite = pixels;
        this.frameHeight = height / numFrames;
        this.frameBounds = new Rectangle(0, 0, width, this.frameHeight);
        this.dstBounds = new Rectangle(this.frameBounds);
        this.collisionBounds = new Rectangle(this.dstBounds);
    }

    public int getFrame() {
        return this.frame;
    }

    public int getXPosition() {
        return this.posX;
    }

    public int getYPosition() {
        return this.posY;
    }

    public boolean isCollidingWith(Sprite other) {
        return this.collisionBounds.intersects(other.collisionBounds);
    }

    public boolean isCollidingWithPos(int xpos, int ypos) {
        return this.collisionBounds.contains(xpos, ypos);
    }

    public void setCollisionRectangle(int x, int y, int width, int height) {
        int dx = this.posX;
        int dy = this.posY;
        this.collisionBounds.setBounds(dx + x, dy + y, width, height);
    }

    public void setFrame(int frameNumber) {
        this.frame = frameNumber;
        this.frameBounds.x = 0;
        this.frameBounds.y = this.frameHeight * frameNumber;
    }

    public void setPosition(int x, int y) {
        this.collisionBounds.x += x - this.posX;
        this.collisionBounds.y += y - this.posY;
        this.posX = x;
        this.posY = y;
    }

    @Override
    protected void paint(Graphics g, int x, int y) {
        this.dstBounds.x = x + this.posX;
        this.dstBounds.y = y + this.posY;
        g.drawRegion(this.sprite, this.frameBounds.x, this.frameBounds.y, this.frameBounds.width, this.frameBounds.height, 0, this.dstBounds.x, this.dstBounds.y, 0);
    }
}

