/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.game;

import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.GraphicObject;
import java.awt.Rectangle;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledBackground
extends GraphicObject {
    private static final String TAG = TiledBackground.class.getName();
    private Image pixels;
    private byte[][] map;
    private int widthInTiles;
    private int heightInTiles;
    private int posX;
    private int posY;
    private Rectangle frame = new Rectangle(0, 0, 8, 8);
    private Rectangle dst = new Rectangle(0, 0, 8, 8);

    public TiledBackground(byte[] tilePixels, byte[] tileMask, byte[] map, int widthInTiles, int heightInTiles) {
        this(com.siemens.mp.ui.Image.createImageFromBitmap(tilePixels, tileMask, 8, tilePixels.length), null, map, widthInTiles, heightInTiles);
    }

    public TiledBackground(ExtendedImage tilePixels, ExtendedImage tileMask, byte[] map, int widthInTiles, int heightInTiles) {
        this(tilePixels.getImage(), tileMask == null ? null : tileMask.getImage(), map, widthInTiles, heightInTiles);
    }

    public TiledBackground(Image tilePixels, Image tileMask, byte[] map, int widthInTiles, int heightInTiles) {
        this.map = new byte[heightInTiles][widthInTiles];
        this.heightInTiles = heightInTiles;
        this.widthInTiles = widthInTiles;
        int idx = 0;
        for (int i2 = 0; i2 < heightInTiles; ++i2) {
            byte[] row = this.map[i2];
            for (int j = 0; j < widthInTiles; ++j) {
                row[j] = map[idx++];
            }
        }
        this.pixels = tilePixels;
    }

    public void setPositionInMap(int x, int y) {
        this.posX = x;
        this.posY = y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paint(Graphics g, int x, int y) {
        int ox = g.getClipX();
        int oy = g.getClipY();
        int ow = g.getClipWidth();
        int oh = g.getClipHeight();
        Rectangle clip = new Rectangle(ox, oy, ow, oh);
        clip.x = Math.max(clip.x, x);
        clip.y = Math.max(clip.y, y);
        g.clipRect(clip.x, clip.y, clip.width, clip.height);
        int left = x - this.posX % 8;
        int top = y - this.posY % 8;
        this.dst.x = left;
        this.dst.y = top;
        try {
            int ty;
            int tyLen = clip.height / 8 + 1 + ty;
            for (ty = this.posY / 8; ty < tyLen; ++ty) {
                int tx;
                byte[] row = this.map[ty % this.heightInTiles];
                int txLen = clip.width / 8 + 1 + tx;
                for (tx = this.posX / 8; tx < txLen; ++tx) {
                    int tile = row[tx % this.widthInTiles] & 0xFF;
                    switch (tile) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            g.setColor(-1);
                            g.fillRect(this.dst.x, this.dst.y, this.dst.width, this.dst.height);
                            break;
                        }
                        case 2: {
                            g.setColor(0);
                            g.fillRect(this.dst.x, this.dst.y, this.dst.width, this.dst.height);
                            break;
                        }
                        default: {
                            this.frame.x = 0;
                            this.frame.y = (tile - 3) * 8;
                            g.drawRegion(this.pixels, this.frame.x, this.frame.y, this.dst.width, this.dst.height, 0, this.dst.x, this.dst.y, 0);
                        }
                    }
                    this.dst.x += 8;
                }
                this.dst.x = left;
                this.dst.y += 8;
                this.dst.width = 8;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            g.setClip(ox, oy, ow, oh);
        }
    }
}

