/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.io;

import emulator.Emulator;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class File {
    public static final int INSIDE_STORAGE_PATH = 1;
    public static final int OUTSIDE_STORAGE_PATH = 0;
    public static final String STORAGE_DRIVE = "a:";
    private static final Map<Integer, RandomAccessFile> OPENED_FILES = new HashMap<Integer, RandomAccessFile>();
    private static int lastDescriptor;

    public static String buildPath(String fileName) {
        return fileName;
    }

    public static int checkFileName(String fileName) {
        return fileName.indexOf(58) == -1 ? 1 : 0;
    }

    public int close(int fileDescriptor) throws IOException {
        RandomAccessFile file = OPENED_FILES.get(fileDescriptor);
        if (file != null) {
            OPENED_FILES.remove(fileDescriptor);
            file.close();
            return fileDescriptor;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(String sourcePath, String destPath) throws IOException {
        java.io.File source = File.getFile(sourcePath);
        java.io.File dest = File.getFile(destPath);
        try (FileInputStream fis = new FileInputStream(source);
             FileChannel sourceChannel = fis.getChannel();
             FileOutputStream fos = new FileOutputStream(dest);
             FileChannel destChannel = fos.getChannel();){
            destChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
        }
        return 1;
    }

    public static int debugWrite(String fileName, String infoString) throws IOException {
        try (FileWriter writer = new FileWriter(File.getFile(fileName), true);){
            writer.write(infoString);
        }
        return 1;
    }

    public static int delete(String fileName) {
        return File.getFile(fileName).delete() ? 1 : -1;
    }

    public static int exists(String fileName) throws IOException {
        return File.getFile(fileName).exists() ? 1 : -1;
    }

    public static boolean getIsHidden(String fileName) throws IOException {
        return File.getFile(fileName).isHidden();
    }

    public static long getLastModified(String fileName) throws IOException {
        return File.getFile(fileName).lastModified();
    }

    public static boolean isDirectory(String fileName) throws IOException {
        return File.getFile(fileName).isDirectory();
    }

    public int length(int fileDescriptor) throws IOException {
        RandomAccessFile file = OPENED_FILES.get(fileDescriptor);
        if (file == null) {
            return -1;
        }
        return (int)file.length();
    }

    public static String[] list(String pathName) throws IOException {
        return File.list(pathName, false);
    }

    public static String[] list(String pathName, boolean includeHidden) throws IOException {
        FilenameFilter filter = includeHidden ? null : (dir, name) -> name.charAt(0) != '.';
        Object[] files = File.getFile(pathName).list(filter);
        if (files == null) {
            return new String[0];
        }
        Arrays.sort(files);
        return files;
    }

    public int open(String fileName) throws IOException {
        java.io.File file = File.getFile(fileName);
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        int fd = ++lastDescriptor;
        OPENED_FILES.put(fd, raf);
        return fd;
    }

    public int read(int fileDescriptor, byte[] buf, int offset, int numBytes) throws IOException {
        RandomAccessFile file = OPENED_FILES.get(fileDescriptor);
        if (file == null) {
            return -1;
        }
        return file.read(buf, offset, numBytes);
    }

    public static int rename(String source, String dest) {
        return File.getFile(source).renameTo(File.getFile(dest)) ? 1 : -1;
    }

    public int seek(int fileDescriptor, int seekpos) throws IOException {
        RandomAccessFile file = OPENED_FILES.get(fileDescriptor);
        if (file == null) {
            return -1;
        }
        file.seek(seekpos);
        return (int)file.getFilePointer();
    }

    public static int spaceAvailable() throws IOException {
        return (int)new java.io.File(Emulator.getUserPath()).getFreeSpace();
    }

    public static void truncate(int fileDescriptor, int size) throws IOException {
        RandomAccessFile file = OPENED_FILES.get(fileDescriptor);
        if (file == null) {
            return;
        }
        file.setLength(size);
    }

    public int write(int fileDescriptor, byte[] buf, int offset, int numBytes) throws IOException {
        RandomAccessFile file = OPENED_FILES.get(fileDescriptor);
        if (file == null) {
            return -1;
        }
        file.write(buf, offset, numBytes);
        return numBytes;
    }

    private static java.io.File getFile(String fileName) {
        String r = Emulator.getUserPath() + "/file/root/";
        try {
            new java.io.File(r).mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int colon = fileName.indexOf(58);
        if (colon == -1) {
            return new java.io.File(r, fileName);
        }
        fileName = fileName.substring(colon + 2);
        return new java.io.File(r, fileName);
    }
}

