/*
 * Decompiled with CFR 0.152.
 */
package com.vodafone.v10.graphics.j3d;

import com.mascotcapsule.micro3d.v3.Graphics3D;
import com.vodafone.v10.graphics.j3d.AffineTrans;
import com.vodafone.v10.graphics.j3d.Effect3D;
import com.vodafone.v10.graphics.j3d.Figure;
import com.vodafone.v10.graphics.j3d.FigureLayout;
import com.vodafone.v10.graphics.j3d.Light;
import com.vodafone.v10.graphics.j3d.Texture;
import com.vodafone.v10.graphics.j3d.Vector3D;
import java.util.WeakHashMap;
import javax.microedition.lcdui.Graphics;

public class RenderProxy {
    private static final WeakHashMap<Graphics, Graphics3D> renders = new WeakHashMap();

    public static void drawFigure(Graphics g, Figure figure, int x, int y, FigureLayout layout, Effect3D effect) {
        if (figure == null || layout == null || effect == null) {
            throw new NullPointerException();
        }
        Graphics3D render = RenderProxy.getRender(g);
        render.drawFigure(figure.impl, x, y, RenderProxy.getMascotLayout(layout), RenderProxy.getMascotEffect(effect));
    }

    private static com.mascotcapsule.micro3d.v3.Effect3D getMascotEffect(Effect3D effect) {
        if (effect == null) {
            return null;
        }
        com.mascotcapsule.micro3d.v3.Effect3D r = new com.mascotcapsule.micro3d.v3.Effect3D();
        r.setShading(effect.shading);
        r.setLight(RenderProxy.getMascotLight(effect.light));
        if (effect.texture != null) {
            r.setSphereTexture(effect.texture.impl);
        }
        r.setToonParams(effect.toonThreshold, effect.toonHigh, effect.toonLow);
        r.setTransparency(effect.isTransparency);
        return r;
    }

    private static com.mascotcapsule.micro3d.v3.FigureLayout getMascotLayout(FigureLayout layout) {
        if (layout == null) {
            return null;
        }
        com.mascotcapsule.micro3d.v3.FigureLayout r = new com.mascotcapsule.micro3d.v3.FigureLayout(RenderProxy.getMascotAffine(layout.getAffineTrans()), layout.scaleX, layout.scaleY, layout.centerY, layout.centerY);
        return r;
    }

    private static com.mascotcapsule.micro3d.v3.AffineTrans getMascotAffine(AffineTrans a2) {
        if (a2 == null) {
            return null;
        }
        int[] out = new int[12];
        int offset = 0;
        out[offset++] = a2.m00;
        out[offset++] = a2.m01;
        out[offset++] = a2.m02;
        out[offset++] = a2.m03;
        out[offset++] = a2.m10;
        out[offset++] = a2.m11;
        out[offset++] = a2.m12;
        out[offset++] = a2.m13;
        out[offset++] = a2.m20;
        out[offset++] = a2.m21;
        out[offset++] = a2.m22;
        out[offset] = a2.m23;
        return new com.mascotcapsule.micro3d.v3.AffineTrans(out);
    }

    private static com.mascotcapsule.micro3d.v3.Light getMascotLight(Light light) {
        if (light == null) {
            return null;
        }
        return new com.mascotcapsule.micro3d.v3.Light(RenderProxy.getMascotVector(light.getDirection()), light.getDirIntensity(), light.getAmbIntensity());
    }

    private static com.mascotcapsule.micro3d.v3.Vector3D getMascotVector(Vector3D vector2) {
        if (vector2 == null) {
            return null;
        }
        return new com.mascotcapsule.micro3d.v3.Vector3D(vector2.x, vector2.y, vector2.z);
    }

    private static com.mascotcapsule.micro3d.v3.Texture[] getMascotTextures(Texture[] textures) {
        if (textures == null) {
            return null;
        }
        com.mascotcapsule.micro3d.v3.Texture[] r = new com.mascotcapsule.micro3d.v3.Texture[textures.length];
        for (int i2 = 0; i2 < r.length; ++i2) {
            r[i2] = textures[i2].impl;
        }
        return r;
    }

    public static Graphics3D getRender(Graphics g) {
        Graphics3D render = renders.get(g);
        if (render == null) {
            render = new Graphics3D();
            render.bind(g, false);
            renders.put(g, render);
        }
        return render;
    }
}

