/*
 * Decompiled with CFR 0.152.
 */
package com.vodafone.v10.graphics.sprite;

import emulator.Emulator;
import emulator.graphics2D.IImage;
import emulator.ui.IScreen;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class SpriteCanvas
extends Canvas {
    public static Image _virtualImage;
    public static Graphics _virtualGraphics;
    public Image _frameImage;
    protected Graphics frameGraphics;
    private int[] palette;
    private byte[] patternData;
    private int[] pixels;
    private Graphics screenGraphics;
    public boolean _skipCopy;
    protected int scrollX;
    protected int scrollY;

    public SpriteCanvas(int numPalettes, int numPatterns) {
        this.palette = new int[numPalettes];
        this.patternData = new byte[numPatterns * 64];
        this.pixels = new int[64];
        if (_virtualImage == null) {
            _virtualImage = Image.createImage(SpriteCanvas.getVirtualWidth(), SpriteCanvas.getVirtualHeight(), 0);
            _virtualGraphics = _virtualImage.getGraphics();
        }
    }

    public void createFrameBuffer(int fw, int fh) {
        if (fw == 0 || fh == 0) {
            fw = SpriteCanvas.getVirtualWidth();
            fh = SpriteCanvas.getVirtualHeight();
        }
        this._frameImage = Image.createImage(fw, fh, 0);
        this.frameGraphics = this._frameImage.getGraphics();
    }

    public void disposeFrameBuffer() {
        this._frameImage = null;
        this.frameGraphics = null;
    }

    public void copyArea(int sx, int sy, int fw, int fh, int tx, int ty) {
        _virtualImage.getImpl().copyImage(this.frameGraphics.getImpl(), sx, sy, fw, fh, tx, ty);
        this._skipCopy = true;
    }

    public void copyFullScreen(int tx, int ty) {
        this.copyArea(0, 0, this.getWidth(), this.getHeight(), tx, ty);
    }

    public void drawFrameBuffer(int tx, int ty) {
        IScreen screen = Emulator.getEmulator().getScreen();
        IImage screenImage = screen.getScreenImg();
        if (this.screenGraphics == null) {
            this.screenGraphics = new Graphics(screenImage, null);
        } else {
            this.screenGraphics._reset(screenImage, null);
        }
        this.screenGraphics.drawImage(this._frameImage, tx, ty, 0);
        this.frameGraphics.setColor(0);
        this.frameGraphics.getImage().setAlpha(0, 0, this._frameImage.getWidth(), this._frameImage.getHeight(), 0);
        screen.repaint();
    }

    public void setPalette(int index, int palette) {
        this.palette[index] = palette | 0xFF000000;
    }

    public void setPattern(int index, byte[] data) {
        System.arraycopy(data, 0, this.patternData, index * 64, data.length);
    }

    public static short createCharacterCommand(int offset, boolean transparent, int rotation, boolean isUpsideDown, boolean isRightsideLeft, int patternNo) {
        int i2 = (offset & 7) << 13;
        if (transparent) {
            i2 |= 0x1000;
        }
        i2 |= (rotation & 3) << 10;
        if (isUpsideDown) {
            i2 |= 0x200;
        }
        if (isRightsideLeft) {
            i2 |= 0x100;
        }
        return (short)(i2 |= patternNo & 0xFF);
    }

    private synchronized void drawChar(short command, boolean bg) {
        int n = command & 0xFFFF;
        int offset = n >> 13 & 7;
        int rotation = n >> 10 & 3;
        boolean transparent = (n & 0x1000) != 0;
        boolean isUpsideDown = (n & 0x200) != 0;
        boolean isRightsideLeft = (n & 0x100) != 0;
        int patternNo = n & 0xFF;
        for (int x1 = 0; x1 < 8; ++x1) {
            for (int y1 = 0; y1 < 8; ++y1) {
                int i2 = (isUpsideDown ? 7 - y1 : y1) * 8 + (isRightsideLeft ? 7 - x1 : x1);
                int colorId = this.patternData[patternNo * 64 + i2] & 0xFF;
                i2 = rotation == 1 ? 7 - y1 + x1 * 8 : (rotation == 2 ? (7 - y1) * 8 + (7 - x1) : (rotation == 3 ? y1 + (7 - x1) * 8 : y1 * 8 + x1));
                this.pixels[i2] = transparent && colorId == 0 ? (bg ? -16777216 : 0) : this.palette[colorId + offset * 32 & 0xFF];
            }
        }
    }

    public void drawSpriteChar(short command, short x, short y) {
        this.drawChar(command, false);
        this.frameGraphics.drawRGB(this.pixels, 0, 8, x, y, 8, 8, true);
    }

    public void drawBackground(short command, short x, short y) {
        this.drawChar(command, true);
        _virtualGraphics.drawRGB(this.pixels, 0, 8, x * 8, y * 8, 8, 8, true);
    }

    public static int getVirtualWidth() {
        return Emulator.getEmulator().getScreen().getWidth();
    }

    public static int getVirtualHeight() {
        return Emulator.getEmulator().getScreen().getHeight();
    }
}

