/*
 * Decompiled with CFR 0.152.
 */
package com.vodafone.v10.sound;

import com.vodafone.v10.sound.Sound;
import com.vodafone.v10.sound.SoundTrackListener;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class SoundTrack {
    public static final int NO_DATA = 0;
    public static final int PAUSED = 3;
    public static final int PLAYING = 2;
    public static final int READY = 1;
    private static final int MAX_VOLUME = 127;
    private int id;
    private Sound snd;
    private Player player;
    private int state;
    private int loopCount;
    private int volume = 127;
    private SoundTrackListener listener;
    private SoundTrack syncMaster;

    public SoundTrack() {
    }

    SoundTrack(int id) {
        this.id = id;
    }

    public Sound getSound() {
        return this.snd;
    }

    public void setSound(Sound p) {
        this.snd = p;
        this.player = p.getPlayer();
    }

    public int getState() {
        return this.state;
    }

    public void setVolume(int value) {
        this.volume = value;
        if (this.volume < 0) {
            this.volume = 0;
        }
        if (this.volume > 127) {
            this.volume = 127;
        }
    }

    public void stop() {
        try {
            this.player.stop();
            this.state = 1;
        }
        catch (MediaException e2) {
            e2.printStackTrace();
        }
    }

    public void play() {
    }

    public void play(int loop) {
        try {
            if (this.state != 2) {
                this.loopCount = loop;
                if (loop == 0) {
                    loop = -1;
                }
                this.player.setLoopCount(loop);
                this.player.start();
                this.state = 2;
            }
        }
        catch (MediaException e2) {
            e2.printStackTrace();
        }
    }

    public void removeSound() {
        this.snd = null;
    }

    public void setEventListener(SoundTrackListener l) {
        this.listener = l;
    }

    private void postEvent(int event) {
        if (this.listener != null) {
            this.listener.eventOccurred(event);
        }
    }

    public SoundTrack getSyncMaster() {
        return this.syncMaster;
    }

    public void setSubjectTo(SoundTrack master) {
        this.syncMaster = master;
    }

    public void setPanpot(int value) {
    }

    public int getVolume() {
        return this.volume;
    }

    public int getPanpot() {
        return 64;
    }

    public int getID() {
        return this.id;
    }

    public void resume() {
        this.play(1);
    }
}

