/*
 * Decompiled with CFR 0.152.
 */
package emulator;

import emulator.Emulator;
import emulator.EventQueue;
import emulator.KeyMapping;
import emulator.Settings;
import emulator.Utils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Set;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;

public class Controllers {
    private static final ArrayList controllers = new ArrayList();
    private static int count;
    private static boolean loaded;
    private static String[][] binds;
    private static boolean[][] arrowKeysState;
    private static String bind;
    private static float[][] axisState;
    private static final int AXIS_POV = -1;
    private static final int AXIS_X = 0;
    private static final int AXIS_Y = 1;
    private static final int AXIS_Z = 2;
    private static final int AXIS_RZ = 3;
    private static final int AXIS_RX = 4;
    private static final int AXIS_RY = 5;
    private static final int AXIS_POV_X = 6;
    private static final int AXIS_POV_Y = 7;

    private static void init() throws Exception {
        if (loaded) {
            return;
        }
        try {
            Controller[] controllers = Controllers.getDefaultEnvironment().getControllers();
            ArrayList<Controller> list2 = new ArrayList<Controller>();
            for (Controller controller : controllers) {
                String s;
                if (controller.getType().equals(Controller.Type.KEYBOARD) || controller.getType().equals(Controller.Type.MOUSE) || (s = controller.getName()).contains("tablet") || s.contains("STAR") || s.contains("Gaming Keyboard") || s.contains("Gaming Mouse") || s.contains("Microphone")) continue;
                list2.add(controller);
            }
            int size = list2.size();
            for (int j = 0; j < size; ++j) {
                Controllers.addController((Controller)list2.get(j));
            }
            loaded = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Exception("Failed to initialise controllers", t);
        }
    }

    private static void addController(Controller controller) {
        Controller[] controllers = controller.getControllers();
        if (controllers.length == 0) {
            Emulator.getEmulator().getLogStream().println("Found controller: " + controller);
            Controllers.controllers.add(controller);
            ++count;
            return;
        }
        for (Controller value : controllers) {
            Controllers.addController(value);
        }
    }

    public static int getControllersCount() {
        return count;
    }

    public static Controller getController(int n) {
        return (Controller)controllers.get(n);
    }

    private static void initBinds() {
        binds = new String[count][19];
        for (int i2 = 0; i2 < count; ++i2) {
            String name = ((Controller)controllers.get(i2)).getName();
            Controllers.binds[i2][0] = "0";
            Controllers.binds[i2][1] = "1";
            Controllers.binds[i2][2] = "2";
            Controllers.binds[i2][3] = "3";
            Controllers.binds[i2][4] = "4";
            Controllers.binds[i2][5] = "5";
            Controllers.binds[i2][6] = "6";
            Controllers.binds[i2][7] = "7";
            Controllers.binds[i2][8] = "8";
            Controllers.binds[i2][9] = "12";
            Controllers.binds[i2][10] = "13";
            Controllers.binds[i2][11] = "14";
            Controllers.binds[i2][12] = "UP";
            Controllers.binds[i2][13] = "DOWN";
            Controllers.binds[i2][14] = "LEFT";
            Controllers.binds[i2][15] = "RIGHT";
            Controllers.binds[i2][16] = "9";
            Controllers.binds[i2][17] = "10";
            Controllers.binds[i2][18] = "11";
            if (name.toLowerCase().contains("xbox")) {
                Settings.controllerZMap = 5;
                Settings.controllerRZMap = 5;
            }
            if (!Settings.controllerBinds.containsKey(name + ".0")) continue;
            for (int j = 0; j < 19; ++j) {
                String s = Settings.controllerBinds.get(name + "." + j);
                if (s == null) continue;
                Controllers.binds[i2][j] = s;
            }
        }
    }

    public static void bind(int controllerId, int n2, String s) {
        Controllers.binds[controllerId][n2] = s;
        try {
            Settings.controllerBinds.put(((Controller)controllers.get(controllerId)).getName() + "." + n2, s);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static String getBind(int controllerId, int n2) {
        String s = binds[controllerId][n2];
        if (s.startsWith("Axis")) {
            return s;
        }
        if (!(s.isEmpty() || s.equalsIgnoreCase("LEFT") || s.equalsIgnoreCase("RIGHT") || s.equalsIgnoreCase("UP") || s.equalsIgnoreCase("DOWN"))) {
            s = "B_" + s;
        }
        return s;
    }

    private static int map(int n, String s) {
        int n2;
        for (n2 = 0; n2 < 19 && !s.equalsIgnoreCase(binds[n][n2]); ++n2) {
        }
        if (n2 == 19) {
            return 10000;
        }
        return Controllers.method747(KeyMapping.deviceKeycodes[n2]);
    }

    private static int method747(String s) {
        if (s == null || s.isEmpty() || (s = KeyMapping.replaceKey(Integer.parseInt(s))) == null) {
            return 10000;
        }
        return Integer.parseInt(s);
    }

    private static boolean bindChange(String aString1292) {
        bind = aString1292;
        return Emulator.getEmulator().getProperty().updateController();
    }

    public static String method749() {
        return bind;
    }

    public static void refresh(boolean b2) {
        Controllers.reset();
        if (b2) {
            try {
                Controllers.init();
                if (count > 0) {
                    arrowKeysState = new boolean[count][8];
                    axisState = new float[count][8];
                    Controllers.initBinds();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Controllers.reset();
            }
        }
    }

    private static ControllerEnvironment getDefaultEnvironment() throws Exception {
        if (Utils.isJava9()) {
            return ControllerEnvironment.getDefaultEnvironment();
        }
        Constructor<?> constructor = Class.forName("net.java.games.input.DefaultControllerEnvironment").getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        return (ControllerEnvironment)constructor.newInstance(new Object[0]);
    }

    private static void reset() {
        loaded = false;
        controllers.clear();
        count = 0;
        arrowKeysState = null;
        binds = null;
        try {
            Set<Thread> threads = Thread.getAllStackTraces().keySet();
            for (Thread thread : threads) {
                if (!thread.getClass().getName().equals("net.java.games.input.RawInputEventQueue$QueueThread")) continue;
                thread.interrupt();
                try {
                    thread.join();
                }
                catch (InterruptedException e2) {
                    thread.interrupt();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void poll() {
        if (!loaded || count == 0) {
            return;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            Controller controller = Controllers.getController(i2);
            if (!controller.poll()) continue;
            Event event = new Event();
            while (controller.getEventQueue().getNextEvent(event)) {
                Component.Identifier identifier = event.getComponent().getIdentifier();
                String name = identifier.getName();
                float value = event.getValue();
                if (identifier instanceof Component.Identifier.Button) {
                    int key = Controllers.map(i2, name);
                    if (value == 1.0f) {
                        if (Controllers.bindChange(name) || key == 10000) continue;
                        Controllers.dispatchKeyEvent(key, true);
                        continue;
                    }
                    if (key == 10000) continue;
                    Controllers.dispatchKeyEvent(key, false);
                    continue;
                }
                if (identifier.equals(Component.Identifier.Axis.POV)) {
                    Controllers.filter(i2, value, -1);
                    continue;
                }
                if (Math.abs(value) < 0.05f) {
                    value = 0.0f;
                }
                if (name.equalsIgnoreCase("x")) {
                    Controllers.filter(i2, value, 0);
                    continue;
                }
                if (name.equalsIgnoreCase("y")) {
                    Controllers.filter(i2, value, 1);
                    continue;
                }
                if (name.equalsIgnoreCase("z")) {
                    Controllers.filter(i2, value, 2);
                    continue;
                }
                if (name.equalsIgnoreCase("rz")) {
                    Controllers.filter(i2, value, 3);
                    continue;
                }
                if (name.equalsIgnoreCase("rx")) {
                    Controllers.filter(i2, value, 4);
                    continue;
                }
                if (!name.equalsIgnoreCase("ry")) continue;
                Controllers.filter(i2, value, 5);
            }
        }
    }

    private static void filter(int n, float f2, int axis) {
        int mode = 0;
        switch (axis) {
            case -1: {
                Controllers.filter(n, Controllers.povX(f2), 6);
                Controllers.filter(n, Controllers.povY(f2), 7);
                return;
            }
            case 0: {
                mode = Settings.controllerXMap;
                break;
            }
            case 1: {
                mode = Settings.controllerYMap;
                break;
            }
            case 2: {
                mode = Settings.controllerZMap;
                break;
            }
            case 4: {
                mode = Settings.controllerRXMap;
                break;
            }
            case 5: {
                mode = Settings.controllerRYMap;
                break;
            }
            case 3: {
                mode = Settings.controllerRZMap;
                break;
            }
            case 6: {
                mode = Settings.controllerPovXMap;
                break;
            }
            case 7: {
                mode = Settings.controllerPovYMap;
            }
        }
        if (Math.abs(f2) <= Settings.axisFilter && Math.abs(axisState[n][axis]) <= Settings.axisFilter) {
            return;
        }
        switch (mode) {
            case 0: {
                break;
            }
            case 1: {
                Controllers.horizontal(n, f2, true);
                break;
            }
            case 2: {
                Controllers.vertical(n, f2, true);
                break;
            }
            case 3: {
                Controllers.horizontal(n, f2, false);
                break;
            }
            case 4: {
                Controllers.vertical(n, f2, false);
                break;
            }
            case 5: {
                String name = null;
                switch (axis) {
                    case 0: {
                        name = "Axis_X";
                        break;
                    }
                    case 1: {
                        name = "Axis_Y";
                        break;
                    }
                    case 2: {
                        name = "Axis_Z";
                        break;
                    }
                    case 4: {
                        name = "Axis_RX";
                        break;
                    }
                    case 5: {
                        name = "Axis_RY";
                        break;
                    }
                    case 3: {
                        name = "Axis_RZ";
                        break;
                    }
                    case 6: {
                        name = "Axis_POV_X";
                        break;
                    }
                    case 7: {
                        name = "Axis_POV_Y";
                        break;
                    }
                }
                int key = Controllers.map(n, name);
                if (f2 >= Settings.axisThreshold) {
                    if (Controllers.bindChange(name) || key == 10000 || axisState[n][axis] >= Settings.axisThreshold) break;
                    Controllers.dispatchKeyEvent(key, true);
                    break;
                }
                if (axisState[n][axis] < Settings.axisThreshold || key == 10000) break;
                Controllers.dispatchKeyEvent(key, false);
            }
        }
        Controllers.axisState[n][axis] = f2;
    }

    private static void horizontal(int n, float f2, boolean map) {
        if (Settings.controllerInverseHor) {
            f2 = -f2;
        }
        if (map) {
            if (f2 <= -Settings.axisThreshold) {
                if (Controllers.bindChange("LEFT")) {
                    return;
                }
                if (arrowKeysState[n][0]) {
                    return;
                }
                Controllers.dispatchKeyEvent(Controllers.map(n, "LEFT"), true);
                Controllers.arrowKeysState[n][0] = true;
            } else if (f2 >= Settings.axisThreshold) {
                if (Controllers.bindChange("RIGHT")) {
                    return;
                }
                if (arrowKeysState[n][1]) {
                    return;
                }
                Controllers.dispatchKeyEvent(Controllers.map(n, "RIGHT"), true);
                Controllers.arrowKeysState[n][1] = true;
            } else if (arrowKeysState[n][0]) {
                Controllers.dispatchKeyEvent(Controllers.map(n, "LEFT"), false);
                Controllers.arrowKeysState[n][0] = false;
            } else if (arrowKeysState[n][1]) {
                Controllers.dispatchKeyEvent(Controllers.map(n, "RIGHT"), false);
                Controllers.arrowKeysState[n][1] = false;
            }
            return;
        }
        if (f2 <= -Settings.axisThreshold) {
            if (arrowKeysState[n][4]) {
                return;
            }
            Controllers.dispatchKeyEvent(KeyMapping.getArrowKeyFromDevice(2), true);
            Controllers.arrowKeysState[n][4] = true;
        } else if (f2 >= Settings.axisThreshold) {
            if (arrowKeysState[n][5]) {
                return;
            }
            Controllers.dispatchKeyEvent(KeyMapping.getArrowKeyFromDevice(5), true);
            Controllers.arrowKeysState[n][5] = true;
        } else if (arrowKeysState[n][4]) {
            Controllers.dispatchKeyEvent(KeyMapping.getArrowKeyFromDevice(2), false);
            Controllers.arrowKeysState[n][4] = false;
        } else if (arrowKeysState[n][5]) {
            Controllers.dispatchKeyEvent(KeyMapping.getArrowKeyFromDevice(5), false);
            Controllers.arrowKeysState[n][5] = false;
        }
    }

    private static void vertical(int n, float f2, boolean map) {
        if (Settings.controllerInverseVer) {
            f2 = -f2;
        }
        if (map) {
            if (f2 <= -Settings.axisThreshold) {
                if (Controllers.bindChange("UP")) {
                    return;
                }
                if (arrowKeysState[n][2]) {
                    return;
                }
                Controllers.dispatchKeyEvent(Controllers.map(n, "UP"), true);
                Controllers.arrowKeysState[n][2] = true;
            } else if (f2 >= Settings.axisThreshold) {
                if (Controllers.bindChange("DOWN")) {
                    return;
                }
                if (arrowKeysState[n][3]) {
                    return;
                }
                Controllers.dispatchKeyEvent(Controllers.map(n, "DOWN"), true);
                Controllers.arrowKeysState[n][3] = true;
            } else if (arrowKeysState[n][2]) {
                Controllers.dispatchKeyEvent(Controllers.map(n, "UP"), false);
                Controllers.arrowKeysState[n][2] = false;
            } else if (arrowKeysState[n][3]) {
                Controllers.dispatchKeyEvent(Controllers.map(n, "DOWN"), false);
                Controllers.arrowKeysState[n][3] = false;
            }
            return;
        }
        if (f2 <= -Settings.axisThreshold) {
            if (arrowKeysState[n][6]) {
                return;
            }
            Controllers.dispatchKeyEvent(KeyMapping.getArrowKeyFromDevice(1), true);
            Controllers.arrowKeysState[n][6] = true;
        } else if (f2 >= Settings.axisThreshold) {
            if (arrowKeysState[n][7]) {
                return;
            }
            Controllers.dispatchKeyEvent(KeyMapping.getArrowKeyFromDevice(6), true);
            Controllers.arrowKeysState[n][7] = true;
        } else if (arrowKeysState[n][6]) {
            Controllers.dispatchKeyEvent(KeyMapping.getArrowKeyFromDevice(1), false);
            Controllers.arrowKeysState[n][6] = false;
        } else if (arrowKeysState[n][7]) {
            Controllers.dispatchKeyEvent(KeyMapping.getArrowKeyFromDevice(6), false);
            Controllers.arrowKeysState[n][7] = false;
        }
    }

    private static void dispatchKeyEvent(int key, boolean state) {
        EventQueue queue = Emulator.getEventQueue();
        if (queue == null || key == 10000) {
            return;
        }
        if (state) {
            queue.keyPress(key);
        } else {
            queue.keyRelease(key);
        }
    }

    private static float povX(float n) {
        if (n == 0.875f || n == 0.125f || n == 1.0f) {
            return -1.0f;
        }
        if (n == 0.625f || n == 0.375f || n == 0.5f) {
            return 1.0f;
        }
        return 0.0f;
    }

    private static float povY(float n) {
        if (n == 0.875f || n == 0.625f || n == 0.75f) {
            return 1.0f;
        }
        if (n == 0.125f || n == 0.375f || n == 0.25f) {
            return -1.0f;
        }
        return 0.0f;
    }
}

