/*
 * Decompiled with CFR 0.152.
 */
package emulator;

import emulator.DevicePlatform;
import emulator.Emulator;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class Devices {
    public static DevicePlatform curPlatform;
    private static Hashtable aHashtable1074;
    private static ArrayList anArrayList1075;
    private static Properties properties;
    private static final String[] aStringArray1077;
    private static String defaultPreset;

    public static void load(String s) {
        try {
            InputStream resourceAsStream;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            try {
                resourceAsStream = Emulator.class.getResourceAsStream(s);
            }
            catch (Exception ex) {
                resourceAsStream = new FileInputStream(s);
            }
            if (resourceAsStream == null) {
                throw new Exception("device file could not be found: " + s);
            }
            Document parse = documentBuilder.parse(resourceAsStream);
            defaultPreset = ((Element)parse.getElementsByTagName("default").item(0)).getAttribute("value");
            for (int i2 = 0; i2 < aStringArray1077.length; ++i2) {
                NodeList elementsByTagName = parse.getElementsByTagName(aStringArray1077[i2]);
                for (int j = 0; j < elementsByTagName.getLength(); ++j) {
                    DevicePlatform e2 = new DevicePlatform((Element)elementsByTagName.item(j));
                    aHashtable1074.put(e2.name.toLowerCase(), e2);
                    if (i2 <= 0) continue;
                    anArrayList1075.add(e2.name);
                }
            }
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            Emulator.getEmulator().getLogStream().println("Failed to load XML file.");
        }
    }

    public static boolean setPreset(String s) {
        DevicePlatform ane1073 = (DevicePlatform)aHashtable1074.get(s.toLowerCase());
        if (ane1073 != null) {
            curPlatform = ane1073;
            return true;
        }
        Emulator.getEmulator().getLogStream().println("Not found preset: " + s);
        return false;
    }

    public static DevicePlatform getPlatform(String s) {
        return (DevicePlatform)aHashtable1074.get(s.toLowerCase());
    }

    public static String getProperty(String s) {
        return curPlatform.getString(s);
    }

    public static int getPropertyInt(String s) {
        if (curPlatform == null) {
            return 0;
        }
        return curPlatform.getInt(s);
    }

    public static void setProperty(String s, String s2) {
        properties.setProperty(s.toUpperCase(), s2);
    }

    public static void writeProperties() {
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String s = (String)propertyNames.nextElement();
            Devices.curPlatform.properties.setProperty(s, (String)properties.get(s));
        }
    }

    public static String getDefaultPreset() {
        return defaultPreset;
    }

    public static Enumeration method620() {
        return Collections.enumeration(anArrayList1075);
    }

    static {
        aStringArray1077 = new String[]{"layout", "preset"};
        aHashtable1074 = new Hashtable();
        anArrayList1075 = new ArrayList();
        properties = new Properties();
    }
}

