/*
 * Decompiled with CFR 0.152.
 */
package emulator;

import com.nttdocomo.ui.maker.IApplicationMIDlet;
import emulator.Controllers;
import emulator.Devices;
import emulator.EventQueue;
import emulator.IEmulatorPlatform;
import emulator.KeyMapping;
import emulator.KeyRecords;
import emulator.Settings;
import emulator.UILocale;
import emulator.Updater;
import emulator.Utils;
import emulator.custom.CustomClassLoader;
import emulator.custom.CustomMethod;
import emulator.custom.ResourceManager;
import emulator.graphics3D.IGraphics3D;
import emulator.media.EmulatorMIDI;
import emulator.media.MMFPlayer;
import emulator.ui.IEmulatorFrontend;
import emulator.ui.RichPresence;
import emulator.ui.bridge.BridgeFrontend;
import emulator.ui.swt.Property;
import emulator.ui.swt.SWTFrontend;
import emulator.ui.swt.devutils.idea.IdeaUtils;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Screen;
import javax.microedition.media.Manager;
import javax.microedition.midlet.MIDlet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class Emulator
implements Runnable {
    public static boolean debugBuild = true;
    public static String version = "2.20";
    public static String revision = "";
    public static final int numericVersion = 33;
    private static IEmulatorFrontend emulatorimpl;
    private static MIDlet midlet;
    private static Canvas currentCanvas;
    private static Screen currentScreen;
    private static EventQueue eventQueue;
    private static KeyRecords record;
    public static Vector jarLibrarys;
    public static Vector<String> jarClasses;
    public static String midletJar;
    public static String midletClassName;
    public static String classPath;
    public static String jadPath;
    public static String deviceName;
    public static String deviceFile;
    public static String[] commandLineArguments;
    public static CustomClassLoader customClassLoader;
    public static String iconPath;
    public static String httpUserAgent;
    private static final Thread backgroundThread;
    public static IEmulatorPlatform platform;
    public static final boolean isPortable;
    private static Class<?> midletClass;
    private static boolean forked;
    private static boolean updated;
    private static boolean bridge;
    public static boolean doja;

    private Emulator() {
    }

    public static IEmulatorFrontend getEmulator() {
        return emulatorimpl;
    }

    public static KeyRecords getRobot() {
        return record;
    }

    public static Canvas getCanvas() {
        return currentCanvas;
    }

    public static void setCanvas(Canvas canvas) {
        currentCanvas = canvas;
        emulatorimpl.getScreen().setCurrent(canvas);
    }

    public static Screen getScreen() {
        return currentScreen;
    }

    public static void setScreen(Screen screen) {
        currentScreen = screen;
        emulatorimpl.getScreen().setCurrent(screen);
    }

    public static MIDlet getMIDlet() {
        return midlet;
    }

    public static void setMIDlet(MIDlet midlet) {
        Emulator.midlet = midlet;
    }

    public static Display getCurrentDisplay() {
        return Display.getDisplay(midlet);
    }

    public static EventQueue getEventQueue() {
        return eventQueue;
    }

    public static CustomClassLoader getCustomClassLoader() {
        return customClassLoader;
    }

    public static void notifyDestroyed() {
        RichPresence.close();
        MMFPlayer.close();
        emulatorimpl.getProperty().saveProperties();
        if (Settings.autoGenJad) {
            Emulator.generateJad();
            return;
        }
        Emulator.saveTargetDevice();
    }

    public static void openFileExternally(String fileName) {
        try {
            if (Utils.win) {
                Desktop.getDesktop().open(new File(fileName));
                return;
            }
            if (Utils.macos) {
                Runtime.getRuntime().exec("open \"" + fileName + "\"");
                return;
            }
            if (Utils.linux) {
                if (Files.isExecutable(Paths.get("/usr/bin/xdg-open", new String[0]))) {
                    Runtime.getRuntime().exec("/usr/bin/xdg-open \"" + fileName + "\"");
                } else if (Files.isExecutable(Paths.get("/usr/bin/gedit", new String[0]))) {
                    Runtime.getRuntime().exec("/usr/bin/gedit \"" + fileName + "\"");
                } else {
                    Emulator.getEmulator().getScreen().showMessage("Non XDG compliant systems are not supported.");
                }
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        Emulator.getEmulator().getScreen().showMessage("Failed to open file.");
    }

    public static void openUrlExternally(String url) throws ConnectionNotFoundException {
        if (Utils.linux && Files.isExecutable(Paths.get("/usr/bin/xdg-open", new String[0]))) {
            try {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/xdg-open", url});
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (Utils.macos) {
            try {
                Runtime.getRuntime().exec("open \"" + url + "\"");
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Utils.win) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new ConnectionNotFoundException("not supported");
    }

    public static void openUrlExternallySilent(String url) {
        try {
            Emulator.openUrlExternally(url);
        }
        catch (ConnectionNotFoundException e2) {
            Emulator.getEmulator().getScreen().showMessage("Failed to open URL.");
        }
    }

    private static void generateJad() {
        if (midletJar == null) {
            return;
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(midletJar.substring(0, midletJar.length() - 3) + "jad"), "UTF-8");
            Enumeration<Object> keys = emulatorimpl.getAppProperties().keys();
            while (keys.hasMoreElements()) {
                String s = (String)keys.nextElement();
                if (s.equalsIgnoreCase("KEmu-Platform")) continue;
                outputStreamWriter.write(s + ": " + emulatorimpl.getAppProperties().getProperty(s) + "\r\n");
            }
            if (emulatorimpl.getAppProperties().getProperty("MIDlet-Jar-URL") == null) {
                outputStreamWriter.write("MIDlet-Jar-URL: " + new File(midletJar).getName() + "\r\n");
            }
            if (emulatorimpl.getAppProperties().getProperty("MIDlet-Jar-Size") == null) {
                outputStreamWriter.write("MIDlet-Jar-Size: " + new File(midletJar).length() + "\r\n");
            }
            outputStreamWriter.write("KEmu-Platform: " + deviceName + "\r\n");
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveTargetDevice() {
        if (midletJar == null) {
            return;
        }
        if (Settings.writeKemCfg) {
            String propsPath = new File(midletJar).getParentFile().getAbsolutePath() + File.separatorChar + "kemulator.cfg";
            try {
                String key = new File(midletJar).getName();
                key = key.substring(0, key.lastIndexOf("."));
                Properties properties = new Properties();
                if (new File(propsPath).exists()) {
                    try (FileInputStream in = new FileInputStream(propsPath);){
                        properties.load(in);
                    }
                }
                properties.setProperty(key, deviceName);
                try (FileOutputStream out = new FileOutputStream(propsPath);){
                    properties.store(out, "KEmulator platforms");
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return;
        }
        String propsPath = Emulator.getUserPath() + File.separatorChar + "midlets.txt";
        try {
            String key = new File(midletJar).getCanonicalPath();
            Properties properties = new Properties();
            if (new File(propsPath).exists()) {
                try (FileInputStream in = new FileInputStream(propsPath);){
                    properties.load(in);
                }
            }
            StringBuilder s = new StringBuilder("!");
            s.append(deviceName).append(';').append("SCREEN_WIDTH:").append(Devices.getProperty("SCREEN_WIDTH")).append(';').append("SCREEN_HEIGHT:").append(Devices.getProperty("SCREEN_HEIGHT")).append(';').append("KEY_S1:").append(Devices.getProperty("KEY_S1")).append(';').append("KEY_S2:").append(Devices.getProperty("KEY_S2")).append(';').append("KEY_FIRE:").append(Devices.getProperty("KEY_FIRE")).append(';').append("KEY_UP:").append(Devices.getProperty("KEY_UP")).append(';').append("KEY_DOWN:").append(Devices.getProperty("KEY_DOWN")).append(';').append("KEY_LEFT:").append(Devices.getProperty("KEY_LEFT")).append(';').append("KEY_RIGHT:").append(Devices.getProperty("KEY_RIGHT"));
            properties.setProperty(key, s.toString());
            try (FileOutputStream out = new FileOutputStream(propsPath);){
                properties.store(out, "KEmulator MIDlets database");
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadTargetDevice() {
        String device;
        FileInputStream in;
        Properties p;
        String key;
        String property = emulatorimpl.getAppProperties().getProperty("KEmu-Platform");
        if (property != null) {
            Emulator.tryToSetDevice(property);
            return;
        }
        if (midletJar == null) {
            return;
        }
        String propsPath = Emulator.getUserPath() + File.separatorChar + "midlets.txt";
        if (new File(propsPath).exists()) {
            try {
                key = new File(midletJar).getCanonicalPath();
                p = new Properties();
                in = new FileInputStream(propsPath);
                try {
                    p.load(in);
                }
                finally {
                    in.close();
                }
                device = p.getProperty(key, null);
                if (device != null) {
                    Emulator.tryToSetDevice(device);
                    return;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        propsPath = new File(midletJar).getParentFile().getAbsolutePath() + File.separatorChar + "kemulator.cfg";
        key = new File(midletJar).getName();
        key = key.substring(0, key.lastIndexOf("."));
        if (new File(propsPath).exists()) {
            try {
                p = new Properties();
                in = new FileInputStream(propsPath);
                try {
                    p.load(in);
                }
                finally {
                    in.close();
                }
                device = p.getProperty(key, null);
                if (device != null) {
                    Emulator.tryToSetDevice(device);
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
    }

    public static String getTitle(String s) {
        if (Settings.customTitle != null) {
            return Settings.customTitle;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(platform.getTitleName()).append(' ').append(version);
        if (s != null) {
            sb.append(" - ").append(s);
        } else if (midletJar != null && emulatorimpl.getAppProperties() != null) {
            sb.append(" - ").append(emulatorimpl.getAppProperty(doja ? "AppName" : "MIDlet-Name"));
        }
        if (Settings.uei) {
            sb.append(" (UEI)");
        }
        return sb.toString();
    }

    public static String getCmdVersionString() {
        return platform.getName() + " " + version;
    }

    public static String getInfoString() {
        return platform.getInfoString((version.startsWith("2.") ? "v" : "") + version);
    }

    public static String getAboutString() {
        return "KEmulator nnmod\n" + version;
    }

    public static void getLibraries() {
        File file = new File(Emulator.getAbsolutePath() + File.separatorChar + "libs");
        if (file.exists() && file.isDirectory()) {
            File[] listFiles = file.listFiles();
            for (int i2 = 0; i2 < listFiles.length; ++i2) {
                String absolutePath = listFiles[i2].getAbsolutePath();
                if (!absolutePath.endsWith(".jar")) continue;
                jarLibrarys.add(absolutePath);
            }
        }
    }

    public static String getJadPath() {
        File file;
        if (jadPath != null) {
            file = new File(jadPath);
        } else if (midletJar != null) {
            file = new File(midletJar.substring(0, midletJar.length() - 3) + "jad");
        } else {
            return null;
        }
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public static boolean getJarClasses() throws Exception {
        block32: {
            try {
                File file4;
                if (midletClassName == null) {
                    File file;
                    Properties props = null;
                    if (jadPath != null) {
                        file = new File(jadPath);
                    } else {
                        StringBuffer sb = new StringBuffer();
                        file = new File(sb.append(midletJar, 0, midletJar.length() - 3).append("jad").toString());
                        if (!file.exists()) {
                            sb.setCharAt(sb.length() - 1, 'm');
                            file = new File(sb.toString());
                        }
                    }
                    if (file.exists()) {
                        doja = file.getName().endsWith(".jam");
                        props = new Properties();
                        props.load(new InputStreamReader((InputStream)new FileInputStream(file), doja ? "Shift_JIS" : "UTF-8"));
                        Enumeration<Object> keys = props.keys();
                        while (keys.hasMoreElements()) {
                            String s = (String)keys.nextElement();
                            props.put(s, props.getProperty(s));
                        }
                    }
                    if (doja) {
                        emulatorimpl.getLogStream().println("Running DoJa");
                        System.out.println(props);
                        if (midletJar == null) {
                            String s = file.getName();
                            midletJar = s.substring(0, s.length() - 1) + 'r';
                        }
                    }
                    emulatorimpl.getLogStream().println("Get classes from " + midletJar);
                    ZipFile zipFile = new ZipFile(midletJar);
                    Enumeration entries = zipFile.getEntries();
                    while (entries.hasMoreElements()) {
                        ZipEntry zipEntry = (ZipEntry)entries.nextElement();
                        if (!zipEntry.getName().endsWith(".class")) continue;
                        String replace = zipEntry.getName().substring(0, zipEntry.getName().length() - 6).replace('/', '.');
                        jarClasses.add(replace);
                        emulatorimpl.getLogStream().println("Get class " + (String)replace);
                    }
                    if (props == null || !props.containsKey(doja ? "AppClass" : "MIDlet-1")) {
                        try {
                            Attributes mainAttributes = zipFile.getManifest().getMainAttributes();
                            props = new Properties();
                            for (Map.Entry<Object, Object> entry : mainAttributes.entrySet()) {
                                props.put(entry.getKey().toString(), entry.getValue());
                            }
                            if (!props.containsKey(doja ? "AppClass" : "MIDlet-1")) {
                                throw new Exception();
                            }
                        }
                        catch (Exception ex2) {
                            InputStream inputStream = zipFile.getInputStream(zipFile.getEntry("META-INF/MANIFEST.MF"));
                            inputStream.skip(3L);
                            props = new Properties();
                            props.load(new InputStreamReader(inputStream, "UTF-8"));
                            inputStream.close();
                            Enumeration<Object> keys2 = props.keys();
                            while (keys2.hasMoreElements()) {
                                String s2 = (String)keys2.nextElement();
                                props.put(s2, props.getProperty(s2));
                            }
                        }
                    }
                    emulatorimpl.setAppProperties(props);
                    if (props.containsKey("MIDlet-2") && props.containsKey("MIDlet-1")) {
                        Vector<String> midletKeys = new Vector<String>();
                        Enumeration<Object> keys = props.keys();
                        while (keys.hasMoreElements()) {
                            String s = (String)keys.nextElement();
                            if (!s.startsWith("MIDlet-")) continue;
                            String num = s.substring("MIDlet-".length());
                            try {
                                Integer.parseInt(num);
                                midletKeys.add(s);
                            }
                            catch (Exception exception) {}
                        }
                        if (midletKeys.size() != 0) {
                            Emulator.loadTargetDevice();
                            int n = emulatorimpl.getScreen().showMidletChoice(midletKeys);
                            if (n == -1) {
                                CustomMethod.close();
                                System.exit(0);
                                return false;
                            }
                            String c2 = props.getProperty(midletKeys.get(n));
                            midletClassName = c2.substring(c2.lastIndexOf(",") + 1).trim();
                            return true;
                        }
                    }
                    if (doja) {
                        midletClassName = props.getProperty("AppClass");
                    } else {
                        midletClassName = props.getProperty("MIDlet-1");
                        if (midletClassName != null) {
                            midletClassName = midletClassName.substring(midletClassName.lastIndexOf(",") + 1).trim();
                        }
                    }
                    break block32;
                }
                if (classPath == null) {
                    return false;
                }
                String[] split = classPath.split(";");
                for (int i2 = 0; i2 < split.length; ++i2) {
                    emulatorimpl.getLogStream().println("Get classes from " + split[i2]);
                    Emulator.loadClassesFrom(new File(split[i2]), null);
                }
                Properties aProperties1369 = null;
                if (jadPath != null && (file4 = new File(jadPath)).exists()) {
                    aProperties1369 = new Properties();
                    aProperties1369.load(new InputStreamReader((InputStream)new FileInputStream(file4), "UTF-8"));
                    Enumeration<Object> keys3 = aProperties1369.keys();
                    while (keys3.hasMoreElements()) {
                        String s3 = (String)keys3.nextElement();
                        aProperties1369.put(s3, aProperties1369.getProperty(s3));
                    }
                }
                if (aProperties1369 == null) {
                    aProperties1369 = new Properties();
                }
                emulatorimpl.setAppProperties(aProperties1369);
            }
            catch (Exception ex) {
                if (ex.toString().equalsIgnoreCase("java.io.IOException: Negative seek offset")) {
                    ex.printStackTrace();
                    emulatorimpl.getScreen().showMessage(UILocale.get("LOAD_ZIP_ERROR", "Input file is not JAR or ZIP archive."), CustomMethod.getStackTrace(ex));
                    return false;
                }
                throw ex;
            }
        }
        Emulator.loadTargetDevice();
        return true;
    }

    private static void loadClassesFrom(File file, String s) {
        s = s != null ? s + "." : "";
        File[] listFiles = file.listFiles();
        for (int i2 = 0; i2 < listFiles.length; ++i2) {
            String string = s + listFiles[i2].getName();
            if (listFiles[i2].isDirectory()) {
                Emulator.loadClassesFrom(listFiles[i2], string);
                continue;
            }
            if (!string.endsWith(".class")) continue;
            jarClasses.add(string.substring(0, string.length() - 6));
            emulatorimpl.getLogStream().println("Get class " + string.substring(0, string.length() - 6));
        }
    }

    public static File getFileFromClassPath(String s) {
        if (classPath == null) {
            return null;
        }
        String[] split = classPath.split(";");
        for (int i2 = 0; i2 < split.length; ++i2) {
            File file = new File(split[i2] + File.separatorChar + s);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public static void setupMRUList() {
        String midletJar;
        int n;
        String[] array;
        int j;
        if (Emulator.midletJar == null && Settings.recentJars[0].trim().equalsIgnoreCase("")) {
            return;
        }
        if (Settings.recentJars[0].trim().equalsIgnoreCase("")) {
            Settings.recentJars[0] = Emulator.midletJar;
            return;
        }
        if (Emulator.midletJar != null) {
            for (int i2 = 4; i2 > 0; --i2) {
                if (!Settings.recentJars[i2].equalsIgnoreCase(Settings.recentJars[0])) continue;
                Settings.recentJars[i2] = Settings.recentJars[1];
                Settings.recentJars[1] = Settings.recentJars[0];
                if (!Settings.recentJars[0].equalsIgnoreCase(Emulator.midletJar)) {
                    Settings.recentJars[0] = Emulator.midletJar;
                }
                return;
            }
        }
        for (j = 4; j > 0; --j) {
            if (!Settings.recentJars[j].equalsIgnoreCase(Settings.recentJars[0])) continue;
            Settings.recentJars[j] = Settings.recentJars[1];
            Settings.recentJars[1] = Settings.recentJars[0];
            break;
        }
        if (j == 0) {
            for (int k2 = 4; k2 > 0; --k2) {
                Settings.recentJars[k2] = Settings.recentJars[k2 - 1];
            }
        }
        if (Emulator.midletJar == null) {
            array = Settings.recentJars;
            n = 0;
            midletJar = "";
        } else {
            array = Settings.recentJars;
            n = 0;
            midletJar = Emulator.midletJar;
        }
        array[n] = midletJar;
    }

    private static void setProperties() {
        System.setProperty("microedition.configuration", "CLDC-1.1");
        System.setProperty("microedition.profiles", "MIDP-2.0");
        if (platform.supportsM3G()) {
            System.setProperty("microedition.m3g.version", "1.1");
        }
        System.setProperty("microedition.encoding", Settings.fileEncoding);
        if (System.getProperty("microedition.locale") == null) {
            System.setProperty("microedition.locale", Settings.locale);
        }
        if (System.getProperty("microedition.platform") == null) {
            String plat = Settings.microeditionPlatform;
            httpUserAgent = plat + " (Java/" + System.getProperty("java.version") + "; KEmulator/" + version + ")";
            System.setProperty("microedition.platform", plat);
        }
        System.setProperty("microedition.media.version", "1.0");
        System.setProperty("supports.mixing", "true");
        System.setProperty("supports.audio.capture", "false");
        System.setProperty("supports.recording", "false");
        System.setProperty("microedition.io.file.FileConnection.version", "1.0");
        System.setProperty("microedition.pim.version", "1.0");
        System.setProperty("bluetooth.api.version", "1.0");
        if (System.getProperty("wireless.messaging.sms.smsc") == null) {
            System.setProperty("wireless.messaging.sms.smsc", "+8613800010000");
        }
        if (System.getProperty("wireless.messaging.mms.mmsc") == null) {
            System.setProperty("wireless.messaging.mms.mmsc", "http://mms.kemulator.com");
        }
        System.setProperty("microedition.sensor.version", "1.0");
        System.setProperty("kemulator.notificationapi.version", "1.0");
        System.setProperty("fileconn.dir.photos", "file:///root/photos/");
        System.setProperty("fileconn.dir.music", "file:///root/music/");
        System.setProperty("fileconn.dir.private", "file://root/private/");
        System.setProperty("fileconn.dir.memorycard", "file:///root/e/");
        System.setProperty("microedition.hostname", "localhost");
        if (System.getProperty("wireless.messaging.version") == null) {
            System.setProperty("wireless.messaging.version", "1.0");
        }
        System.setProperty("kemulator.mod.version", version);
        System.setProperty("kemulator.mod.versionint", "33");
        System.setProperty("com.nokia.mid.ui.softnotification", "true");
        System.setProperty("com.nokia.mid.ui.version", "1.4");
        System.setProperty("com.nokia.mid.ui.customfontsize", "true");
        System.setProperty("com.nokia.pointer.number", "0");
        System.setProperty("kemulator.hwid", Utils.getHWID());
        System.setProperty("microedition.amms.version", "1.0");
        System.setProperty("org.pigler.api.version", "1.4-kemulator");
        if (platform.isX64()) {
            System.setProperty("kemulator.x64", "true");
        }
        System.setProperty("kemulator.rpc.version", "1.0");
        try {
            Settings.softbankApi = emulatorimpl.getAppProperty("MIDxlet-API") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        try {
            platform = (IEmulatorPlatform)Class.forName("emulator.EmulatorPlatform").newInstance();
        }
        catch (Exception e2) {
            System.out.println("Platform class not found");
            return;
        }
        try {
            Manifest versionManifest = new Manifest(Emulator.class.getResourceAsStream("/META-INF/version.mf"));
            Attributes mainAttributes = versionManifest.getMainAttributes();
            for (Map.Entry<Object, Object> entry : mainAttributes.entrySet()) {
                if (!entry.getKey().toString().equals("Git-Revision")) continue;
                String s = entry.getValue().toString();
                if (s.length() != 0) {
                    if (debugBuild) {
                        version = s;
                    }
                    revision = s;
                }
                break;
            }
        }
        catch (Exception versionManifest) {
            // empty catch block
        }
        String arch = System.getProperty("os.arch");
        if (!(platform.isX64() || arch.contains("86") && Utils.win)) {
            JOptionPane.showMessageDialog(new JPanel(), "Can't run this version of KEmulator nnmod on this architecture (" + arch + "). Try multi-platform version instead.");
            System.exit(0);
            return;
        }
        try {
            Exception librariesException = null;
            try {
                platform.loadLibraries();
            }
            catch (Exception e3) {
                librariesException = e3;
            }
            EmulatorMIDI.initDevices();
            commandLineArguments = args;
            UILocale.initLocale();
            try {
                Emulator.parseLaunchArgs(args);
            }
            catch (Throwable e3) {
                // empty catch block
            }
            if (!forked && !Settings.uei && (librariesException != null || Utils.macos || Utils.isJava9())) {
                Emulator.loadGame(null, false);
                return;
            }
            if (librariesException != null) {
                librariesException.printStackTrace();
                JOptionPane.showMessageDialog(new JPanel(), "Failed to load libraries: " + librariesException.getMessage());
                System.exit(0);
                return;
            }
            emulatorimpl = bridge ? new BridgeFrontend("/tmp/kem/", 240, 320) : new SWTFrontend();
            Emulator.parseLaunchArgs(args);
            if (platform.isX64()) {
                Settings.g3d = 1;
                Settings.micro3d = 1;
            }
            platform.load3D();
            Controllers.refresh(true);
            emulatorimpl.getLogStream().stdout(Emulator.getCmdVersionString() + " Running on " + System.getProperty("os.name") + ' ' + System.getProperty("os.arch") + " (" + System.getProperty("os.version") + "), Java: " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
            Devices.load(deviceFile);
            Emulator.tryToSetDevice(deviceName);
            Emulator.setupMRUList();
            RichPresence.initRichPresence();
            if (Settings.autoUpdate == 0) {
                Settings.autoUpdate = updated ? 2 : emulatorimpl.getScreen().showUpdateDialog(0);
            }
            backgroundThread.start();
            if (midletClassName == null && midletJar == null) {
                emulatorimpl.getScreen().runEmpty();
                emulatorimpl.dispose();
                System.exit(0);
                return;
            }
            record = new KeyRecords();
            Emulator.getLibraries();
            try {
                if (!Emulator.getJarClasses()) {
                    emulatorimpl.getScreen().showMessage(UILocale.get("LOAD_CLASSES_ERROR", "Get Classes Failed!! Plz check the input jar or classpath."));
                    System.exit(1);
                    return;
                }
            }
            catch (Exception e4) {
                e4.printStackTrace();
                emulatorimpl.getScreen().showMessage(UILocale.get("LOAD_CLASSES_ERROR", "Get Classes Failed!! Plz check the input jar or classpath."), CustomMethod.getStackTrace(e4));
                System.exit(1);
                return;
            }
            InputStream inputStream = null;
            try {
                String iconPath = emulatorimpl.getAppProperty("MIDlet-Icon");
                if (iconPath != null) {
                    Emulator.iconPath = iconPath;
                    inputStream = ResourceManager.getResourceAsStream(iconPath);
                } else {
                    iconPath = emulatorimpl.getAppProperty("AppIcon");
                    if (iconPath != null) {
                        Emulator.iconPath = iconPath = iconPath.split(",")[0].trim();
                        inputStream = ResourceManager.getResourceAsStream(iconPath);
                    } else {
                        iconPath = emulatorimpl.getAppProperty("MIDlet-1");
                        if (iconPath != null) {
                            Emulator.iconPath = iconPath = iconPath.split(",")[1].trim();
                            inputStream = ResourceManager.getResourceAsStream(iconPath);
                        }
                    }
                }
            }
            catch (Exception ex3) {
                ex3.printStackTrace();
            }
            if (emulatorimpl.getAppProperty("MIDlet-Name") != null) {
                RichPresence.rpcState = (Settings.uei ? "Debugging " : "Running ") + emulatorimpl.getAppProperty("MIDlet-Name");
                RichPresence.rpcDetails = Settings.uei ? "UEI" : new File(midletJar).getName();
                RichPresence.updatePresence();
            }
            emulatorimpl.getScreen().setWindowIcon(inputStream);
            Emulator.setProperties();
            if (midletClassName == null) {
                emulatorimpl.getScreen().showMessage(UILocale.get("LOAD_MIDLET_ERROR", "Can not find MIDlet class. Plz check jad or use -midlet param."));
                System.exit(1);
                return;
            }
            if (doja) {
                eventQueue = new EventQueue();
                midlet = new IApplicationMIDlet(midletClassName.trim());
            } else {
                Emulator.getEmulator().getLogStream().stdout("Launch MIDlet class: " + midletClassName);
                try {
                    midletClassName = midletClassName.replace('/', '.');
                    midletClass = Class.forName(midletClassName, true, customClassLoader);
                }
                catch (Throwable e5) {
                    e5.printStackTrace();
                    emulatorimpl.getScreen().showMessage(UILocale.get("FAIL_LAUNCH_MIDLET", "Fail to launch the MIDlet class:") + " " + midletClassName, CustomMethod.getStackTrace(e5));
                    System.exit(1);
                    return;
                }
                eventQueue = new EventQueue();
            }
            new Thread(new Emulator()).start();
            emulatorimpl.getScreen().runWithMidlet();
        }
        catch (Throwable e6) {
            e6.printStackTrace();
        }
        try {
            emulatorimpl.dispose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(0);
    }

    private static void tryToSetDevice(String deviceName) {
        String[][] c2 = null;
        if (deviceName.startsWith("!")) {
            deviceName = deviceName.substring(1);
            String[] a2 = deviceName.split(";");
            c2 = new String[a2.length][2];
            int idx = 0;
            for (String s : a2) {
                int i2 = s.indexOf(58);
                if (i2 == -1) {
                    deviceName = s;
                    continue;
                }
                c2[idx][0] = s.substring(0, i2);
                c2[idx++][1] = s.substring(i2 + 1);
            }
        }
        if (!Devices.setPreset(Emulator.deviceName = deviceName)) {
            Emulator.deviceName = Devices.getDefaultPreset();
            Devices.setPreset(Emulator.deviceName);
        }
        emulatorimpl.getProperty().setCustomProperties();
        if (c2 != null) {
            for (String[] p : c2) {
                if (p == null || p[0] == null) continue;
                Devices.setProperty(p[0], p[1]);
            }
        }
        Devices.writeProperties();
        emulatorimpl.getProperty().updateCustomProperties();
        emulatorimpl.getProperty().resetDeviceName();
        KeyMapping.init();
    }

    static boolean parseLaunchArgs(String[] array) {
        if (array.length < 1) {
            return false;
        }
        if (array.length == 1 && (array[0].endsWith(".jar") || array[0].endsWith(".jad")) || array[0].endsWith(".jam")) {
            String path = array[0];
            if (path.endsWith(".jar")) {
                try {
                    midletJar = new File(path).getCanonicalPath();
                }
                catch (Exception e2) {
                    midletJar = path;
                }
            } else {
                jadPath = path;
                midletJar = Emulator.getMidletJarUrl(path);
            }
            return true;
        }
        for (int i2 = 0; i2 < array.length; ++i2) {
            String key = array[i2].trim();
            if (key.startsWith("-")) {
                key = key.substring(1).toLowerCase();
            } else if (key.endsWith(".jar") || key.endsWith(".jad") || key.endsWith(".jam")) {
                if (key.endsWith(".jar")) {
                    try {
                        midletJar = new File(key).getCanonicalPath();
                    }
                    catch (Exception e3) {
                        midletJar = key;
                    }
                } else {
                    jadPath = key;
                    midletJar = Emulator.getMidletJarUrl(key);
                }
            }
            String value = null;
            if (i2 < array.length - 1) {
                value = array[i2 + 1].trim();
                if (!value.startsWith("-")) {
                    ++i2;
                } else {
                    value = null;
                }
            }
            if (key.equals("awt")) {
                Settings.g2d = 1;
                continue;
            }
            if (key.equals("swt")) {
                Settings.g2d = 0;
                continue;
            }
            if (key.equals("lwj")) {
                Settings.g3d = 1;
                continue;
            }
            if (key.equals("swerve")) {
                Settings.g3d = 0;
                continue;
            }
            if (key.equals("mascotgl")) {
                Settings.micro3d = 1;
                continue;
            }
            if (key.equals("mascotdll")) {
                Settings.micro3d = 0;
                continue;
            }
            if (key.equalsIgnoreCase("log")) {
                Settings.showLogFrame = true;
                continue;
            }
            if (key.equalsIgnoreCase("uei")) {
                Settings.uei = true;
                continue;
            }
            if (key.equalsIgnoreCase("s")) {
                forked = true;
                continue;
            }
            if (key.equalsIgnoreCase("updated")) {
                updated = true;
                continue;
            }
            if (key.equals("bridge")) {
                bridge = true;
                continue;
            }
            if (value == null) continue;
            if (key.equalsIgnoreCase("jar")) {
                try {
                    midletJar = new File(value).getCanonicalPath();
                }
                catch (Exception e4) {
                    midletJar = value;
                }
                continue;
            }
            if (key.equalsIgnoreCase("midlet")) {
                midletClassName = array[i2];
                continue;
            }
            if (key.equalsIgnoreCase("cp")) {
                classPath = value;
                continue;
            }
            if (key.equalsIgnoreCase("jad")) {
                jadPath = value;
                continue;
            }
            if (key.equalsIgnoreCase("rec")) {
                Settings.recordedKeysFile = value;
                Settings.playingRecordedKeys = new File(value).exists();
                continue;
            }
            if (key.equalsIgnoreCase("device")) {
                deviceName = value;
                continue;
            }
            if (key.equalsIgnoreCase("devicefile")) {
                deviceFile = value;
                continue;
            }
            if (key.equalsIgnoreCase("fontname")) {
                Emulator.getEmulator().getProperty().setDefaultFontName(value);
                continue;
            }
            if (key.equalsIgnoreCase("fontsmall")) {
                Emulator.getEmulator().getProperty().setFontSmallSize(Integer.parseInt(value));
                continue;
            }
            if (key.equalsIgnoreCase("fontmedium")) {
                Emulator.getEmulator().getProperty().getFontMediumSize(Integer.parseInt(value));
                continue;
            }
            if (key.equalsIgnoreCase("fontlarge")) {
                Emulator.getEmulator().getProperty().getFontLargeSize(Integer.parseInt(value));
                continue;
            }
            if (key.equalsIgnoreCase("key")) {
                KeyMapping.keyArg(value);
                continue;
            }
            if (key.equals("new-project")) {
                new Property();
                IdeaUtils.createProjectCLI(value);
                continue;
            }
            if (key.equals("restore")) {
                new Property();
                IdeaUtils.restoreProjectCLI(value);
                continue;
            }
            if (key.equals("convert")) {
                new Property();
                IdeaUtils.convertProjectCLI(value);
                continue;
            }
            if (!key.equals("edit")) continue;
            new Property();
            IdeaUtils.editProjectCLI(value);
        }
        return true;
    }

    public static String getAbsoluteFile() {
        String s = System.getProperty("user.dir");
        if (new File(s + File.separatorChar + "KEmulator.jar").exists() || new File(s + File.separatorChar + "sensorsimulator.jar").exists()) {
            return s + File.separatorChar + "KEmulator.jar";
        }
        s = Emulator.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        if (Utils.win) {
            s = s.substring(1);
        }
        if (debugBuild && s.endsWith("/")) {
            if (s.endsWith("bin/production/KEmulator_base/")) {
                s = s.substring(0, s.length() - "bin/production/KEmulator_base/".length()) + "home";
            } else if (s.endsWith("eclipse/KEmulator_base/bin/")) {
                s = s.substring(0, s.length() - "eclipse/KEmulator_base/bin/".length()) + "home";
            }
            if (new File(s + File.separatorChar + "KEmulator.jar").exists() || new File(s + File.separatorChar + "sensorsimulator.jar").exists()) {
                s = s + File.separatorChar + "KEmulator.jar";
            } else {
                System.out.println("Running from " + s);
                throw new RuntimeException("Could not find home directory");
            }
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception ex) {
            return s;
        }
    }

    public static String getAbsolutePath() {
        String s = System.getProperty("user.dir");
        if (new File(s + File.separatorChar + "KEmulator.jar").exists() || new File(s + File.separatorChar + "sensorsimulator.jar").exists()) {
            return s;
        }
        File file = new File(Emulator.getAbsoluteFile()).getParentFile();
        try {
            s = file.getCanonicalPath();
        }
        catch (IOException e2) {
            s = file.getAbsolutePath();
        }
        return s;
    }

    private static boolean checkIsPortable() {
        String path = Emulator.getAbsoluteFile();
        if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0]) && !Files.isWritable(Paths.get(path, new String[0]))) {
            return false;
        }
        if (Utils.linux) {
            if (path.startsWith("/opt/") || path.startsWith("/usr/") || path.startsWith("/bin/")) {
                return false;
            }
            return !path.contains("/home/") || !path.contains("/.local/");
        }
        if (Utils.win) {
            try {
                String pathFromReg;
                String output = Utils.getProcessOutput(new String[]{"reg", "query", "HKEY_LOCAL_MACHINE\\Software\\nnproject\\KEmulator", "/v", "JarInstalledPath"}, false);
                int i2 = output.indexOf("REG_SZ");
                if (i2 != -1 && Files.isSameFile(Paths.get(pathFromReg = output.substring(i2 + 6).trim(), new String[0]), Paths.get(path, new String[0]))) {
                    return false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return !path.contains("\\Users\\") || !path.contains("\\AppData\\Local\\");
        }
        return true;
    }

    public static String getUserPath() {
        block4: {
            String s;
            block6: {
                block5: {
                    if (isPortable) break block4;
                    if (!Utils.linux) break block5;
                    s = System.getenv("HOME") + "/.local/share/KEmulator/";
                    break block6;
                }
                if (!Utils.win || (s = System.getenv("APPDATA")) == null) break block4;
                s = s + "\\KEmulator";
            }
            Path p = Paths.get(s, new String[0]);
            if (Files.exists(p, new LinkOption[0]) && Files.isDirectory(p, new LinkOption[0])) {
                return s;
            }
            try {
                Files.createDirectories(p, new FileAttribute[0]);
            }
            catch (IOException e2) {
                break block4;
            }
            return s;
        }
        return Emulator.getAbsolutePath();
    }

    public static void loadGame(String s, boolean b2) {
        Emulator.loadGame(s, Settings.g2d, Settings.g3d, Settings.micro3d, b2);
    }

    public static void loadGame(String s, int engine2d, int engine3d, int mascotEngine, boolean b2) {
        ArrayList<String> cmd = new ArrayList<String>();
        if (emulatorimpl != null) {
            Emulator.getEmulator().getLogStream().println(s == null ? "Restarting" : "loadGame: " + s);
        } else {
            System.out.println(s == null ? "Restarting" : "loadGame: " + s);
        }
        String javahome = System.getProperty("java.home");
        cmd.add(javahome == null || javahome.length() < 1 ? "java" : javahome + (!Utils.win ? "/bin/java" : "/bin/java.exe"));
        cmd.add("-cp");
        cmd.add(System.getProperty("java.class.path"));
        cmd.add("-Xmx" + Settings.xmx + "M");
        if (Settings.jdwpDebug) {
            cmd.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=" + Settings.debugPort);
        }
        cmd.add("-Djava.library.path=" + Emulator.getAbsolutePath());
        if ("false".equals(System.getProperty("sun.java3d.d3d"))) {
            cmd.add("-Dsun.java3d.d3d=false");
        }
        if (Utils.os.startsWith("darwin") || Utils.os.startsWith("mac os")) {
            cmd.add("-XstartOnFirstThread");
        }
        if (debugBuild) {
            String[] f2 = new File(Emulator.getAbsolutePath() + "/../eclipse/KEmulator_base/agent.jar");
            if (f2.exists()) {
                cmd.add("-javaagent:" + f2);
            } else {
                cmd.add("-javaagent:" + Emulator.getAbsoluteFile());
            }
        } else {
            cmd.add("-javaagent:" + Emulator.getAbsoluteFile());
        }
        if (Utils.isJava9()) {
            cmd.add("--add-opens");
            cmd.add("java.base/java.lang=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("java.base/java.lang.reflect=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("java.base/java.lang.ref=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("java.base/java.io=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("java.base/java.util=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("jdk.unsupported/sun.misc=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("java.desktop/com.sun.media.sound=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("java.desktop/javax.sound.midi=ALL-UNNAMED");
            if (Utils.isJava17()) {
                cmd.add("--enable-native-access=ALL-UNNAMED");
            }
        }
        cmd.add("emulator.Emulator");
        if (s == null) {
            for (String a2 : commandLineArguments) {
                if (a2.equals("-swt") || a2.equals("-awt") || a2.equals("-swerve") || a2.equals("-lwj")) continue;
                cmd.add(a2);
            }
        } else if (s.endsWith(".jad") || s.endsWith(".jam")) {
            cmd.add("-jad");
            cmd.add(s);
            cmd.add("-jar");
            cmd.add(Emulator.getMidletJarUrl(s));
        } else {
            cmd.add("-jar");
            cmd.add(s);
        }
        if (Settings.recordedKeysFile != null) {
            cmd.add("-rec");
            cmd.add(Settings.recordedKeysFile);
        }
        cmd.add(engine2d == 0 ? "-swt" : "-awt");
        cmd.add(engine3d == 0 ? "-swerve" : "-lwj");
        cmd.add(mascotEngine == 0 ? "-mascotdll" : "-mascotgl");
        cmd.add("-s");
        try {
            Emulator.getEmulator().disposeSubWindows();
            Emulator.notifyDestroyed();
        }
        catch (NullPointerException f2) {
            // empty catch block
        }
        try {
            ProcessBuilder newKem = new ProcessBuilder(new String[0]).directory(new File(Emulator.getAbsolutePath())).command(cmd).inheritIO();
            newKem.environment().remove("GDK_BACKEND");
            newKem.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        CustomMethod.close();
        System.exit(0);
    }

    static String getMidletJarUrl(String jadPath) {
        try {
            File file = new File(jadPath);
            if (file.exists()) {
                if (jadPath.endsWith(".jam")) {
                    return jadPath.substring(0, jadPath.length() - 1) + 'r';
                }
                Properties properties = new Properties();
                properties.load(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                return file.getParent() + File.separator + properties.getProperty("MIDlet-Jar-URL");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void AntiCrack(Exception ex) {
    }

    public static String getMidletName() {
        String x = emulatorimpl.getAppProperty("MIDlet-1").split(",")[0];
        if (x.startsWith(" ")) {
            x = x.substring(1);
        }
        if (x.endsWith(" ")) {
            x = x.substring(0, x.length() - 1);
        }
        return x;
    }

    public static boolean isX64() {
        return platform.isX64();
    }

    public static IEmulatorPlatform getPlatform() {
        return platform;
    }

    public static IGraphics3D getGraphics3D() {
        return platform.getGraphics3D();
    }

    @Override
    public void run() {
        if (!doja) {
            try {
                midletClass.newInstance();
            }
            catch (Throwable e2) {
                e2.printStackTrace();
                eventQueue.stop();
                emulatorimpl.getScreen().showMessageThreadSafe(UILocale.get("FAIL_LAUNCH_MIDLET", "Fail to launch the MIDlet class:") + " " + midletClassName, CustomMethod.getStackTrace(e2));
                return;
            }
        }
        if (Emulator.getEmulator() instanceof SWTFrontend) {
            SWTFrontend swt = (SWTFrontend)Emulator.getEmulator();
            swt.getClassWatcher().fillClassList();
            swt.getProfiler().fillClassList();
        }
        eventQueue.queue(10);
    }

    static {
        isPortable = Emulator.checkIsPortable();
        customClassLoader = new CustomClassLoader(ClassLoader.getSystemClassLoader());
        jarLibrarys = new Vector();
        jarClasses = new Vector();
        deviceName = "SonyEricssonK800";
        deviceFile = "/res/presets.xml";
        backgroundThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Manager.checkLibVlcSupport();
                if (!updated && !Settings.uei && Settings.autoUpdate == 2 && Updater.checkUpdate() == 2 && emulatorimpl instanceof SWTFrontend) {
                    SWTFrontend.getDisplay().asyncExec(() -> Emulator.getEmulator().getScreen().showUpdateDialog(1));
                }
            }
        });
    }
}

