/*
 * Decompiled with CFR 0.152.
 */
package emulator;

import emulator.Agent;
import emulator.Emulator;
import emulator.IEmulatorPlatform;
import emulator.UILocale;
import emulator.Utils;
import emulator.graphics3D.IGraphics3D;
import emulator.graphics3D.lwjgl.Emulator3D;
import java.io.File;

public class EmulatorPlatform
implements IEmulatorPlatform {
    @Override
    public boolean isX64() {
        return true;
    }

    @Override
    public String getName() {
        return "KEmulator nnx64";
    }

    @Override
    public String getTitleName() {
        return "KEmnnx64";
    }

    @Override
    public String getInfoString(String version) {
        return "KEmulator nnmod " + version + "\n\n\tMulti-Platform\n\t" + UILocale.get("ABOUT_INFO_EMULATOR", "Mobile Game Emulator") + "\n\n" + UILocale.get("ABOUT_INFO_APIS", "Support APIs") + ":\n\n\tMIDP 2.0 (JSR118)\n\tNokiaUI 1.4\n\tSprint 1.0\n\tSiemens API\n\tWMA 1.0 (JSR120)\n\tM3G 1.1 (JSR184)\n\tOpenGL ES (JSR239)\n\tMascotCapsule v3\n\tSoftBank MEXA";
    }

    @Override
    public void loadLibraries() {
        System.setProperty("jna.nosys", "true");
        if (Utils.termux) {
            System.setProperty("org.lwjgl.librarypath", "/data/data/com.termux/files/usr/lib:" + Emulator.getAbsolutePath());
        }
        this.loadSWTLibrary();
        this.loadLWJGLNatives();
        EmulatorPlatform.loadAMR();
    }

    @Override
    public boolean supportsMascotCapsule() {
        return true;
    }

    @Override
    public boolean supportsM3G() {
        return true;
    }

    @Override
    public IGraphics3D getGraphics3D() {
        return Emulator3D.getInstance();
    }

    @Override
    public void load3D() {
        Class<?> cls2;
        if (this.supportsM3G()) {
            boolean m3gLoaded = false;
            try {
                cls2 = Class.forName("javax.microedition.m3g.Graphics3D");
                try {
                    m3gLoaded = !cls2.getField("_STUB").getBoolean(null);
                }
                catch (Throwable e2) {
                    m3gLoaded = true;
                }
            }
            catch (Throwable cls2) {
                // empty catch block
            }
            if (!m3gLoaded) {
                EmulatorPlatform.addToClassPath("m3g_lwjgl.jar");
            }
        }
        if (this.supportsMascotCapsule()) {
            boolean mascotLoaded = false;
            try {
                cls2 = Class.forName("com.mascotcapsule.micro3d.v3.Graphics3D");
                try {
                    mascotLoaded = !cls2.getField("_STUB").getBoolean(null);
                }
                catch (Throwable e3) {
                    mascotLoaded = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!mascotLoaded) {
                EmulatorPlatform.addToClassPath("micro3d_gl.jar");
            }
        }
    }

    private void loadSWTLibrary() {
        if (new File(Emulator.getAbsolutePath() + File.separatorChar + "swt-custom.jar").exists()) {
            EmulatorPlatform.addToClassPath("swt-custom.jar");
            return;
        }
        String swtLibName = this.getSwtLibraryName();
        try {
            EmulatorPlatform.addToClassPath(swtLibName);
        }
        catch (RuntimeException e2) {
            try {
                Class.forName("org.eclipse.swt.SWT");
            }
            catch (ClassNotFoundException e22) {
                throw e2;
            }
        }
    }

    private void loadLWJGLNatives() {
        try {
            for (String lib : this.getLwjglLibraryNames()) {
                EmulatorPlatform.addToClassPath(lib);
            }
        }
        catch (RuntimeException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public String[] getLwjglLibraryNames() {
        String os;
        String osn = System.getProperty("os.name").toLowerCase();
        String osa = System.getProperty("os.arch").toLowerCase();
        String string = osn.contains("win") ? "windows" : (osn.contains("mac") ? "macos" : (Utils.termux ? "android" : (os = osn.contains("linux") || osn.contains("nix") ? "linux" : null)));
        if (os == null) {
            return new String[0];
        }
        if (!(osa.contains("amd64") || osa.contains("86") || osa.contains("aarch64") || osa.contains("arm"))) {
            return new String[0];
        }
        String arch = os + (osa.contains("amd64") || osa.contains("x86_64") ? "" : (osa.contains("86") ? "-x86" : (osa.contains("aarch64") ? "-arm64" : (osa.contains("arm") ? "-arm32" : ""))));
        String[] l = new String[]{"lwjgl-natives-" + arch + ".jar", "lwjgl-glfw-natives-" + arch + ".jar", "lwjgl-opengl-natives-" + arch + ".jar", "lwjgl3-swt-" + arch + ".jar"};
        return l;
    }

    @Override
    public String getSwtLibraryName() {
        String arch;
        String os;
        String osn = System.getProperty("os.name").toLowerCase();
        String osa = System.getProperty("os.arch").toLowerCase();
        if (osn.contains("win")) {
            os = "win32";
        } else if (osn.contains("mac")) {
            os = "macosx";
        } else if (Utils.termux) {
            os = "gtk-android";
        } else if (osn.contains("linux") || osn.contains("nix")) {
            os = "gtk-linux";
        } else {
            throw new RuntimeException("Unsupported os: " + osn);
        }
        if (osa.contains("amd64") || osa.contains("x86_64")) {
            arch = "x86_64";
        } else if (osa.contains("86")) {
            arch = "x86";
        } else if (osa.contains("aarch64") || osa.contains("armv8")) {
            arch = "aarch64";
        } else if (osa.contains("arm")) {
            arch = "armhf";
        } else if (osa.contains("ppc") || osa.contains("riscv")) {
            arch = osa;
        } else {
            throw new RuntimeException("Unsupported arch: " + osa);
        }
        return "swt-" + os + "-" + arch + ".jar";
    }

    private static void loadAMR() {
        String osn = System.getProperty("os.name").toLowerCase();
        String osa = System.getProperty("os.arch").toLowerCase();
        String path = Emulator.getAbsolutePath() + File.separatorChar;
        try {
            if (osn.contains("win")) {
                path = osa.contains("amd64") || osa.contains("x86_64") ? path + "amrdecoder_64.dll" : (osa.contains("aarch64") || osa.contains("arm") ? path + "amrdecoder_arm64.dll" : path + "amrdecoder.dll");
                System.load(path);
            } else if (osn.contains("linux")) {
                path = path + "libamrdecoder";
                if (osa.contains("amd64") || osa.contains("x86_64")) {
                    path = path + "_64";
                } else if (!osa.contains("86")) {
                    path = osa.contains("aarch64") || osa.contains("armv8") ? path + "_arm64" : (osa.contains("arm") ? path + "_arm32" : path + '_' + osa);
                }
                System.load(path + ".so");
            } else if (osn.contains("mac")) {
                path = path + "libamrdecoder";
                if (osa.contains("aarch64")) {
                    path = path + "_arm64";
                }
                System.load(path + ".dylib");
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    private static void addToClassPath(String s) {
        try {
            Agent.addClassPath(new File(Emulator.getAbsolutePath() + File.separatorChar + s));
        }
        catch (Exception e2) {
            throw new RuntimeException(s, e2);
        }
    }
}

