/*
 * Decompiled with CFR 0.152.
 */
package emulator;

import com.vodafone.v10.graphics.sprite.SpriteCanvas;
import emulator.Emulator;
import emulator.InvokeDestroyAppRunnable;
import emulator.InvokeStartAppRunnable;
import emulator.Settings;
import emulator.graphics2D.IImage;
import emulator.ui.IScreen;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Screen;
import net.rim.device.api.system.Application;

public final class EventQueue
implements Runnable {
    public static final int EVENT_PAINT = 1;
    public static final int EVENT_CALL = 2;
    public static final int EVENT_SCREEN = 4;
    public static final int EVENT_START = 10;
    public static final int EVENT_EXIT = 11;
    public static final int EVENT_SHOW = 15;
    public static final int EVENT_PAUSE = 16;
    public static final int EVENT_RESUME = 17;
    public static final int EVENT_INPUT = 18;
    public static final int EVENT_COMMAND = 19;
    public static final int EVENT_ITEM_STATE = 20;
    public static final int EVENT_HIDE = 21;
    boolean running = true;
    private int[] events;
    private int count;
    private final Vector eventArguments = new Vector();
    private final Thread eventThread;
    private boolean paused = false;
    private final Object callbackLock = new Object();
    private boolean alive;
    private final Object eventLock = new Object();
    private final Object repaintLock = new Object();
    private boolean repaintPending;
    private int repaintX;
    private int repaintY;
    private int repaintW;
    private int repaintH;
    private int[][] inputs;
    private int inputsCount;
    private final InputThread input = new InputThread();
    private final Thread inputThread;
    private String pointerNumber;
    private Timer screenTimer;
    private TimerTask screenTimerTask;

    public EventQueue() {
        this.events = new int[128];
        this.inputs = new int[128][];
        this.eventThread = new Thread((Runnable)this, "KEmulator-EventQueue");
        this.eventThread.setPriority(3);
        this.eventThread.start();
        this.inputThread = new Thread((Runnable)this.input, "KEmulator-InputQueue");
        this.inputThread.setPriority(3);
        this.inputThread.start();
        Thread crashThread = new Thread(){

            @Override
            public void run() {
                long time = System.currentTimeMillis();
                try {
                    while (EventQueue.this.running) {
                        if (EventQueue.this.alive || EventQueue.this.paused || Settings.steps >= 0) {
                            time = System.currentTimeMillis();
                            EventQueue.this.alive = false;
                        } else if (System.currentTimeMillis() - time > 5000L) {
                            time = System.currentTimeMillis();
                            if (!Settings.uei) {
                                Emulator.getEmulator().getLogStream().println("Event thread is not responding! Is it dead locked?");
                            }
                        }
                        Displayable._fpsLimiter(false);
                        1.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        crashThread.start();
    }

    public void stop() {
        this.running = false;
    }

    public void keyPress(int n) {
        if (n == 10000) {
            return;
        }
        if (Settings.synchronizeKeyEvents) {
            this.queueInput(new int[]{0, n, 0, -1});
        } else {
            this.input.queue(0, n, 0, -1);
        }
    }

    public void keyRelease(int n) {
        if (n == 10000) {
            return;
        }
        if (Settings.synchronizeKeyEvents) {
            this.queueInput(new int[]{1, n, 0, -1});
        } else {
            this.input.queue(1, n, 0, -1);
        }
    }

    public void keyRepeat(int n) {
        if (n == 10000) {
            return;
        }
        if (Settings.synchronizeKeyEvents) {
            this.queueInput(new int[]{2, n, 0, -1});
        } else {
            this.input.queue(2, n, 0, -1);
        }
    }

    public void mouseDown(int x, int y, int pointer) {
        if (Settings.synchronizeKeyEvents) {
            this.queueInput(new int[]{0, x, y, pointer});
        } else {
            this.input.queue(0, x, y, pointer);
        }
    }

    public void mouseUp(int x, int y, int pointer) {
        if (Settings.synchronizeKeyEvents) {
            this.queueInput(new int[]{1, x, y, pointer});
        } else {
            this.input.queue(1, x, y, pointer);
        }
    }

    public void mouseDrag(int x, int y, int pointer) {
        if (Settings.synchronizeKeyEvents) {
            this.queueInput(new int[]{2, x, y, pointer});
        } else {
            this.input.queue(2, x, y, pointer);
        }
    }

    public void sizeChanged(int x, int y) {
        this.queue(Integer.MIN_VALUE | x & 0xFFF | (y & 0xFFF) << 12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueInput(int[] o) {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            this.inputs[this.inputsCount++] = o;
            if (this.inputsCount >= this.inputs.length) {
                int[][] nArrayArray = new int[this.inputs.length * 2][];
                this.inputs = nArrayArray;
                System.arraycopy(this.inputs, 0, nArrayArray, 0, this.inputsCount);
            }
        }
        this.queue(18);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void queue(int n) {
        if (n == 1 || n == 4) {
            if (this.repaintPending) {
                return;
            }
            this.repaintPending = true;
        }
        if (n == 15 || n == 17) {
            this.paused = false;
        }
        this.events[this.count++] = n;
        if (this.count >= this.events.length) {
            this.events = new int[this.events.length * 2];
            System.arraycopy(this.events, 0, this.events, 0, this.count);
        }
        Object object = this.eventLock;
        synchronized (object) {
            this.eventLock.notify();
        }
    }

    private synchronized int nextEvent() {
        if (this.count == 0) {
            return 0;
        }
        int n = this.events[0];
        System.arraycopy(this.events, 1, this.events, 0, this.events.length - 1);
        --this.count;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object nextArgument() {
        Object a2 = null;
        Vector vector2 = this.eventArguments;
        synchronized (vector2) {
            if (!this.eventArguments.isEmpty()) {
                a2 = this.eventArguments.remove(0);
            }
        }
        return a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueRepaint() {
        Object object = this.repaintLock;
        synchronized (object) {
            this.repaintH = -1;
            this.repaintW = -1;
            this.repaintY = -1;
            this.repaintX = -1;
            this.queue(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueRepaint(int x, int y, int w, int h2) {
        if (Settings.j2lStyleFpsLimit) {
            Displayable._fpsLimiter(true);
        }
        Object object = this.repaintLock;
        synchronized (object) {
            int x1 = x;
            int y1 = y;
            int x2 = x + w;
            int y2 = y + h2;
            Displayable d = this.getCurrent();
            int sw = d.getWidth();
            int sh = d.getHeight();
            if (this.repaintX != -1) {
                x1 = Math.min(this.repaintX, x1);
                y1 = Math.min(this.repaintY, y1);
                x2 = Math.max(this.repaintX + this.repaintW, x2);
                y2 = Math.max(this.repaintY + this.repaintH, y2);
            }
            if (x1 < 0) {
                x1 = 0;
            }
            if (y1 < 0) {
                y1 = 0;
            }
            if (x2 > sw) {
                x2 = sw;
            }
            if (y2 > sh) {
                y2 = sh;
            }
            this.repaintX = x1;
            this.repaintY = y1;
            this.repaintW = x2 - x1;
            this.repaintH = y2 - y1;
            this.queue(1);
        }
    }

    public void itemStateChanged(Item item) {
        this.eventArguments.add(item);
        this.queue(20);
    }

    public void commandAction(Command command, Item item) {
        this.eventArguments.add(command);
        this.eventArguments.add(item);
        this.queue(19);
    }

    public void commandAction(Command command, Displayable d) {
        this.eventArguments.add(command);
        this.eventArguments.add(d);
        this.queue(19);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gameGraphicsFlush() {
        Object object = this.repaintLock;
        synchronized (object) {
            IScreen scr = Emulator.getEmulator().getScreen();
            if (Settings.asyncFlush) {
                IImage screenImage = scr.getScreenImg();
                IImage backBufferImage2 = scr.getBackBufferImage();
                IImage xRayScreenImage2 = scr.getXRayScreenImage();
                (Settings.xrayView ? xRayScreenImage2 : backBufferImage2).cloneImage(screenImage);
            }
            scr.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gameGraphicsFlush(int x, int y, int w, int h2) {
        Object object = this.repaintLock;
        synchronized (object) {
            IScreen scr = Emulator.getEmulator().getScreen();
            if (Settings.asyncFlush) {
                IImage screenImage = scr.getScreenImg();
                IImage backBufferImage2 = scr.getBackBufferImage();
                IImage xRayScreenImage2 = scr.getXRayScreenImage();
                (Settings.xrayView ? xRayScreenImage2 : backBufferImage2).cloneImage(screenImage, x, y, w, h2);
            }
            scr.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRepaints() {
        if (Settings.ignoreServiceRepaints) {
            return;
        }
        Object object = this.callbackLock;
        synchronized (object) {
            if (!this.repaintPending) {
                return;
            }
            this.repaintPending = false;
            int x = this.repaintX;
            int y = this.repaintY;
            int w = this.repaintW;
            int h2 = this.repaintH;
            this.repaintH = -1;
            this.repaintW = -1;
            this.repaintY = -1;
            this.repaintX = -1;
            this.internalRepaint(x, y, w, h2);
        }
        if (!Settings.j2lStyleFpsLimit) {
            Displayable._fpsLimiter(true);
        }
    }

    public void notifyHidden(Displayable d) {
        this.eventArguments.add(d);
        this.queue(21);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int event = 0;
        try {
            block37: while (this.running) {
                this.alive = true;
                if (Emulator.getMIDlet() == null || this.paused) {
                    Thread.sleep(5L);
                    continue;
                }
                try {
                    event = this.nextEvent();
                    switch (event) {
                        case 1: {
                            Object object = this.callbackLock;
                            synchronized (object) {
                                if (!this.repaintPending) {
                                    break;
                                }
                                this.repaintPending = false;
                                int x = this.repaintX;
                                int y = this.repaintY;
                                int w = this.repaintW;
                                int h2 = this.repaintH;
                                this.repaintH = -1;
                                this.repaintW = -1;
                                this.repaintY = -1;
                                this.repaintX = -1;
                                this.internalRepaint(x, y, w, h2);
                                if (Settings.j2lStyleFpsLimit) break;
                            }
                            Displayable._fpsLimiter(true);
                            break;
                        }
                        case 2: {
                            this.processSerialEvent();
                            break;
                        }
                        case 4: {
                            Object d = this.getCurrent();
                            this.repaintPending = false;
                            if (!(d instanceof Screen)) break;
                            IScreen scr = Emulator.getEmulator().getScreen();
                            IImage backBufferImage3 = scr.getBackBufferImage();
                            IImage xRayScreenImage3 = scr.getXRayScreenImage();
                            ((Screen)d)._invokePaint(new Graphics(backBufferImage3, xRayScreenImage3));
                            if (Settings.asyncFlush) {
                                try {
                                    (Settings.xrayView ? xRayScreenImage3 : backBufferImage3).cloneImage(scr.getScreenImg());
                                }
                                catch (Exception h2) {
                                    // empty catch block
                                }
                            }
                            scr.repaint();
                            int interval = ((Screen)d)._repaintInterval();
                            if (interval <= 0) break;
                            Object object = this.callbackLock;
                            synchronized (object) {
                                if (this.screenTimer == null) {
                                    this.screenTimer = new Timer();
                                }
                                if (this.screenTimerTask != null) {
                                    try {
                                        this.screenTimerTask.cancel();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    this.screenTimerTask = null;
                                }
                                this.screenTimerTask = new ScreenTimerTask();
                                this.screenTimer.schedule(this.screenTimerTask, interval);
                                break;
                            }
                        }
                        case 10: {
                            if (Emulator.getMIDlet() == null) break;
                            Thread t = new Thread(new InvokeStartAppRunnable(true));
                            t.setPriority(5);
                            t.start();
                            break;
                        }
                        case 11: {
                            this.stop();
                            if (Emulator.getMIDlet() == null) break;
                            Thread t = new Thread(new InvokeDestroyAppRunnable(this));
                            t.setPriority(5);
                            t.start();
                            break;
                        }
                        case 15: {
                            Object d = this.getCurrent();
                            if (!(this.getCurrent() instanceof Canvas)) break;
                            ((Canvas)d)._invokeShowNotify();
                            break;
                        }
                        case 16: {
                            Object d = this.getCurrent();
                            if (!(d instanceof Canvas)) break;
                            ((Canvas)d)._invokeHideNotify();
                            this.paused = true;
                            if (!Settings.startAppOnResume) break;
                            try {
                                Emulator.getMIDlet().invokePauseApp();
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                            break;
                        }
                        case 17: {
                            Object d = this.getCurrent();
                            if (Settings.startAppOnResume) {
                                try {
                                    Thread t = new Thread(new InvokeStartAppRunnable(false));
                                    t.setPriority(5);
                                    t.start();
                                }
                                catch (Exception e3) {
                                    e3.printStackTrace();
                                }
                            }
                            if (!(d instanceof Canvas)) break;
                            ((Canvas)d)._invokeShowNotify();
                            break;
                        }
                        case 18: {
                            int[] e4;
                            if (this.inputsCount <= 0) break;
                            Object e3 = this;
                            synchronized (e3) {
                                e4 = this.inputs[0];
                                System.arraycopy(this.inputs, 1, this.inputs, 0, this.inputs.length - 1);
                                --this.inputsCount;
                                if (e4 == null) break;
                            }
                            e3 = this.callbackLock;
                            synchronized (e3) {
                                this.processInputEvent(e4);
                                continue block37;
                            }
                        }
                        case 20: {
                            Item item = (Item)this.nextArgument();
                            Screen screen = item._getParent();
                            if (!(screen instanceof Form) || screen != this.getCurrent()) break;
                            ((Form)screen)._itemStateChanged(item);
                            break;
                        }
                        case 19: {
                            Command cmd = (Command)this.nextArgument();
                            Object target = this.nextArgument();
                            if (target instanceof Item) {
                                ((Item)target)._callCommandAction(cmd);
                                break;
                            }
                            ((Displayable)target)._callCommandAction(cmd);
                            break;
                        }
                        case 21: {
                            Object d = (Displayable)this.nextArgument();
                            if (!(d instanceof Canvas)) break;
                            ((Canvas)d)._invokeHideNotify();
                            break;
                        }
                        case 0: {
                            Object d = this.eventLock;
                            synchronized (d) {
                                this.eventLock.wait(1000L);
                                break;
                            }
                        }
                        default: {
                            Object d;
                            if ((event & Integer.MIN_VALUE) == 0 || (d = this.getCurrent()) == null) break;
                            ((Displayable)d)._invokeSizeChanged(event & 0xFFF, event >> 12 & 0xFFF);
                            break;
                        }
                    }
                    if (!Settings.queueSleep) continue;
                    Thread.sleep(1L);
                }
                catch (Throwable e5) {
                    System.err.println("Exception in Event Thread!");
                    System.err.println("Event: " + event);
                    e5.printStackTrace();
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSerialEvent() {
        Runnable r = null;
        Object object = this.eventArguments;
        synchronized (object) {
            if (!this.eventArguments.isEmpty()) {
                r = (Runnable)this.eventArguments.remove(0);
            }
        }
        if (r == null) {
            return;
        }
        object = this.callbackLock;
        synchronized (object) {
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSerially(Runnable run) {
        Vector vector2 = this.eventArguments;
        synchronized (vector2) {
            this.eventArguments.add(run);
        }
        this.queue(2);
    }

    public void waitRepaint() throws InterruptedException {
        if (Thread.currentThread() == this.eventThread) {
            return;
        }
        while (this.repaintPending) {
            Thread.sleep(1L);
        }
    }

    private void internalRepaint(int x, int y, int w, int h2) {
        this.repaintPending = false;
        try {
            IImage xRayScreenImage;
            IImage backBufferImage;
            Canvas canvas = Emulator.getCanvas();
            if (canvas == null || Emulator.getCurrentDisplay().getCurrent() != Emulator.getCanvas()) {
                return;
            }
            if (Settings.xrayView) {
                Displayable._resetXRayGraphics();
            }
            IScreen scr = Emulator.getEmulator().getScreen();
            if (canvas instanceof SpriteCanvas) {
                backBufferImage = SpriteCanvas._virtualImage.getImpl();
                xRayScreenImage = null;
            } else {
                backBufferImage = scr.getBackBufferImage();
                xRayScreenImage = scr.getXRayScreenImage();
            }
            Displayable._checkForSteps(this.callbackLock);
            try {
                if (x == -1) {
                    canvas._invokePaint(backBufferImage, xRayScreenImage);
                } else {
                    canvas._invokePaint(backBufferImage, xRayScreenImage, x, y, w, h2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (canvas instanceof SpriteCanvas) {
                if (!((SpriteCanvas)canvas)._skipCopy) {
                    backBufferImage.cloneImage(scr.getScreenImg());
                    scr.repaint();
                }
                return;
            }
            if (Settings.asyncFlush) {
                (Settings.xrayView ? xRayScreenImage : backBufferImage).cloneImage(scr.getScreenImg());
            }
            scr.repaint();
        }
        catch (Exception e2) {
            System.err.println("Exception in repaint!");
            e2.printStackTrace();
        }
    }

    void processInputEvent(int[] o) {
        if (o == null) {
            return;
        }
        Displayable d = this.getCurrent();
        if (d == null) {
            return;
        }
        boolean canv = d instanceof Canvas;
        int pointer = o[3];
        if (pointer == -1) {
            int n = o[1];
            switch (o[0]) {
                case 0: {
                    Application.internalKeyPress(n);
                    if (d.handleSoftKeyAction(n, true)) {
                        return;
                    }
                    if (canv) {
                        ((Canvas)d)._invokeKeyPressed(n);
                        break;
                    }
                    ((Screen)d)._invokeKeyPressed(n);
                    break;
                }
                case 1: {
                    Application.internalKeyRelease(n);
                    if (d.handleSoftKeyAction(n, false)) {
                        return;
                    }
                    if (canv) {
                        ((Canvas)d)._invokeKeyReleased(n);
                        break;
                    }
                    ((Screen)d)._invokeKeyReleased(n);
                    break;
                }
                case 2: {
                    if (canv) {
                        ((Canvas)d)._invokeKeyRepeated(n);
                        break;
                    }
                    ((Screen)d)._invokeKeyRepeated(n);
                }
            }
        } else {
            this.pointerNumber = String.valueOf(pointer);
            int x = o[1];
            int y = o[2];
            switch (o[0]) {
                case 0: {
                    if (canv) {
                        ((Canvas)d).invokePointerPressed(x, y);
                        break;
                    }
                    ((Screen)d)._invokePointerPressed(x, y);
                    break;
                }
                case 1: {
                    if (canv) {
                        ((Canvas)d).invokePointerReleased(x, y);
                        break;
                    }
                    ((Screen)d)._invokePointerReleased(x, y);
                    break;
                }
                case 2: {
                    if (canv) {
                        ((Canvas)d).invokePointerDragged(x, y);
                        break;
                    }
                    ((Screen)d)._invokePointerDragged(x, y);
                }
            }
            this.pointerNumber = null;
        }
    }

    private Displayable getCurrent() {
        return Emulator.getCurrentDisplay().getCurrent();
    }

    public String getPointerNumber() {
        return this.pointerNumber;
    }

    private class ScreenTimerTask
    extends TimerTask {
        private ScreenTimerTask() {
        }

        @Override
        public void run() {
            EventQueue.this.queue(4);
        }
    }

    class InputThread
    implements Runnable {
        private Object[] elements;
        private final Object readLock = new Object();
        private int count;
        private boolean added;

        private InputThread() {
            this.elements = new Object[16];
        }

        public void queue(int state, int arg1, int arg2, int pointer) {
            this.append(new int[]{state, arg1, arg2, pointer});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void append(Object o) {
            Object object = this;
            synchronized (object) {
                if (this.count + 1 >= this.elements.length) {
                    this.elements = new Object[this.elements.length * 2];
                    System.arraycopy(this.elements, 0, this.elements, 0, this.count);
                }
            }
            this.elements[this.count++] = o;
            this.added = true;
            object = this.readLock;
            synchronized (object) {
                this.readLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (EventQueue.this.running) {
                try {
                    Object object = this.readLock;
                    synchronized (object) {
                        if (!this.added) {
                            this.readLock.wait();
                        }
                    }
                    this.added = false;
                    while (Emulator.getMIDlet() == null || EventQueue.this.paused) {
                        Thread.sleep(5L);
                    }
                    while (this.count > 0) {
                        block18: {
                            try {
                                int[] o = (int[])this.elements[0];
                                if (Settings.synchronizeKeyEvents) {
                                    Object object2 = EventQueue.this.callbackLock;
                                    synchronized (object2) {
                                        EventQueue.this.processInputEvent(o);
                                        break block18;
                                    }
                                }
                                EventQueue.this.processInputEvent(o);
                            }
                            catch (Throwable e2) {
                                System.err.println("Exception in Input Thread!");
                                e2.printStackTrace();
                            }
                        }
                        InputThread e2 = this;
                        synchronized (e2) {
                            System.arraycopy(this.elements, 1, this.elements, 0, this.elements.length - 1);
                            this.elements[--this.count] = null;
                        }
                    }
                }
                catch (Throwable e3) {
                    System.err.println("Exception in Input Thread!");
                    e3.printStackTrace();
                }
            }
        }
    }
}

