/*
 * Decompiled with CFR 0.152.
 */
package emulator;

import emulator.Devices;
import emulator.Settings;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public final class KeyMapping {
    private static Hashtable deviceKeyToStr = new Hashtable();
    private static Hashtable strToPCKey = new Hashtable();
    private static Hashtable keysTable = new Hashtable();
    private static Hashtable aHashtable1067 = new Hashtable();
    public static Stack keyCacheStack = new Stack();
    public static String[] deviceKeycodes;

    public static String get(int n) {
        return KeyMapping.keyToString(deviceKeycodes[n]);
    }

    public static String keyToString(String s) {
        if (s.isEmpty()) {
            return "";
        }
        String s2 = (String)keysTable.get(s);
        if (s2 != null) {
            return s2;
        }
        int int1 = Integer.parseInt(s);
        if (int1 < 32 || int1 > 122) {
            return s2;
        }
        return String.valueOf((char)int1).toUpperCase();
    }

    public static String method601(String s) {
        if (s.isEmpty()) {
            return "";
        }
        Enumeration keys = keysTable.keys();
        String value = null;
        while (keys.hasMoreElements()) {
            String s2 = (String)keys.nextElement();
            if (!((String)keysTable.get(s2)).equalsIgnoreCase(s)) continue;
            value = s2;
            break;
        }
        if ("80".equals(value)) {
            value = "13";
        }
        if (value == null && s.length() == 1) {
            value = String.valueOf((int)s.toLowerCase().charAt(0));
        }
        return value;
    }

    public static int getArrowKeyFromDevice(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = Devices.getPropertyInt("KEY_UP") != 0 ? Devices.getPropertyInt("KEY_UP") : 1;
                break;
            }
            case 6: {
                n2 = Devices.getPropertyInt("KEY_DOWN") != 0 ? Devices.getPropertyInt("KEY_DOWN") : 6;
                break;
            }
            case 2: {
                n2 = Devices.getPropertyInt("KEY_LEFT") != 0 ? Devices.getPropertyInt("KEY_LEFT") : 2;
                break;
            }
            case 5: {
                n2 = Devices.getPropertyInt("KEY_RIGHT") != 0 ? Devices.getPropertyInt("KEY_RIGHT") : 5;
                break;
            }
            case 8: {
                n2 = Devices.getPropertyInt("KEY_FIRE") != 0 ? Devices.getPropertyInt("KEY_FIRE") : 8;
            }
        }
        return n2;
    }

    private static void method602() {
        int mid = KeyMapping.getArrowKeyFromDevice(8);
        int up = KeyMapping.getArrowKeyFromDevice(1);
        int left = KeyMapping.getArrowKeyFromDevice(2);
        int down = KeyMapping.getArrowKeyFromDevice(6);
        int right = KeyMapping.getArrowKeyFromDevice(5);
        int s1 = Devices.getPropertyInt("KEY_S1") != 0 ? Devices.getPropertyInt("KEY_S1") : 21;
        int s2 = Devices.getPropertyInt("KEY_S2") != 0 ? Devices.getPropertyInt("KEY_S2") : 22;
        strToPCKey.clear();
        strToPCKey.put("NUM_0", "48");
        strToPCKey.put("NUM_1", "49");
        strToPCKey.put("NUM_2", "50");
        strToPCKey.put("NUM_3", "51");
        strToPCKey.put("NUM_4", "52");
        strToPCKey.put("NUM_5", "53");
        strToPCKey.put("NUM_6", "54");
        strToPCKey.put("NUM_7", "55");
        strToPCKey.put("NUM_8", "56");
        strToPCKey.put("NUM_9", "57");
        strToPCKey.put("*", "42");
        strToPCKey.put("#", "35");
        strToPCKey.put("UP", String.valueOf(up));
        strToPCKey.put("DOWN", String.valueOf(down));
        strToPCKey.put("LEFT", String.valueOf(left));
        strToPCKey.put("RIGHT", String.valueOf(right));
        strToPCKey.put("MIDDLE", String.valueOf(mid));
        strToPCKey.put("S1", String.valueOf(s1));
        strToPCKey.put("S2", String.valueOf(s2));
    }

    private static void method606() {
        deviceKeyToStr.clear();
        deviceKeyToStr.put(deviceKeycodes[0], "NUM_0");
        deviceKeyToStr.put(deviceKeycodes[1], "NUM_1");
        deviceKeyToStr.put(deviceKeycodes[2], "NUM_2");
        deviceKeyToStr.put(deviceKeycodes[3], "NUM_3");
        deviceKeyToStr.put(deviceKeycodes[4], "NUM_4");
        deviceKeyToStr.put(deviceKeycodes[5], "NUM_5");
        deviceKeyToStr.put(deviceKeycodes[6], "NUM_6");
        deviceKeyToStr.put(deviceKeycodes[7], "NUM_7");
        deviceKeyToStr.put(deviceKeycodes[8], "NUM_8");
        deviceKeyToStr.put(deviceKeycodes[9], "NUM_9");
        deviceKeyToStr.put(deviceKeycodes[10], "*");
        deviceKeyToStr.put(deviceKeycodes[11], "#");
        deviceKeyToStr.put(deviceKeycodes[12], "UP");
        deviceKeyToStr.put(deviceKeycodes[13], "DOWN");
        deviceKeyToStr.put(deviceKeycodes[14], "LEFT");
        deviceKeyToStr.put(deviceKeycodes[15], "RIGHT");
        deviceKeyToStr.put(deviceKeycodes[16], "MIDDLE");
        deviceKeyToStr.put(deviceKeycodes[17], "S1");
        deviceKeyToStr.put(deviceKeycodes[18], "S2");
    }

    public static void mapDeviceKey(int n, String s) {
        if (s != null) {
            KeyMapping.deviceKeycodes[n] = s;
        }
    }

    public static boolean isLeftSoft(int n) {
        if (deviceKeycodes[17].isEmpty()) {
            return false;
        }
        String s = KeyMapping.replaceKey(Integer.parseInt(deviceKeycodes[17]));
        return s != null && Integer.parseInt(s) == n;
    }

    public static boolean isRightSoft(int n) {
        if (deviceKeycodes[18].isEmpty()) {
            return false;
        }
        String s = KeyMapping.replaceKey(Integer.parseInt(deviceKeycodes[18]));
        return s != null && Integer.parseInt(s) == n;
    }

    public static int soft1() {
        return Integer.parseInt((String)strToPCKey.get("S1"));
    }

    public static int soft2() {
        return Integer.parseInt((String)strToPCKey.get("S2"));
    }

    public static void init() {
        KeyMapping.method602();
        KeyMapping.method606();
    }

    public static String replaceKey(int n) {
        if (n == 80) {
            n = 13;
        }
        if (Settings.canvasKeyboard && n >= 48 && n <= 57) {
            return String.valueOf(n);
        }
        Object value = deviceKeyToStr.get(String.valueOf(n));
        if (value != null) {
            return (String)strToPCKey.get(value);
        }
        String method594 = KeyMapping.keyToString(String.valueOf(n));
        if (method594 == null) {
            return null;
        }
        Object value2 = aHashtable1067.get(method594);
        if (value2 == null) {
            if (Settings.canvasKeyboard && (n >= 32 && n <= 126 || n == 8)) {
                return String.valueOf(n);
            }
            return null;
        }
        return (String)value2;
    }

    public static void keyArg(String s) {
        String[] split;
        if (s == null) {
            return;
        }
        for (String string : split = s.split(";")) {
            String[] split2 = string.split("=");
            aHashtable1067.put(split2[0], split2[1]);
        }
    }

    static {
        keysTable.put("48", "NUM_0");
        keysTable.put("49", "NUM_1");
        keysTable.put("50", "NUM_2");
        keysTable.put("51", "NUM_3");
        keysTable.put("52", "NUM_4");
        keysTable.put("53", "NUM_5");
        keysTable.put("54", "NUM_6");
        keysTable.put("55", "NUM_7");
        keysTable.put("56", "NUM_8");
        keysTable.put("57", "NUM_9");
        keysTable.put("47", "Key /");
        keysTable.put("46", "Key .");
        keysTable.put("42", "Key *");
        keysTable.put("10", "F1");
        keysTable.put("11", "F2");
        keysTable.put("12", "F3");
        keysTable.put("22", "F4");
        keysTable.put("14", "F5");
        keysTable.put("15", "F6");
        keysTable.put("16", "F7");
        keysTable.put("17", "F8");
        keysTable.put("18", "F9");
        keysTable.put("19", "F10");
        keysTable.put("20", "F11");
        keysTable.put("21", "F12");
        keysTable.put("1", "UP");
        keysTable.put("2", "DOWN");
        keysTable.put("3", "LEFT");
        keysTable.put("4", "RIGHT");
        keysTable.put("5", "PageUp");
        keysTable.put("6", "PageDown");
        keysTable.put("7", "Home");
        keysTable.put("8", "End");
        keysTable.put("9", "Insert");
        keysTable.put("13", "Enter");
        keysTable.put("80", "Enter");
        deviceKeycodes = new String[]{"48", "55", "56", "57", "52", "53", "54", "49", "50", "51", "42", "47", "1", "2", "3", "4", "13", "10", "11"};
    }
}

