/*
 * Decompiled with CFR 0.152.
 */
package emulator;

import emulator.custom.ResourceManager;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import ru.nnproject.kemulator.notificationapi.AbstractNotification;
import ru.nnproject.kemulator.notificationapi.NotificationException;

public class NotificationImpl
implements AbstractNotification {
    private SystemTray tray;
    private TrayIcon trayIcon;
    private String name;

    public NotificationImpl(String name) {
        this.name = name;
    }

    @Override
    public void createTrayIcon(String tooltip, String imgpath) throws NotificationException {
        try {
            this.tray = SystemTray.getSystemTray();
            BufferedImage image = imgpath != null ? ImageIO.read(ResourceManager.getResourceAsStream(imgpath)) : ImageIO.read(this.getClass().getResourceAsStream("/res/icon"));
            this.trayIcon = new TrayIcon(image, tooltip);
            this.trayIcon.setImageAutoSize(true);
            this.tray.add(this.trayIcon);
        }
        catch (Exception ex) {
            throw new NotificationException("Failed to create tray icon " + ex.toString());
        }
    }

    @Override
    public void displayMessage(String title, String subtitle, int type) throws NotificationException {
        TrayIcon.MessageType mt;
        if (title == null) {
            title = this.name;
        }
        if (subtitle == null) {
            throw new NotificationException("Subtitle cannot be null");
        }
        switch (type) {
            case 0: {
                mt = TrayIcon.MessageType.INFO;
                break;
            }
            case 1: {
                mt = TrayIcon.MessageType.WARNING;
                break;
            }
            case 2: {
                mt = TrayIcon.MessageType.ERROR;
                break;
            }
            case 3: {
                mt = TrayIcon.MessageType.NONE;
                break;
            }
            default: {
                throw new NotificationException("Invalid message type");
            }
        }
        this.trayIcon.displayMessage(title, subtitle, mt);
    }

    @Override
    public void displayMessage(String text, int type) throws NotificationException {
        this.displayMessage(null, text, type);
    }
}

