/*
 * Decompiled with CFR 0.152.
 */
package emulator;

import emulator.Emulator;
import emulator.Settings;
import emulator.UILocale;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class Permission {
    public static final int ask_always = 0;
    public static final int ask_always_until_yes = 1;
    public static final int allowed = 2;
    public static final int never = 3;
    public static final int ask_always_until_no = 4;
    public static final int ask_once = 5;
    private static final Vector<String> allowPerms = new Vector();
    private static final Vector<String> notAllowPerms = new Vector();
    public static final Map<String, Integer> permissions = new HashMap<String, Integer>();
    private static String imei;
    public static boolean askPermissions;
    public static boolean askImei;

    public static int getPermissionLevel(String s) {
        if (!Settings.enableSecurity) {
            return 2;
        }
        if (permissions.containsKey(s = s.toLowerCase())) {
            return permissions.get(s);
        }
        if (s.equals("messageconnection.send") || s.equals("messageconnection.receive") || s.equals("connector.open.http") || s.equals("connector.open.file") || s.equals("connector.open.socket") || s.equals("connector.open.serversocket") || s.equals("connector.open.sms") || s.equals("location")) {
            return 2;
        }
        if (s.equals("media.camera") || s.equals("platformrequest")) {
            return 4;
        }
        return 1;
    }

    public static String getPermissionLevelString(String s) {
        switch (Permission.getPermissionLevel(s)) {
            case 0: {
                return "ask_always";
            }
            case 1: {
                return "ask_always_until_yes";
            }
            case 2: {
                return "allowed";
            }
            case 3: {
                return "never";
            }
            case 4: {
                return "ask_always_until_no";
            }
            case 5: {
                return "ask_once";
            }
        }
        return "unknown";
    }

    public static int fromString(String s) {
        if ("ask_always".equals(s)) {
            return 0;
        }
        if ("ask_always_until_yes".equals(s)) {
            return 1;
        }
        if ("allowed".equals(s)) {
            return 2;
        }
        if ("never".equals(s)) {
            return 3;
        }
        if ("ask_always_until_no".equals(s)) {
            return 4;
        }
        if ("ask_once".equals(s)) {
            return 5;
        }
        return 4;
    }

    public static synchronized String askIMEI() {
        if (notAllowPerms.contains("imei")) {
            return null;
        }
        if (!askImei) {
            return "0000000000000000";
        }
        if (imei != null) {
            return imei;
        }
        String s = Emulator.getEmulator().getScreen().showIMEIDialog();
        if (s == null) {
            notAllowPerms.add("imei");
        }
        allowPerms.add("imei");
        imei = s;
        return imei;
    }

    public static boolean showConfirmDialog(String message) {
        return Emulator.getEmulator().getScreen().showSecurityDialog(message);
    }

    public static void checkPermission(String x) {
        switch (Permission.getPermissionLevel(x)) {
            case 0: {
                if (!Permission.showConfirmDialog(Permission.localizePerm(x))) {
                    throw new SecurityException(x);
                }
                allowPerms.add(x);
                break;
            }
            case 1: {
                if (allowPerms.contains(x)) {
                    return;
                }
                if (!Permission.showConfirmDialog(Permission.localizePerm(x))) {
                    throw new SecurityException(x);
                }
                allowPerms.add(x);
            }
            default: {
                break;
            }
            case 3: {
                throw new SecurityException(x);
            }
            case 4: {
                if (notAllowPerms.contains(x)) {
                    return;
                }
                if (!Permission.showConfirmDialog(Permission.localizePerm(x))) {
                    notAllowPerms.add(x);
                    throw new SecurityException(x);
                }
                allowPerms.add(x);
                break;
            }
            case 5: {
                if (notAllowPerms.contains(x)) {
                    throw new SecurityException(x);
                }
                if (allowPerms.contains(x)) {
                    return;
                }
                if (!Permission.showConfirmDialog(Permission.localizePerm(x))) {
                    notAllowPerms.add(x);
                    throw new SecurityException(x);
                }
                allowPerms.add(x);
            }
        }
    }

    private static String localizePerm(String x) {
        if (x.equals("connector.open.http")) {
            return "Allow the application to open HTTP connections?";
        }
        if (x.equals("connector.open.file")) {
            return "Allow the application to access the file system?";
        }
        if (x.equals("connector.open.socket")) {
            return "Allow the application to open socket connections?";
        }
        if (x.equals("connector.open.serversocket")) {
            return "Allow the application to open server socket connections?";
        }
        if (x.equals("media.camera")) {
            return UILocale.get("PERMISSION_CAMERA", "Allow the application to use camera?");
        }
        return "Allow the application to use '" + x + "'?";
    }

    public static boolean requestURLAccess(String url) {
        switch (Permission.getPermissionLevel("platformrequest")) {
            case 3: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        if (url.length() > 100) {
            url = url.substring(0, 100) + "...";
        }
        String text = url.startsWith("vlc:") ? UILocale.get("PLATFORMREQUEST_VLC_ALERT", "Application wants to open URL in VLC") + ": " + url.substring(4) : UILocale.get("PLATFORMREQUEST_ALERT", "Application wants to open URL") + ": " + url;
        return Emulator.getEmulator().getScreen().showSecurityDialog(text);
    }

    static {
        askPermissions = true;
        askImei = true;
    }
}

