/*
 * Decompiled with CFR 0.152.
 */
package emulator;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.MessageDigest;

public class Utils {
    public static final String os = String.valueOf(System.getProperty("os.name")).toLowerCase();
    public static final boolean win = os.startsWith("win");
    public static final boolean linux = os.contains("linux") || os.contains("nix");
    public static final boolean macos = os.contains("mac");
    public static final boolean termux = String.valueOf(System.getProperty("java.vm.vendor")).toLowerCase().contains("termux");

    public static String translateEscapes(String input) {
        if (input.isEmpty()) {
            return "";
        }
        char[] chars = input.toCharArray();
        int length = chars.length;
        int from = 0;
        int to = 0;
        block13: while (from < length) {
            int ch;
            if ((ch = chars[from++]) == 92) {
                ch = from < length ? chars[from++] : 0;
                switch (ch) {
                    case 10: {
                        continue block13;
                    }
                    case 13: {
                        if (from >= length || chars[from] != '\n') continue block13;
                        ++from;
                        continue block13;
                    }
                    case 34: 
                    case 39: 
                    case 92: {
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        int limit = Integer.min(from + (ch <= 51 ? 2 : 1), length);
                        int code = ch - 48;
                        while (from < limit && (ch = chars[from]) >= 48 && 55 >= ch) {
                            ++from;
                            code = code << 3 | ch - 48;
                        }
                        ch = (char)code;
                        break;
                    }
                    case 98: {
                        ch = 8;
                        break;
                    }
                    case 102: {
                        ch = 12;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 114: {
                        ch = 13;
                        break;
                    }
                    case 115: {
                        ch = 32;
                        break;
                    }
                    case 116: {
                        ch = 9;
                        break;
                    }
                    case 58: {
                        ch = 58;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(input);
                    }
                }
            }
            chars[to++] = ch;
        }
        return new String(chars, 0, to);
    }

    public static boolean isPathAbsolute(String path) {
        if (path.isEmpty()) {
            return false;
        }
        if (path.charAt(0) == '/') {
            return true;
        }
        if (path.length() <= 2) {
            return false;
        }
        if (path.charAt(0) == '\\' && path.charAt(1) == '\\') {
            return true;
        }
        if (path.length() <= 3) {
            return false;
        }
        if (path.charAt(1) == ':' && (path.charAt(2) == '/' || path.charAt(2) == '\\')) {
            char letter = Character.toUpperCase(path.charAt(0));
            return letter >= 'A' && letter <= 'Z';
        }
        return false;
    }

    public static int getJavaVersionMajor() {
        try {
            return Integer.parseInt(System.getProperty("java.version").split("\\.")[0]);
        }
        catch (Throwable e2) {
            return 0;
        }
    }

    public static boolean isJava9() {
        try {
            return Utils.getJavaVersionMajor() >= 9;
        }
        catch (Throwable e2) {
            return false;
        }
    }

    public static boolean isJava17() {
        try {
            return Utils.getJavaVersionMajor() >= 17;
        }
        catch (Throwable e2) {
            return false;
        }
    }

    public static String getJdkHome() {
        String realHome = System.getProperty("java.home");
        String[] stringArray = new String[2];
        stringArray[0] = "bin";
        String string = stringArray[1] = win ? "javac.exe" : "javac";
        if (Files.exists(Paths.get(realHome, stringArray), new LinkOption[0])) {
            return realHome;
        }
        String parent = Paths.get(realHome, new String[0]).getParent().toString();
        String[] stringArray2 = new String[2];
        stringArray2[0] = "bin";
        String string2 = stringArray2[1] = win ? "javac.exe" : "javac";
        if (Files.exists(Paths.get(parent, stringArray2), new LinkOption[0])) {
            return parent;
        }
        return null;
    }

    public static String getProcessOutput(String[] commandline, boolean errStream) throws IOException {
        Process proc = Runtime.getRuntime().exec(commandline);
        StringBuilder sw = new StringBuilder();
        try (InputStream is = errStream ? proc.getErrorStream() : proc.getInputStream();){
            int c2;
            while ((c2 = is.read()) != -1) {
                sw.append((char)c2);
            }
        }
        return sw.toString();
    }

    static String getHWID() {
        try {
            byte[] b2;
            String s = System.getenv("COMPUTERNAME") + System.getProperty("user.name") + System.getenv("PROCESSOR_IDENTIFIER") + System.getenv("PROCESSOR_LEVEL");
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes());
            StringBuffer sb = new StringBuffer();
            for (byte aByteData : b2 = md.digest()) {
                String hex = Integer.toHexString(0xFF & aByteData);
                if (hex.length() == 1) {
                    sb.append('0');
                }
                sb.append(hex);
            }
            return sb.toString();
        }
        catch (Exception e2) {
            return "null";
        }
    }
}

