/*
 * Decompiled with CFR 0.152.
 */
package emulator.custom;

import emulator.Emulator;
import emulator.Settings;
import emulator.custom.CustomClassLoader;
import emulator.custom.CustomMethodAdapter;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public final class CustomClassAdapter
extends ClassVisitor
implements Opcodes {
    static boolean hasRenamedMethods;
    static Set<String> renamedClasses;
    private String className;
    private String parentClassName;

    @Override
    public final MethodVisitor visitMethod(int acc, String name, String desc, String sign, String[] array) {
        MethodVisitor visitMethod;
        block20: {
            String s5;
            String s4;
            block15: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block14: {
                                    s4 = "java/util/TimerTask";
                                    if (!desc.contains("java/util/TimerTask")) break block14;
                                    s5 = "emulator/custom/subclass/SubTimerTask";
                                    break block15;
                                }
                                s4 = "java/util/Timer";
                                if (!desc.contains("java/util/Timer")) break block16;
                                s5 = "emulator/custom/subclass/Timer";
                                break block15;
                            }
                            s4 = "com/gcjsp/v10/";
                            if (desc.contains("com/gcjsp/v10/")) break block17;
                            s4 = "tw/com/fareastone/v10/";
                            if (!desc.contains("tw/com/fareastone/v10/")) break block18;
                        }
                        s5 = "com/vodafone/v10/";
                        break block15;
                    }
                    s4 = "com/bmc/media/";
                    if (!desc.contains("com/bmc/media/")) break block19;
                    s5 = "com/sprintpcs/media/";
                    break block15;
                }
                s4 = "com/docomostar/";
                if (!desc.contains("com/docomostar/")) break block20;
                s5 = "com/nttdocomo/";
            }
            desc = desc.replace(s4, s5);
        }
        if (Settings.patchSynchronizedPaint && "paint".equals(name) && "(Ljavax/microedition/lcdui/Graphics;)V".equals(desc)) {
            if ((acc & 0x20) != 0) {
                acc &= 0xFFFFFFDF;
                Emulator.getEmulator().getLogStream().println("Patched paint method: " + this.className);
            }
        } else if (Settings.patchSynchronizedPlayerUpdate && "playerUpdate".equals(name) && "(Ljavax/microedition/media/Player;Ljava/lang/String;Ljava/lang/Object;)V".equals(desc)) {
            if ((acc & 0x20) != 0) {
                acc &= 0xFFFFFFDF;
                Emulator.getEmulator().getLogStream().println("Patched playerUpdate method: " + this.className);
            }
        } else if ("()V".equals(desc) && "java/lang/Thread".equals(this.parentClassName) && ("stop".equals(name) || "resume".equals(name) || "suspend".equals(name))) {
            Emulator.getEmulator().getLogStream().println("Patched illegal Thread method name: " + this.className);
            hasRenamedMethods = true;
            renamedClasses.add(this.className.replace('.', '/'));
            name = name + "_";
        } else if (Settings.bypassVserv && "()V".equals(desc) && "startRealApp".equals(name) && acc == 2) {
            Emulator.getEmulator().getLogStream().println("Patched ALW1: " + this.className);
            acc = 1;
        }
        if ((visitMethod = super.visitMethod(acc, name, desc, sign, array)) != null) {
            return new CustomMethodAdapter(visitMethod, this.className, name, desc);
        }
        return null;
    }

    public CustomClassAdapter(ClassVisitor classVisitor, String aString1165) {
        super(262144, classVisitor);
        this.className = aString1165;
    }

    @Override
    public final void visit(int n, int n2, String s, String s2, String s3, String[] array) {
        this.parentClassName = s3;
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2].startsWith("com/gcjsp/v10/")) {
                array[i2] = array[i2].replace("com/gcjsp/v10/", "com/vodafone/v10/");
                continue;
            }
            if (array[i2].startsWith("com/fareastone/v10/")) {
                array[i2] = array[i2].replace("com/fareastone/v10/", "com/vodafone/v10/");
                continue;
            }
            if (array[i2].startsWith("com/bmc/media/")) {
                array[i2] = array[i2].replace("com/bmc/media/", "com/sprintpcs/media/");
                continue;
            }
            if (!array[i2].startsWith("com/docomostar/")) continue;
            array[i2] = array[i2].replace("com/docomostar/", "com/nttdocomo/");
        }
        if (s3.equals("java/util/TimerTask")) {
            this.visit(n, n2, s, s2, "emulator/custom/subclass/SubTimerTask", array);
            return;
        }
        if (s3.equals("java/util/Timer")) {
            this.visit(n, n2, s, s2, "emulator/custom/subclass/Timer", array);
            return;
        }
        if (s3.startsWith("com/gcjsp/v10/")) {
            this.visit(n, n2, s, s2, s3.replace("com/gcjsp/v10/", "com/vodafone/v10/"), array);
            return;
        }
        if (s3.startsWith("tw/com/fareastone/v10/")) {
            this.visit(n, n2, s, s2, s3.replace("tw/com/fareastone/v10/", "com/vodafone/v10/"), array);
            return;
        }
        if (s3.startsWith("com/bmc/media/")) {
            this.visit(n, n2, s, s2, s3.replace("com/bmc/media/", "com/sprintpcs/media/"), array);
            return;
        }
        if (s3.startsWith("com/docomostar/")) {
            this.visit(n, n2, s, s2, s3.replace("com/docomostar/", "com/nttdocomo/"), array);
            return;
        }
        if (CustomClassLoader.isProtected(s3.replace('/', '.'), false)) {
            s3 = "__".concat(s3);
        }
        super.visit(n, n2, s, s2, s3, array);
    }

    @Override
    public final FieldVisitor visitField(int n, String s, String s2, String s3, Object o) {
        if (s2.contains("java/util/TimerTask")) {
            s2 = s2.replace("java/util/TimerTask", "emulator/custom/subclass/SubTimerTask");
        } else if (s2.contains("java/util/Timer")) {
            s2 = s2.replace("java/util/Timer", "emulator/custom/subclass/Timer");
        } else if (s2.contains("com/gcjsp/v10/")) {
            s2 = s2.replace("com/gcjsp/v10/", "com/vodafone/v10/");
        } else if (s2.contains("tw/com/fareastone/v10/")) {
            s2 = s2.replace("tw/com/fareastone/v10/", "com/vodafone/v10/");
        } else if (s2.contains("com/bmc/media/")) {
            s2 = s2.replace("com/bmc/media/", "com/sprintpcs/media/");
        } else if (s2.contains("com/docomostar/")) {
            s2 = s2.replace("com/docomostar/", "com/nttdocomo/");
        }
        return super.visitField(n, s, s2, s3, o);
    }

    static {
        renamedClasses = new HashSet<String>();
    }
}

