/*
 * Decompiled with CFR 0.152.
 */
package emulator.custom;

import emulator.Emulator;
import emulator.Settings;
import emulator.custom.CustomClassAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class CustomClassLoader
extends ClassLoader {
    public CustomClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public final synchronized Class loadClass(String s, boolean b2) throws ClassNotFoundException {
        boolean midlet = Emulator.jarClasses.contains(s);
        if (!midlet && CustomClassLoader.isProtected(s, true)) {
            Emulator.getEmulator().getLogStream().println("Protected class: " + s);
            throw new ClassNotFoundException("Protected class: " + s);
        }
        Class<?> loadedClass = this.findLoadedClass(s);
        if (loadedClass != null) {
            return loadedClass;
        }
        if (!midlet) {
            try {
                return super.loadClass(s, b2);
            }
            catch (ClassNotFoundException ex) {
                Class method806 = this.loadLibraryClass(s);
                if (method806 == null) {
                    throw ex;
                }
                return method806;
            }
        }
        Class class1 = this.findClass(s);
        if (b2) {
            this.resolveClass(class1);
        }
        return class1;
    }

    private Class loadLibraryClass(String s) {
        Class<?> defineClass = null;
        try {
            for (int i2 = 0; i2 < Emulator.jarLibrarys.size(); ++i2) {
                ZipFile zipFile = new ZipFile((String)Emulator.jarLibrarys.get(i2));
                ZipEntry entry = zipFile.getEntry(s.replace('.', '/') + ".class");
                if (entry == null) continue;
                ClassReader classReader = new ClassReader(zipFile.getInputStream(entry));
                ClassWriter classWriter = new ClassWriter(0);
                classReader.accept(new ClassVisitor(262144, classWriter){}, Settings.asmSkipDebug ? 2 : 0);
                byte[] byteArray = classWriter.toByteArray();
                defineClass = this.defineClass(s, byteArray, 0, byteArray.length);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return defineClass;
    }

    protected final Class findClass(String s) throws ClassNotFoundException {
        Class<?> defineClass;
        try {
            byte[] bytes;
            try {
                bytes = this.load(s);
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                if (Settings.asmSkipDebug) {
                    throw e2;
                }
                Settings.asmSkipDebug = true;
                bytes = this.load(s);
            }
            try {
                defineClass = this.defineClass(s, bytes, 0, bytes.length);
            }
            catch (ClassFormatError e3) {
                if (Settings.asmSkipDebug) {
                    throw e3;
                }
                Settings.asmSkipDebug = true;
                bytes = this.load(s);
                defineClass = this.defineClass(s, bytes, 0, bytes.length);
            }
        }
        catch (ClassNotFoundException e4) {
            return super.findClass(s);
        }
        catch (Exception e5) {
            e5.printStackTrace();
            return super.findClass(s);
        }
        return defineClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] load(String s) throws Exception {
        InputStream inputStream;
        if (Emulator.midletJar == null) {
            File fileFromClassPath = Emulator.getFileFromClassPath(s.replace('.', '/') + ".class");
            if (fileFromClassPath == null || !fileFromClassPath.exists()) {
                throw new ClassNotFoundException();
            }
            inputStream = new FileInputStream(fileFromClassPath);
        } else {
            ZipFile zipFile = new ZipFile(Emulator.midletJar);
            ZipEntry entry = zipFile.getEntry(s.replace('.', '/') + ".class");
            if (entry == null) {
                throw new ClassNotFoundException();
            }
            inputStream = zipFile.getInputStream(entry);
        }
        ClassReader classReader = new ClassReader(inputStream);
        ClassWriter classWriter = new ClassWriter(0);
        try {
            classReader.accept(new CustomClassAdapter(classWriter, s), Settings.asmSkipDebug ? 2 : 0);
        }
        finally {
            inputStream.close();
        }
        return classWriter.toByteArray();
    }

    public static boolean isProtected(String s, boolean stack) {
        StackTraceElement[] st;
        if (!Settings.hideEmulation && (Settings.protectedPackages == null || Settings.protectedPackages.isEmpty())) {
            return false;
        }
        if (s.startsWith("__")) {
            return true;
        }
        if (stack && (st = Thread.currentThread().getStackTrace()).length > 4 && !Emulator.jarClasses.contains(st[4].getClassName()) && (!st[4].getMethodName().equals("forName0") || st.length > 6 && !Emulator.jarClasses.contains(st[6].getClassName()))) {
            return false;
        }
        if (Settings.protectedPackages.contains(s) || Settings.hideEmulation && !s.startsWith("emulator.custom.") && s.startsWith("emulator.") && !Emulator.jarClasses.contains(s)) {
            return true;
        }
        if (Settings.hideEmulation && (s.startsWith("java.applet") || s.startsWith("java.awt") || s.startsWith("java.swing") || s.startsWith("org.eclipse.swt") || s.startsWith("ru.nnproject") || s.startsWith("java.lang.CharSequence") || s.startsWith("java.util.Collection") || s.startsWith("java.util.ArrayList") || s.startsWith("java.lang.ClassLoader") || s.startsWith("java.util.Map"))) {
            return true;
        }
        int idx = -1;
        while ((idx = s.indexOf(46, idx + 1)) != -1) {
            if (!Settings.protectedPackages.contains(s.substring(0, idx))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final InputStream getResourceAsStream(String s) {
        return super.getResourceAsStream(s);
    }
}

