/*
 * Decompiled with CFR 0.152.
 */
package emulator.custom;

import com.github.sarxos.webcam.Webcam;
import emulator.Emulator;
import emulator.Permission;
import emulator.Settings;
import emulator.custom.CustomClassLoader;
import emulator.custom.ResourceManager;
import emulator.custom.h;
import emulator.debug.Profiler;
import emulator.graphics3D.lwjgl.Emulator3D;
import emulator.ui.swt.EmulatorScreen;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import javax.microedition.media.Manager;

public class CustomMethod {
    private static long aLong13;
    private static long aLong17;
    private static Hashtable aHashtable14;
    private static Thread aThread15;
    static String trackStr;
    private static BufferedWriter trackWriter;
    private static FileWriter fw;

    public static void gc() {
        ++Profiler.gcCallCount;
        if (!Settings.ignoreGc) {
            System.gc();
        }
    }

    public static void yield() throws InterruptedException {
        if (Settings.patchYield) {
            Thread.sleep(1L);
        } else {
            Thread.yield();
        }
    }

    public static void sleep(long t) throws InterruptedException {
        if (Settings.ignoreSleep) {
            return;
        }
        if (Settings.applySpeedToSleep && Settings.speedModifier != 1 && t > 1L) {
            t = Settings.speedModifier < 0 ? (t *= (100L - (long)Settings.speedModifier * 1024L) / 100L) : (t /= (long)Settings.speedModifier);
        }
        Thread.sleep(t);
    }

    public static String getProperty(String prop) {
        String res = System.getProperty(prop);
        boolean b2 = true;
        if (Settings.systemProperties != null && Settings.systemProperties.containsKey(prop)) {
            res = Settings.systemProperties.get(prop);
            if (res.startsWith(":")) {
                res = (res = res.substring(1)).equals("null") ? null : System.getProperty(res);
            }
        } else {
            block66: {
                if (prop.equalsIgnoreCase("fileconn.dir.private")) {
                    res = "file://root/private_" + Emulator.midletClassName.replace("\\", "_").replace("/", "_").replace(".", "_") + "/";
                } else if (prop.equalsIgnoreCase("user.name")) {
                    res = Settings.hideEmulation ? null : "KEmulator";
                } else if (prop.equalsIgnoreCase("console.encoding")) {
                    res = System.getProperty("file.encoding");
                } else if (prop.equalsIgnoreCase("com.nokia.mid.networkavailability")) {
                    res = Settings.networkNotAvailable ? "unavailable" : "available";
                } else if (prop.equalsIgnoreCase("com.nokia.mid.batterylevel")) {
                    res = "80";
                } else if (prop.startsWith("com.nokia.memoryram")) {
                    b2 = false;
                    Runtime r = Runtime.getRuntime();
                    if (prop.equals("com.nokia.memoryramfree")) {
                        res = String.valueOf(r.freeMemory() + r.maxMemory() - r.totalMemory());
                    } else if (prop.equals("com.nokia.memoryramtotal")) {
                        res = String.valueOf(r.maxMemory());
                    }
                } else if ((prop.equalsIgnoreCase("com.nokia.mid.imei") || prop.equalsIgnoreCase("com.nokia.imei")) && !Settings.protectedPackages.contains("com.nokia.mid") || prop.equalsIgnoreCase("device.imei") || prop.equalsIgnoreCase("phone.imei") || prop.equalsIgnoreCase("com.sonyericsson.imei") && !Settings.protectedPackages.contains("com.sonyericsson") || prop.equalsIgnoreCase("com.samsung.imei") && !Settings.protectedPackages.contains("com.samsung") || prop.equalsIgnoreCase("com.siemens.IMEI") && !Settings.protectedPackages.contains("com.siemens")) {
                    res = Permission.askIMEI();
                } else if (prop.equals("com.nokia.pointer.number")) {
                    b2 = false;
                    try {
                        res = Emulator.getEventQueue().getPointerNumber();
                    }
                    catch (Exception r) {}
                } else if (prop.equals("microedition.locale")) {
                    res = Settings.locale;
                } else if (prop.equals("microedition.encoding")) {
                    res = Settings.fileEncoding;
                } else if (prop.equals("Platform")) {
                    res = "";
                } else if (prop.equals("fileconn.dir.roots.names")) {
                    res = "Root";
                } else if (prop.startsWith("kemulator")) {
                    if (Settings.hideEmulation) {
                        res = null;
                    } else {
                        try {
                            if (prop.equals("kemulator.libvlc.supported")) {
                                res = String.valueOf(Manager.isLibVlcSupported());
                            } else if (prop.equals("kemulator.threadtrace")) {
                                b2 = false;
                                res = CustomMethod.getStackTrace(new Exception("Trace")).replace("\t", "").replace("\r", "");
                            } else if (prop.equals("kemulator.touch.enabled")) {
                                res = String.valueOf(((EmulatorScreen)Emulator.getEmulator().getScreen()).getTouchEnabled());
                            } else if (prop.startsWith("kemulator.set.title=")) {
                                res = prop.substring(prop.indexOf(61) + 1);
                                if (res.equals("null")) {
                                    res = null;
                                }
                                Settings.customTitle = res;
                                Emulator.getEmulator().getScreen().updateTitle();
                                res = "true";
                            }
                        }
                        catch (Exception r) {}
                    }
                } else if (res == null && (prop.equals("supports.video.capture") || prop.equals("supports.photo.capture") || prop.equals("supports.mediacapabilities") || prop.equals("camera.orientations") || prop.equals("camera.resolutions"))) {
                    block67: {
                        if (!Emulator.getPlatform().isX64() && System.getProperty("kemulator.disablecamera") == null && !Settings.disableCamera) {
                            try {
                                Webcam w = Webcam.getDefault();
                                if (w == null) break block67;
                                System.setProperty("supports.video.capture", "true");
                                System.setProperty("supports.photo.capture", "true");
                                System.setProperty("supports.mediacapabilities", "camera");
                                System.setProperty("camera.orientations", "devcam0:inwards");
                                Dimension d = w.getViewSize();
                                System.setProperty("camera.resolutions", "devcam0:" + d.width + "x" + d.height);
                                res = System.getProperty(prop);
                                break block66;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    if (prop.equals("supports.video.capture") || prop.equals("supports.photo.capture")) {
                        res = "false";
                    }
                } else if (Settings.hideEmulation && (prop.startsWith("os.") || prop.startsWith("java.") || prop.startsWith("sun."))) {
                    res = null;
                }
            }
            if (!Settings.protectedPackages.isEmpty()) {
                if (CustomClassLoader.isProtected(prop, false) || CustomClassLoader.isProtected("javax." + prop, false)) {
                    res = null;
                } else if (prop.startsWith("com.nokia") && Settings.protectedPackages.contains("com.nokia.mid")) {
                    res = null;
                } else if (prop.startsWith("bluetooth") && Settings.protectedPackages.contains("javax.microedition.bluetooth")) {
                    res = null;
                } else if (prop.startsWith("fileconn") && Settings.protectedPackages.contains("javax.microedition.io.file")) {
                    res = null;
                } else if (prop.startsWith("kemulator.rpc") && Settings.protectedPackages.contains("ru.nnproject.kemulator.rpc")) {
                    res = null;
                } else if (prop.startsWith("kemulator.notificationapi") && Settings.protectedPackages.contains("ru.nnproject.kemulator.notificationapi")) {
                    res = null;
                }
            }
        }
        if (b2) {
            Emulator.getEmulator().getLogStream().println("System.getProperty#" + prop + "=" + res);
        }
        return res;
    }

    public static long currentTimeMillis() {
        long n;
        ++Profiler.currentTimeMillisCallCount;
        long currentTimeMillis = System.currentTimeMillis();
        long n2 = Settings.speedModifier;
        long l = n = n2 < 0L ? (100L + n2 << 10) / 100L : n2 << 10;
        if (Settings.aLong1235 > 0L) {
            aLong13 += n * (currentTimeMillis - aLong17 - Settings.aLong1235) >> 10;
            aLong17 = currentTimeMillis;
            Settings.aLong1235 = 0L;
        } else {
            aLong13 += n * (currentTimeMillis - aLong17) >> 10;
            aLong17 = currentTimeMillis;
        }
        return aLong13;
    }

    public static InputStream getResourceAsStream(Object o, String s) {
        return ResourceManager.getResourceAsStream(o, s);
    }

    public static void showTrackInfo(String s) {
        if (Settings.threadMethodTrack) {
            System.out.print(s);
            if (trackWriter != null) {
                try {
                    trackWriter.append(s);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    private static int method16() {
        int n;
        Thread currentThread = Thread.currentThread();
        if (aThread15 != null && aThread15 != currentThread) {
            n = 0;
            trackStr = "=====" + currentThread.toString() + "=====\n";
            CustomMethod.showTrackInfo(trackStr);
        } else {
            Integer value = (Integer)aHashtable14.get(currentThread);
            n = value == null ? 0 : value;
        }
        aHashtable14.put(currentThread, n + 1);
        aThread15 = currentThread;
        return n;
    }

    private static void method17() {
        Thread currentThread = Thread.currentThread();
        Object value = aHashtable14.get(currentThread);
        if (value != null) {
            aHashtable14.put(currentThread, Math.max((Integer)value - 1, 0));
        }
    }

    public static void beginMethod(String s) {
        h.MethodInfo methodInfo;
        if (h.aHashtable1061 == null) {
            h.aHashtable1061 = new Hashtable();
            h.method591();
        }
        if ((methodInfo = (h.MethodInfo)h.aHashtable1061.get(s)) != null) {
            int method16 = CustomMethod.method16();
            ++methodInfo.anInt1182;
            trackStr = "";
            for (int i2 = 0; i2 < method16; ++i2) {
                trackStr = trackStr + "  ";
            }
            trackStr = trackStr + s + "\n";
            CustomMethod.showTrackInfo(trackStr);
            methodInfo.aLong1174 = System.currentTimeMillis();
        }
    }

    public static void endMethod(String s) {
        h.MethodInfo methodInfo = (h.MethodInfo)h.aHashtable1061.get(s);
        if (methodInfo != null) {
            if (methodInfo.anInt1182 > 0) {
                methodInfo.aLong1179 += System.currentTimeMillis() - methodInfo.aLong1174;
                methodInfo.aFloat1175 = (float)methodInfo.aLong1179 / (float)methodInfo.anInt1182;
            }
            CustomMethod.method17();
        }
    }

    public static void exit(int i2) {
        Emulator.getMIDlet().notifyDestroyed();
    }

    public static void close() {
        try {
            Emulator.getEventQueue().stop();
            Emulator3D.exit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (trackWriter != null) {
            try {
                trackWriter.close();
                trackWriter = null;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static String getStackTrace(Throwable t) {
        String res = null;
        if (t != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                t.printStackTrace(new PrintStream(baos));
                res = baos.toString();
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
        return res;
    }

    public static void checkFloat() {
        if (CustomClassLoader.isProtected("java.lang.Float", true)) {
            throw new Error("Float usage restricted");
        }
    }

    public static void checkDouble() {
        if (CustomClassLoader.isProtected("java.lang.Double", true)) {
            throw new Error("Double usage restricted");
        }
    }

    public static Class forName(String s) throws ClassNotFoundException {
        if (Settings.hideEmulation && s.startsWith("emulator.custom.") || CustomClassLoader.isProtected(s, false)) {
            throw new ClassNotFoundException(s);
        }
        return Class.forName(s, true, Emulator.getCustomClassLoader());
    }

    public static long totalMemory(Object runtime) {
        return 0x200000L;
    }

    public static long freeMemory(Object runtime) {
        return Math.max(((Runtime)runtime).freeMemory(), 0x100000L + System.currentTimeMillis() % 1024L);
    }

    static {
        aHashtable14 = new Hashtable();
        try {
            fw = new FileWriter(Emulator.getUserPath() + "/track.txt", false);
            trackWriter = new BufferedWriter(fw);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        trackStr = "";
    }
}

